/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject {
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return runtime.getNil();
        }
    };

    public RubyNil(Ruby runtime) {
        super(runtime, runtime.getNilClass(), false);
        this.flags |= 3;
    }

    public static RubyClass createNilClass(Ruby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject(), NIL_ALLOCATOR);
        runtime.setNilClass(nilClass);
        nilClass.index = 5;
        nilClass.setReifiedClass(RubyNil.class);
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 5;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Void.TYPE;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject recv2) {
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject recv2) {
        return RubyFloat.newFloat(recv2.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject recv2) {
        return RubyString.newEmptyString(recv2.getRuntime());
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject recv2) {
        return recv2.getRuntime().newEmptyArray();
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        if (runtime.is1_9()) {
            return RubyString.newUSASCIIString(runtime, "nil");
        }
        return RubyString.newString(runtime, "nil");
    }

    @JRubyMethod(name={"type"}, compat=CompatVersion.RUBY1_8)
    public static RubyClass type(IRubyObject recv2) {
        return recv2.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4);
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_c(ThreadContext context, IRubyObject recv2) {
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_r(ThreadContext context, IRubyObject recv2) {
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"rationalize"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rationalize(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyNil.to_r(context, recv2);
    }

    @Override
    public Object toJava(Class target) {
        if (target.isPrimitive()) {
            if (target == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (target == Byte.TYPE) {
                return (byte)0;
            }
            if (target == Short.TYPE) {
                return (short)0;
            }
            if (target == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (target == Integer.TYPE) {
                return 0;
            }
            if (target == Long.TYPE) {
                return 0L;
            }
            if (target == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (target == Double.TYPE) {
                return 0.0;
            }
        }
        return null;
    }
}

