/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public abstract class MemoryIO {
    final Foreign foreign = Foreign.getInstance();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MemoryIO() {
    }

    private static MemoryIO newMemoryIO() {
        try {
            return !Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable() ? MemoryIO.newUnsafeImpl() : MemoryIO.newNativeImpl();
        }
        catch (Throwable t) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static MemoryIO newNativeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newNativeImpl32() : MemoryIO.newNativeImpl64();
    }

    private static MemoryIO newNativeImpl32() {
        return new NativeImpl32();
    }

    private static MemoryIO newNativeImpl64() {
        return new NativeImpl64();
    }

    private static MemoryIO newUnsafeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newUnsafeImpl32() : MemoryIO.newUnsafeImpl64();
    }

    private static MemoryIO newUnsafeImpl32() {
        return new UnsafeImpl32();
    }

    private static MemoryIO newUnsafeImpl64() {
        return new UnsafeImpl64();
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public final void copyMemory(long src, long dst, long size2) {
        if (dst + size2 <= src || src + size2 <= dst) {
            this._copyMemory(src, dst, size2);
        } else {
            this.memmove(dst, src, size2);
        }
    }

    abstract void _copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public final void memcpy(long dst, long src, long size2) {
        Foreign.memcpy(dst, src, size2);
    }

    public final void memmove(long dst, long src, long size2) {
        Foreign.memmove(dst, src, size2);
    }

    public final void memset(long address2, int value2, long size2) {
        this.setMemory(address2, size2, (byte)value2);
    }

    public final void putByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.putByteArray(address2, data2, offset2, length2);
    }

    public final void getByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.getByteArray(address2, data2, offset2, length2);
    }

    public final void putCharArray(long address2, char[] data2, int offset2, int length2) {
        Foreign.putCharArray(address2, data2, offset2, length2);
    }

    public final void getCharArray(long address2, char[] data2, int offset2, int length2) {
        Foreign.getCharArray(address2, data2, offset2, length2);
    }

    public final void putShortArray(long address2, short[] data2, int offset2, int length2) {
        Foreign.putShortArray(address2, data2, offset2, length2);
    }

    public final void getShortArray(long address2, short[] data2, int offset2, int length2) {
        Foreign.getShortArray(address2, data2, offset2, length2);
    }

    public final void putIntArray(long address2, int[] data2, int offset2, int length2) {
        Foreign.putIntArray(address2, data2, offset2, length2);
    }

    public final void getIntArray(long address2, int[] data2, int offset2, int length2) {
        Foreign.getIntArray(address2, data2, offset2, length2);
    }

    public final void putLongArray(long address2, long[] data2, int offset2, int length2) {
        Foreign.putLongArray(address2, data2, offset2, length2);
    }

    public final void getLongArray(long address2, long[] data2, int offset2, int length2) {
        Foreign.getLongArray(address2, data2, offset2, length2);
    }

    public final void putFloatArray(long address2, float[] data2, int offset2, int length2) {
        Foreign.putFloatArray(address2, data2, offset2, length2);
    }

    public final void getFloatArray(long address2, float[] data2, int offset2, int length2) {
        Foreign.getFloatArray(address2, data2, offset2, length2);
    }

    public final void putDoubleArray(long address2, double[] data2, int offset2, int length2) {
        Foreign.putDoubleArray(address2, data2, offset2, length2);
    }

    public final void getDoubleArray(long address2, double[] data2, int offset2, int length2) {
        Foreign.getDoubleArray(address2, data2, offset2, length2);
    }

    public final long allocateMemory(long size2, boolean clear2) {
        return Foreign.allocateMemory(size2, clear2) & ADDRESS_MASK;
    }

    public final void freeMemory(long address2) {
        Foreign.freeMemory(address2);
    }

    public final long getStringLength(long address2) {
        return Foreign.strlen(address2);
    }

    public final byte[] getZeroTerminatedByteArray(long address2) {
        return Foreign.getZeroTerminatedByteArray(address2);
    }

    public final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
        return Foreign.getZeroTerminatedByteArray(address2, maxlen);
    }

    @Deprecated
    public final byte[] getZeroTerminatedByteArray(long address2, long maxlen) {
        return Foreign.getZeroTerminatedByteArray(address2, (int)maxlen);
    }

    public final void putZeroTerminatedByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.putZeroTerminatedByteArray(address2, data2, offset2, length2);
    }

    public final long indexOf(long address2, byte value2) {
        long location = Foreign.memchr(address2, value2, Integer.MAX_VALUE);
        return location != 0L ? location - address2 : -1L;
    }

    public final long indexOf(long address2, byte value2, int maxlen) {
        long location = Foreign.memchr(address2, value2, maxlen);
        return location != 0L ? location - address2 : -1L;
    }

    public final ByteBuffer newDirectByteBuffer(long address2, int capacity) {
        return this.foreign.newDirectByteBuffer(address2, capacity);
    }

    public final long getDirectBufferAddress(Buffer buffer) {
        return this.foreign.getDirectBufferAddress(buffer);
    }

    private static void verifyAccessor(Class unsafeClass, Class primitive) throws NoSuchMethodException {
        String primitiveName = primitive.getSimpleName();
        String typeName = primitiveName.substring(0, 1).toUpperCase() + primitiveName.substring(1);
        Method get2 = unsafeClass.getDeclaredMethod("get" + typeName, Long.TYPE);
        if (!get2.getReturnType().equals(primitive)) {
            throw new NoSuchMethodException("Incorrect return type for " + get2.getName());
        }
        unsafeClass.getDeclaredMethod("put" + typeName, Long.TYPE, primitive);
    }

    static boolean isUnsafeAvailable() {
        try {
            Class[] primitiveTypes;
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            for (Class type2 : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                MemoryIO.verifyAccessor(sunClass, type2);
            }
            sunClass.getDeclaredMethod("getAddress", Long.TYPE);
            sunClass.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            sunClass.getDeclaredMethod("allocateMemory", Long.TYPE);
            sunClass.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.newMemoryIO();
    }

    private static class UnsafeImpl64
    extends UnsafeImpl {
        private UnsafeImpl64() {
        }

        public final long getAddress(long address2) {
            return unsafe.getLong(address2);
        }

        public final void putAddress(long address2, long value2) {
            unsafe.putLong(address2, value2);
        }
    }

    private static class UnsafeImpl32
    extends UnsafeImpl {
        private UnsafeImpl32() {
        }

        public final long getAddress(long address2) {
            return (long)unsafe.getInt(address2) & ADDRESS_MASK;
        }

        public final void putAddress(long address2, long value2) {
            unsafe.putInt(address2, (int)value2);
        }
    }

    private static abstract class UnsafeImpl
    extends MemoryIO {
        protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeImpl.getUnsafe());

        private UnsafeImpl() {
        }

        private static Object getUnsafe() {
            try {
                Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
                Field f = sunUnsafe.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(sunUnsafe);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public final byte getByte(long address2) {
            return unsafe.getByte(address2);
        }

        public final short getShort(long address2) {
            return unsafe.getShort(address2);
        }

        public final int getInt(long address2) {
            return unsafe.getInt(address2);
        }

        public final long getLong(long address2) {
            return unsafe.getLong(address2);
        }

        public final float getFloat(long address2) {
            return unsafe.getFloat(address2);
        }

        public final double getDouble(long address2) {
            return unsafe.getDouble(address2);
        }

        public final void putByte(long address2, byte value2) {
            unsafe.putByte(address2, value2);
        }

        public final void putShort(long address2, short value2) {
            unsafe.putShort(address2, value2);
        }

        public final void putInt(long address2, int value2) {
            unsafe.putInt(address2, value2);
        }

        public final void putLong(long address2, long value2) {
            unsafe.putLong(address2, value2);
        }

        public final void putFloat(long address2, float value2) {
            unsafe.putFloat(address2, value2);
        }

        public final void putDouble(long address2, double value2) {
            unsafe.putDouble(address2, value2);
        }

        public final void _copyMemory(long src, long dst, long size2) {
            unsafe.copyMemory(src, dst, size2);
        }

        public final void setMemory(long src, long size2, byte value2) {
            unsafe.setMemory(src, size2, value2);
        }
    }

    private static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
        }

        public final long getAddress(long address2) {
            return Foreign.getLong(address2);
        }

        public final void putAddress(long address2, long value2) {
            Foreign.putLong(address2, value2);
        }
    }

    private static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
        }

        public final long getAddress(long address2) {
            return (long)Foreign.getInt(address2) & ADDRESS_MASK;
        }

        public final void putAddress(long address2, long value2) {
            Foreign.putInt(address2, (int)value2);
        }
    }

    private static abstract class NativeImpl
    extends MemoryIO {
        private NativeImpl() {
        }

        public final byte getByte(long address2) {
            return Foreign.getByte(address2);
        }

        public final short getShort(long address2) {
            return Foreign.getShort(address2);
        }

        public final int getInt(long address2) {
            return Foreign.getInt(address2);
        }

        public final long getLong(long address2) {
            return Foreign.getLong(address2);
        }

        public final float getFloat(long address2) {
            return Foreign.getFloat(address2);
        }

        public final double getDouble(long address2) {
            return Foreign.getDouble(address2);
        }

        public final void putByte(long address2, byte value2) {
            Foreign.putByte(address2, value2);
        }

        public final void putShort(long address2, short value2) {
            Foreign.putShort(address2, value2);
        }

        public final void putInt(long address2, int value2) {
            Foreign.putInt(address2, value2);
        }

        public final void putLong(long address2, long value2) {
            Foreign.putLong(address2, value2);
        }

        public final void putFloat(long address2, float value2) {
            Foreign.putFloat(address2, value2);
        }

        public final void putDouble(long address2, double value2) {
            Foreign.putDouble(address2, value2);
        }

        public final void setMemory(long address2, long size2, byte value2) {
            Foreign.setMemory(address2, size2, value2);
        }

        public final void _copyMemory(long src, long dst, long size2) {
            Foreign.copyMemory(src, dst, size2);
        }
    }

    private static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();

        private SingletonHolder() {
        }
    }
}

