/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MultipleAsgn19Node
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;
    private final ListNode post;
    private final Arity arity;

    public MultipleAsgn19Node(ISourcePosition position, ListNode pre, Node rest2, ListNode post) {
        super(position);
        this.pre = pre;
        this.rest = rest2;
        this.post = post;
        this.arity = this.getRest() != null ? Arity.required(this.getPreCount() + this.getPostCount()) : Arity.fixed(this.getPreCount() + this.getPostCount());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGN19NODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.pre, this.rest, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject value2 = this.getValueNode().interpret(runtime, context, self2, aBlock);
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray19(runtime, value2, this.pre != null);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self2, this, (RubyArray)value2);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray19(runtime, value2, this.pre != null);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self2, this, (RubyArray)value2, checkArity);
    }
}

