/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jruby.util.JarResource;

class JarDirectoryResource
extends JarResource {
    private final String path;

    public static JarDirectoryResource create(JarFile jar, String path2) {
        String dirPath;
        String string2 = dirPath = path2.endsWith("/") ? path2 : path2 + "/";
        if ("/".equals(dirPath)) {
            return new JarDirectoryResource(jar, dirPath);
        }
        Enumeration<JarEntry> entries2 = jar.entries();
        while (entries2.hasMoreElements()) {
            if (!entries2.nextElement().getName().startsWith(dirPath)) continue;
            return new JarDirectoryResource(jar, dirPath);
        }
        return null;
    }

    private JarDirectoryResource(JarFile jar, String path2) {
        super(jar);
        this.path = path2;
    }

    @Override
    public String entryName() {
        return this.path;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String[] list() {
        HashSet<String> dirs = new HashSet<String>();
        Enumeration<JarEntry> entries2 = this.jar.entries();
        while (entries2.hasMoreElements()) {
            String subPath;
            String entryPath = entries2.nextElement().getName();
            if (this.isRoot()) {
                subPath = entryPath;
            } else {
                if (!entryPath.startsWith(this.path) || entryPath.length() <= this.path.length()) continue;
                subPath = entryPath.substring(this.path.length());
            }
            int slashIndex = subPath.indexOf(47);
            if (slashIndex > 0) {
                subPath = subPath.substring(0, slashIndex);
            }
            dirs.add(subPath);
        }
        return dirs.toArray(new String[0]);
    }

    public boolean isRoot() {
        return "/".equals(this.path);
    }
}

