/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

public class YyTables {
    private static short[] combine(short[] t1, short[] t2, short[] t3, short[] t4) {
        short[] t = new short[t1.length + t2.length + t3.length + t4.length];
        int index2 = 0;
        System.arraycopy(t1, 0, t, index2, t1.length);
        System.arraycopy(t2, 0, t, index2 += t1.length, t2.length);
        System.arraycopy(t3, 0, t, index2 += t2.length, t3.length);
        System.arraycopy(t4, 0, t, index2 += t3.length, t4.length);
        return t;
    }

    public static final short[] yyTable() {
        return YyTables.combine(YyTables.yyTable1(), YyTables.yyTable2(), YyTables.yyTable3(), YyTables.yyTable4());
    }

    public static final short[] yyCheck() {
        return YyTables.combine(YyTables.yyCheck1(), YyTables.yyCheck2(), YyTables.yyCheck3(), YyTables.yyCheck4());
    }

    /*
     * Opcode count of 31312 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyTable1() {
        return new short[]{107, 319, 318, 230, 230, 342, 89, 89, 384, 445, 390, 404, 327, 596, 464, 467, 397, 571, 775, 203, 907, 585, 571, 96, 96, 595, 585, 671, 696, 915, 252, 1032, 486, 311, 712, 200, 232, 232, 645, 203, 529, 342, 499, 1027, 531, 125, 249, 550, 552, 237, 237, 896, 569, 285, 289, 200, 247, 816, 280, 308, 233, 233, 442, 817, 740, 767, 761, 824, 909, 985, 912, 203, 1045, 911, 96, 96, 757, 712, 309, 249, 257, 1189, 334, 334, 899, 746, 427, 383, 232, 284, 288, 427, 427, 969, 969, 740, 767, 465, 740, 767, 282, 278, 230, 678, 709, 835, 816, 757, 709, 816, 757, 308, 1091, 740, 767, 428, 746, 308, 308, 746, 517, 742, 1147, 610, 308, 757, 802, 748, 1047, 704, 309, 203, 392, 346, 746, 232, 422, 422, 922, 232, 867, 246, 1097, 459, 232, 232, 480, 771, 237, 1309, 339, 1073, 389, 249, 1251, 684, 816, 319, 816, 233, 369, 748, 368, 790, 339, 242, 474, 346, 106, 346, 1067, 1068, 610, 250, 804, 253, 748, 513, 771, 767, 803, 389, 346, 569, 389, 92, 254, 816, 341, 739, 757, 1213, 342, 1096, 778, 731, 771, 388, 819, 338, 716, 377, 819, 819, 1292, 816, 375, 535, 245, 103, 1148, 376, 779, 338, 346, 773, 500, 391, 502, 256, 1309, 817, 60, 540, 339, 334, 334, 929, 95, 479, 230, 716, 230, 230, 600, 601, 602, 603, 525, 804, 103, 748, 96, 498, 382, 838, 773, 346, 519, 716, 664, 802, 107, 1307, 816, 501, 761, 902, 89, 95, 103, 771, 269, 232, 773, 232, 232, 305, 712, 232, 816, 232, 524, 338, 515, 96, 237, 96, 237, 95, 747, 845, 747, 731, 389, 731, 521, 233, 523, 233, 494, 96, 486, 96, 816, 1269, 1292, 525, 508, 339, 1196, 1199, 337, 816, 817, 803, 1103, 308, 322, 907, 389, 427, 427, 427, 427, 802, 605, 606, 1191, 1192, 278, 1045, 377, 802, 1104, 846, 309, 375, 373, 479, 374, 528, 376, 1141, 731, 687, 533, 740, 767, 543, 709, 860, 709, 816, 336, 89, 1056, 508, 338, 757, 305, 604, 96, 1154, 847, 539, 911, 96, 746, 323, 348, 349, 96, 816, 232, 232, 232, 232, 96, 232, 232, 568, 543, 692, 1237, 520, 230, 97, 97, 666, 610, 246, 342, 599, 391, 1090, 498, 668, 545, 546, 97, 97, 1286, 656, 324, 1111, 1113, 656, 656, 656, 1116, 1118, 651, 92, 761, 308, 761, 679, 1287, 232, 651, 1214, 427, 816, 1228, 816, 1250, 1090, 273, 1009, 771, 545, 546, 96, 309, 740, 767, 709, 97, 97, 571, 356, 357, 888, 585, 854, 325, 757, 694, 969, 232, 532, 97, 535, 475, 476, 746, 96, 1095, 389, 278, 386, 387, 377, 585, 683, 585, 562, 375, 373, 330, 374, 610, 376, 96, 232, 96, 230, 346, 346, 117, 563, 681, 716, 456, 897, 804, 498, 103, 897, 386, 396, 656, 386, 478, 656, 656, 336, 773, 97, 351, 884, 651, 97, 675, 816, 715, 95, 97, 97, 232, 567, 568, 718, 1349, 879, 720, 721, 771, 722, 649, 816, 656, 788, 881, 710, 8, 681, 203, 1012, 817, 1221, 379, 907, 732, 651, 8, 230, 804, 734, 819, 819, 1316, 307, 200, 819, 819, 498, 249, 641, 249, 96, 650, 308, 543, 551, 804, 400, 816, 395, 660, 817, 651, 816, 1070, 508, 679, 456, 735, 804, 232, 716, 309, 816, 307, 146, 336, 535, 399, 1311, 248, 1313, 1325, 916, 571, 8, 773, 1041, 585, 762, 816, 863, 787, 386, 512, 791, 273, 712, 907, 245, 816, 784, 1142, 545, 546, 790, 97, 401, 984, 984, 649, 346, 815, 817, 93, 856, 815, 815, 833, 386, 538, 351, 749, 101, 146, 232, 307, 97, 232, 97, 97, 510, 1174, 97, 389, 97, 922, 405, 816, 97, 641, 97, 650, 649, 468, 93, 864, 273, 885, 816, 1347, 8, 1271, 99, 101, 97, 346, 97, 812, 1280, 851, 1124, 761, 761, 389, 91, 819, 750, 812, 96, 649, 709, 104, 230, 101, 729, 374, 308, 819, 691, 248, 837, 383, 498, 99, 879, 803, 816, 816, 230, 470, 389, 816, 816, 232, 811, 309, 1131, 651, 498, 96, 882, 729, 104, 99, 823, 232, 1226, 96, 1001, 871, 96, 1193, 232, 651, 136, 97, 829, 829, 203, 96, 97, 232, 104, 97, 374, 97, 96, 97, 97, 97, 97, 97, 97, 97, 200, 1246, 812, 389, 803, 1002, 102, 1011, 234, 241, 1004, 811, 803, 308, 585, 921, 535, 351, 816, 232, 97, 922, 1339, 386, 674, 477, 880, 481, 435, 816, 484, 100, 309, 1010, 364, 365, 802, 102, 97, 136, 97, 904, 273, 811, 794, 809, 681, 681, 675, 1304, 485, 773, 97, 142, 1305, 809, 924, 102, 930, 1219, 790, 306, 100, 1282, 127, 816, 346, 806, 816, 97, 442, 649, 1217, 656, 656, 681, 97, 435, 816, 98, 656, 656, 100, 686, 427, 688, 753, 649, 136, 484, 341, 487, 306, 97, 97, 97, 816, 146, 488, 1234, 773, 1329, 142, 729, 382, 829, 436, 406, 669, 19, 98, 346, 670, 880, 816, 507, 308, 816, 511, 729, 681, 341, 1018, 802, 809, 351, 806, 816, 816, 97, 98, 754, 518, 1021, 484, 309, 135, 232, 96, 203, 19, 514, 435, 1018, 306, 816, 656, 656, 766, 656, 656, 530, 770, 348, 349, 436, 816, 101, 19, 96, 527, 806, 984, 1039, 1040, 773, 484, 534, 1083, 669, 97, 1299, 680, 1069, 541, 346, 346, 816, 594, 984, 984, 984, 425, 1044, 747, 135, 1136, 99, 597, 97, 804, 740, 731, 652, 1184, 964, 964, 655, 386, 690, 117, 1062, 667, 96, 1132, 816, 104, 816, 875, 815, 815, 1198, 1201, 425, 815, 815, 425, 680, 747, 984, 436, 343, 96, 731, 19, 740, 731, 672, 386, 1000, 1217, 117, 1217, 747, 117, 489, 681, 492, 816, 689, 740, 731, 428, 886, 97, 759, 732, 97, 693, 817, 286, 117, 343, 699, 1186, 386, 1245, 731, 97, 991, 1109, 1109, 598, 427, 230, 656, 786, 996, 806, 700, 111, 716, 675, 725, 498, 102, 656, 732, 1121, 759, 817, 681, 806, 816, 543, 816, 816, 1130, 816, 651, 816, 816, 717, 543, 759, 96, 136, 232, 747, 146, 100, 1217, 386, 1319, 96, 740, 96, 97, 656, 305, 142, 97, 97, 97, 719, 96, 232, 675, 736, 816, 849, 816, 816, 484, 816, 97, 816, 97, 763, 544, 97, 427, 97, 545, 546, 815, 870, 308, 548, 726, 305, 97, 545, 546, 114, 114, 97, 815, 98, 786, 1013, 916, 1072, 765, 96, 543, 1171, 114, 114, 759, 1247, 19, 19, 19, 1023, 346, 346, 19, 19, 767, 19, 806, 1080, 97, 681, 681, 769, 537, 19, 1195, 816, 816, 816, 543, 232, 776, 1102, 816, 484, 484, 774, 537, 780, 135, 787, 114, 114, 649, 114, 1253, 678, 777, 543, 96, 545, 546, 96, 1185, 94, 114, 816, 816, 782, 469, 816, 816, 471, 472, 473, 137, 797, 537, 800, 816, 914, 537, 801, 641, 548, 650, 924, 914, 545, 546, 804, 698, 1283, 1284, 96, 94, 1093, 1094, 106, 96, 96, 678, 96, 548, 807, 1323, 1324, 545, 546, 1078, 1185, 682, 114, 1249, 808, 92, 114, 1015, 922, 1146, 839, 114, 114, 19, 137, 117, 96, 680, 680, 850, 1175, 543, 419, 787, 1257, 1258, 1259, 1049, 1051, 1053, 422, 1055, 420, 873, 104, 104, 1057, 97, 97, 308, 1072, 806, 806, 864, 423, 421, 682, 1072, 1072, 1024, 1018, 130, 786, 419, 116, 230, 680, 867, 1278, 97, 118, 422, 682, 420, 806, 498, 549, 784, 96, 874, 545, 546, 427, 427, 1146, 423, 421, 876, 816, 816, 651, 681, 681, 503, 816, 104, 104, 964, 232, 310, 1180, 944, 806, 504, 505, 910, 537, 537, 877, 917, 1018, 680, 308, 1188, 123, 563, 484, 682, 898, 114, 1197, 1200, 1059, 661, 662, 663, 1205, 675, 675, 127, 900, 1320, 97, 1176, 1177, 232, 232, 675, 903, 905, 114, 920, 114, 114, 932, 567, 114, 934, 114, 1183, 18, 310, 114, 992, 114, 986, 1194, 423, 423, 790, 127, 484, 1080, 127, 460, 346, 993, 786, 114, 999, 114, 675, 1018, 675, 96, 997, 1003, 806, 806, 806, 127, 18, 1007, 1008, 1223, 922, 675, 1035, 1146, 133, 787, 1038, 1048, 484, 1050, 97, 97, 1052, 649, 18, 97, 97, 1054, 543, 1100, 97, 779, 97, 711, 1060, 346, 713, 714, 1082, 97, 1135, 97, 543, 675, 557, 1092, 558, 559, 560, 561, 97, 97, 701, 1101, 114, 729, 708, 137, 789, 114, 286, 1106, 1151, 730, 114, 1152, 114, 114, 114, 114, 114, 114, 114, 746, 1181, 786, 675, 545, 546, 1157, 678, 678, 1090, 640, 1260, 1261, 1262, 751, 104, 97, 18, 545, 546, 1326, 795, 1182, 1232, 942, 799, 708, 1233, 1205, 806, 286, 1239, 921, 1205, 1238, 1240, 1241, 1242, 114, 557, 1306, 558, 559, 560, 561, 1252, 97, 1244, 104, 1255, 104, 135, 114, 1256, 1263, 640, 1272, 137, 1220, 640, 640, 1264, 682, 682, 104, 97, 104, 848, 97, 114, 1266, 1215, 1270, 97, 1273, 853, 114, 857, 1294, 1295, 1205, 891, 892, 755, 893, 97, 771, 1303, 756, 1314, 1231, 45, 46, 114, 114, 114, 1235, 111, 1236, 310, 97, 142, 484, 1318, 1330, 97, 97, 1306, 97, 1331, 119, 1328, 683, 40, 41, 42, 43, 680, 680, 1333, 1335, 1337, 1248, 682, 682, 104, 138, 786, 111, 114, 104, 111, 97, 675, 1354, 104, 84, 84, 816, 816, 1153, 104, 1155, 802, 804, 818, 1156, 809, 111, 825, 127, 804, 809, 804, 18, 18, 18, 683, 366, 786, 18, 18, 683, 18, 828, 834, 811, 484, 484, 804, 114, 18, 114, 804, 1281, 138, 329, 1327, 675, 789, 816, 752, 1022, 125, 97, 793, 425, 84, 84, 114, 731, 306, 509, 121, 1321, 685, 104, 310, 1209, 818, 872, 825, 787, 114, 97, 733, 114, 683, 678, 878, 786, 343, 344, 345, 346, 347, 346, 346, 883, 708, 104, 286, 1302, 114, 675, 675, 822, 1206, 1243, 1215, 793, 1215, 441, 1312, 908, 914, 1014, 104, 1215, 104, 685, 97, 97, 306, 114, 1046, 1110, 114, 901, 306, 306, 913, 1315, 678, 1026, 1344, 306, 1028, 813, 636, 18, 1350, 793, 120, 557, 684, 558, 559, 560, 561, 1343, 1005, 463, 249, 919, 1190, 989, 990, 1187, 1202, 97, 394, 925, 994, 995, 787, 1254, 927, 0, 1084, 1203, 1085, 1086, 140, 1087, 1279, 1215, 0, 1215, 783, 1215, 569, 1215, 0, 0, 570, 708, 114, 755, 783, 684, 114, 114, 114, 104, 0, 0, 0, 1289, 1215, 558, 559, 560, 561, 0, 114, 0, 114, 1006, 685, 114, 1296, 114, 1088, 0, 310, 0, 0, 0, 0, 783, 114, 140, 783, 0, 138, 114, 0, 0, 1033, 1034, 0, 1036, 1037, 0, 84, 1310, 0, 783, 0, 0, 0, 0, 0, 0, 1317, 111, 786, 0, 0, 0, 1030, 0, 114, 685, 0, 0, 0, 0, 802, 0, 0, 0, 138, 0, 0, 123, 122, 84, 686, 84, 0, 783, 0, 954, 954, 0, 0, 0, 0, 0, 1133, 0, 0, 84, 1134, 84, 0, 139, 0, 0, 683, 683, 1137, 0, 0, 1139, 123, 144, 793, 123, 1143, 484, 0, 783, 1345, 0, 1346, 140, 1348, 377, 372, 675, 675, 686, 375, 373, 123, 374, 306, 376, 114, 787, 0, 684, 0, 1357, 0, 0, 0, 113, 820, 677, 0, 0, 820, 820, 139, 0, 310, 0, 683, 683, 802, 0, 84, 0, 484, 1115, 0, 84, 104, 0, 0, 104, 84, 0, 1112, 1114, 1127, 0, 84, 1117, 1119, 793, 793, 0, 371, 0, 684, 104, 114, 114, 0, 685, 685, 0, 677, 139, 484, 0, 0, 0, 0, 0, 141, 0, 678, 678, 1129, 0, 1144, 0, 114, 0, 0, 0, 370, 0, 0, 1225, 1112, 1114, 0, 1117, 1119, 0, 955, 955, 0, 310, 1140, 0, 0, 0, 0, 84, 306, 0, 894, 286, 686, 0, 0, 0, 0, 0, 954, 954, 0, 140, 954, 0, 0, 141, 0, 0, 0, 0, 0, 84, 783, 783, 783, 684, 684, 783, 783, 783, 557, 783, 558, 559, 560, 561, 562, 114, 84, 783, 84, 783, 783, 0, 0, 0, 954, 686, 0, 0, 563, 783, 783, 0, 783, 783, 783, 783, 783, 0, 0, 802, 802, 802, 1222, 0, 0, 802, 802, 0, 802, 0, 0, 0, 565, 0, 0, 0, 802, 566, 567, 568, 0, 141, 1293, 0, 0, 0, 0, 685, 685, 1224, 0, 1222, 310, 0, 0, 104, 0, 0, 114, 114, 0, 678, 1230, 114, 114, 0, 0, 0, 114, 0, 114, 0, 783, 84, 123, 484, 104, 114, 0, 114, 85, 85, 0, 0, 139, 0, 783, 0, 114, 114, 0, 787, 954, 0, 306, 678, 954, 678, 0, 955, 955, 0, 708, 955, 132, 0, 0, 686, 686, 0, 678, 0, 954, 954, 954, 954, 106, 106, 0, 954, 954, 0, 954, 0, 0, 802, 0, 114, 132, 0, 708, 85, 85, 0, 708, 307, 0, 955, 351, 104, 484, 484, 678, 0, 0, 0, 0, 0, 0, 0, 1285, 708, 0, 816, 0, 364, 365, 114, 0, 954, 0, 0, 684, 684, 677, 0, 0, 106, 106, 0, 677, 677, 0, 0, 787, 678, 114, 132, 0, 114, 0, 141, 0, 0, 114, 0, 0, 307, 0, 0, 0, 0, 0, 307, 307, 0, 114, 0, 0, 0, 307, 0, 820, 820, 0, 0, 0, 820, 820, 677, 84, 114, 104, 0, 84, 84, 114, 114, 306, 114, 130, 104, 0, 104, 0, 955, 0, 0, 0, 955, 84, 125, 104, 84, 0, 0, 462, 0, 0, 0, 0, 0, 0, 114, 0, 955, 955, 955, 955, 84, 786, 0, 955, 955, 0, 955, 675, 0, 0, 686, 686, 789, 125, 0, 0, 125, 0, 793, 793, 130, 0, 104, 954, 1172, 0, 377, 372, 954, 0, 0, 375, 373, 125, 374, 954, 376, 0, 0, 0, 306, 0, 0, 955, 0, 0, 114, 0, 0, 789, 85, 0, 675, 793, 0, 793, 0, 0, 0, 0, 0, 0, 0, 793, 0, 0, 114, 0, 793, 0, 0, 104, 0, 0, 104, 954, 100, 100, 0, 820, 956, 956, 787, 85, 786, 85, 106, 0, 0, 0, 0, 820, 0, 957, 957, 793, 0, 0, 0, 85, 793, 85, 954, 114, 114, 0, 104, 0, 0, 0, 0, 104, 104, 0, 104, 0, 0, 0, 0, 106, 0, 106, 0, 0, 0, 0, 131, 100, 100, 0, 0, 0, 793, 793, 307, 106, 132, 106, 104, 112, 0, 676, 114, 306, 0, 0, 84, 678, 678, 708, 0, 708, 708, 708, 708, 708, 955, 0, 0, 0, 85, 955, 676, 0, 0, 85, 0, 84, 955, 708, 85, 0, 0, 0, 0, 131, 85, 0, 0, 0, 423, 0, 0, 708, 0, 0, 676, 0, 124, 0, 104, 0, 0, 708, 0, 115, 106, 679, 708, 708, 708, 106, 0, 0, 0, 0, 106, 676, 955, 0, 0, 0, 106, 0, 677, 677, 0, 0, 789, 124, 0, 0, 124, 0, 789, 0, 0, 0, 130, 0, 84, 85, 307, 956, 956, 955, 0, 956, 0, 124, 0, 786, 679, 423, 0, 0, 957, 957, 0, 0, 957, 125, 793, 0, 0, 85, 0, 0, 129, 0, 337, 0, 0, 0, 0, 0, 0, 106, 0, 789, 0, 956, 85, 0, 85, 958, 958, 134, 0, 0, 148, 0, 0, 0, 957, 0, 104, 0, 0, 793, 0, 106, 0, 84, 84, 100, 0, 0, 84, 84, 128, 789, 347, 84, 0, 337, 675, 675, 106, 0, 106, 0, 84, 679, 84, 351, 337, 793, 793, 0, 0, 0, 0, 84, 0, 0, 134, 0, 100, 148, 100, 0, 364, 365, 0, 569, 0, 0, 0, 224, 0, 0, 147, 0, 100, 0, 100, 347, 0, 85, 959, 959, 0, 0, 793, 793, 0, 0, 679, 956, 0, 337, 84, 956, 306, 0, 0, 224, 0, 224, 307, 224, 957, 0, 131, 681, 957, 0, 347, 956, 956, 956, 956, 131, 0, 106, 956, 956, 224, 956, 224, 147, 957, 957, 957, 957, 0, 0, 0, 957, 957, 0, 957, 0, 0, 100, 0, 0, 0, 0, 100, 84, 0, 0, 84, 100, 0, 0, 0, 84, 0, 100, 0, 347, 0, 0, 956, 0, 958, 958, 134, 84, 958, 126, 0, 0, 0, 116, 0, 957, 676, 676, 0, 960, 960, 0, 84, 0, 0, 0, 0, 84, 84, 0, 84, 0, 0, 124, 789, 0, 0, 676, 676, 790, 126, 0, 958, 126, 116, 790, 0, 116, 0, 680, 0, 0, 100, 0, 84, 0, 217, 0, 0, 0, 126, 0, 85, 0, 116, 0, 85, 85, 0, 148, 307, 0, 679, 679, 0, 0, 100, 0, 0, 959, 959, 0, 85, 959, 217, 85, 217, 0, 217, 0, 790, 0, 680, 100, 680, 100, 306, 0, 821, 789, 789, 85, 821, 821, 0, 217, 84, 217, 0, 0, 134, 147, 118, 148, 0, 956, 0, 959, 106, 0, 956, 106, 790, 0, 0, 0, 0, 956, 957, 0, 958, 0, 0, 957, 958, 337, 337, 106, 0, 0, 957, 307, 0, 118, 0, 0, 118, 0, 682, 0, 958, 958, 958, 958, 0, 0, 0, 958, 958, 306, 958, 0, 0, 118, 0, 0, 0, 956, 0, 0, 100, 0, 960, 960, 0, 147, 960, 347, 347, 557, 957, 558, 559, 560, 561, 562, 0, 0, 679, 679, 0, 337, 337, 682, 956, 0, 0, 958, 0, 563, 0, 0, 84, 0, 0, 959, 0, 957, 0, 959, 960, 224, 0, 224, 224, 224, 224, 224, 0, 0, 0, 0, 0, 565, 0, 959, 959, 959, 959, 567, 568, 224, 959, 959, 0, 959, 0, 0, 0, 0, 0, 0, 0, 0, 307, 224, 0, 85, 0, 0, 0, 681, 0, 347, 347, 224, 0, 0, 119, 0, 224, 224, 224, 0, 0, 227, 0, 0, 85, 0, 0, 0, 959, 0, 0, 0, 0, 0, 126, 790, 0, 0, 116, 106, 0, 0, 0, 0, 0, 119, 0, 0, 119, 227, 683, 227, 0, 227, 960, 0, 0, 682, 960, 0, 106, 0, 0, 100, 0, 119, 958, 100, 100, 0, 227, 958, 227, 0, 960, 960, 960, 960, 958, 0, 0, 960, 960, 100, 960, 0, 100, 85, 0, 0, 0, 0, 0, 0, 0, 683, 121, 0, 0, 0, 790, 790, 100, 0, 680, 680, 0, 0, 217, 0, 217, 217, 217, 217, 217, 0, 0, 0, 958, 0, 0, 960, 0, 106, 0, 0, 0, 121, 217, 0, 121, 0, 685, 0, 133, 0, 144, 118, 0, 0, 0, 959, 217, 961, 961, 958, 959, 121, 680, 0, 85, 85, 217, 959, 0, 85, 85, 217, 217, 217, 85, 0, 0, 0, 787, 0, 789, 0, 0, 85, 678, 85, 793, 0, 0, 0, 0, 685, 0, 0, 85, 0, 0, 133, 0, 144, 821, 821, 0, 0, 0, 821, 821, 959, 120, 0, 106, 0, 0, 962, 962, 0, 0, 682, 682, 106, 0, 106, 0, 0, 0, 0, 0, 0, 0, 678, 106, 793, 0, 85, 959, 307, 0, 0, 0, 120, 229, 229, 120, 0, 684, 0, 0, 0, 960, 0, 0, 0, 0, 960, 0, 0, 0, 0, 0, 120, 960, 787, 100, 793, 0, 0, 0, 0, 0, 106, 0, 1173, 0, 262, 266, 267, 268, 0, 0, 143, 229, 229, 85, 100, 0, 85, 0, 0, 0, 684, 85, 0, 326, 328, 0, 0, 0, 119, 0, 0, 960, 789, 85, 0, 0, 124, 0, 789, 0, 789, 961, 961, 0, 0, 961, 789, 0, 85, 106, 0, 0, 106, 85, 85, 0, 85, 821, 960, 143, 0, 0, 227, 0, 227, 227, 227, 227, 227, 821, 229, 0, 0, 0, 0, 0, 0, 100, 0, 961, 85, 0, 227, 789, 106, 0, 0, 0, 0, 106, 106, 789, 106, 319, 683, 683, 227, 962, 962, 0, 0, 962, 682, 319, 0, 0, 227, 0, 0, 0, 121, 227, 227, 227, 0, 789, 106, 0, 0, 0, 0, 0, 307, 789, 145, 0, 0, 0, 0, 0, 0, 0, 85, 0, 319, 962, 133, 319, 144, 0, 100, 100, 0, 0, 0, 100, 100, 0, 0, 787, 100, 793, 319, 0, 790, 0, 0, 0, 0, 100, 790, 100, 0, 0, 0, 0, 0, 961, 106, 0, 100, 961, 0, 145, 0, 229, 685, 685, 229, 229, 229, 0, 326, 0, 0, 307, 319, 961, 961, 961, 961, 0, 0, 0, 961, 961, 0, 961, 229, 0, 229, 229, 0, 0, 0, 790, 0, 0, 120, 100, 0, 0, 0, 0, 678, 678, 793, 793, 319, 0, 0, 0, 0, 962, 0, 0, 0, 962, 85, 327, 0, 0, 0, 0, 961, 0, 0, 790, 0, 327, 0, 0, 0, 962, 962, 962, 962, 0, 0, 0, 962, 962, 0, 962, 0, 0, 0, 0, 100, 0, 0, 100, 0, 0, 106, 0, 100, 143, 0, 0, 327, 143, 789, 320, 684, 684, 0, 0, 100, 0, 789, 0, 0, 0, 0, 0, 0, 0, 327, 0, 962, 0, 0, 100, 71, 0, 0, 0, 100, 100, 0, 100, 0, 0, 71, 0, 0, 608, 609, 610, 611, 612, 0, 0, 613, 614, 615, 616, 617, 618, 619, 620, 0, 622, 0, 100, 623, 624, 625, 626, 627, 628, 629, 630, 631, 71, 0, 789, 789, 0, 0, 0, 0, 0, 229, 789, 789, 961, 0, 0, 654, 0, 961, 71, 327, 319, 319, 319, 0, 961, 319, 319, 319, 0, 319, 0, 0, 0, 0, 0, 122, 0, 319, 0, 319, 319, 113, 100, 0, 0, 0, 145, 0, 0, 319, 319, 0, 319, 319, 319, 319, 319, 0, 0, 790, 0, 0, 0, 0, 961, 0, 122, 0, 962, 122, 0, 686, 113, 962, 0, 113, 0, 677, 0, 0, 962, 0, 0, 0, 71, 0, 122, 0, 0, 0, 0, 961, 113, 0, 39, 0, 0, 0, 229, 0, 229, 0, 229, 0, 39, 0, 229, 0, 0, 0, 0, 0, 319, 0, 268, 0, 686, 0, 0, 0, 962, 0, 677, 0, 790, 790, 319, 0, 0, 724, 0, 0, 727, 0, 0, 39, 0, 0, 100, 0, 484, 0, 0, 0, 0, 229, 0, 962, 0, 229, 484, 0, 0, 39, 0, 0, 327, 327, 327, 0, 229, 327, 327, 327, 0, 327, 0, 0, 0, 0, 0, 0, 0, 327, 0, 0, 0, 484, 484, 0, 0, 484, 484, 484, 484, 484, 484, 484, 327, 327, 327, 327, 327, 0, 0, 0, 0, 0, 484, 484, 484, 142, 484, 484, 0, 229, 0, 0, 0, 0, 0, 0, 0, 0, 0, 786, 0, 0, 790, 39, 0, 71, 71, 71, 0, 0, 71, 71, 71, 0, 71, 484, 0, 484, 484, 0, 0, 0, 71, 0, 71, 0, 0, 327, 0, 0, 0, 0, 0, 0, 263, 0, 0, 71, 71, 71, 71, 71, 0, 0, 263, 0, 327, 484, 484, 484, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 814, 0, 0, 0, 814, 827, 229, 0, 0, 263, 263, 0, 0, 263, 263, 263, 263, 263, 229, 263, 112, 0, 0, 112, 0, 676, 122, 0, 0, 0, 263, 263, 113, 0, 229, 263, 0, 0, 0, 0, 112, 229, 786, 790, 0, 0, 0, 0, 0, 71, 229, 0, 0, 0, 814, 1216, 814, 814, 0, 0, 229, 0, 229, 0, 0, 263, 263, 0, 0, 0, 676, 0, 0, 814, 0, 0, 0, 0, 39, 39, 39, 0, 0, 0, 39, 39, 115, 39, 0, 0, 803, 0, 686, 686, 0, 39, 263, 263, 677, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 39, 39, 39, 39, 229, 0, 115, 0, 0, 115, 0, 679, 0, 484, 484, 484, 0, 229, 484, 484, 484, 0, 484, 0, 0, 0, 115, 0, 0, 0, 484, 484, 484, 484, 484, 0, 229, 0, 0, 0, 0, 0, 484, 484, 0, 484, 484, 484, 484, 484, 0, 0, 0, 0, 0, 0, 679, 316, 229, 0, 0, 0, 0, 803, 0, 0, 0, 316, 0, 0, 0, 0, 0, 39, 0, 0, 0, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 0, 0, 0, 0, 484, 484, 484, 484, 316, 0, 484, 229, 1216, 129, 1216, 484, 0, 0, 1216, 0, 0, 1216, 0, 0, 0, 0, 316, 0, 0, 484, 0, 0, 484, 263, 263, 263, 0, 0, 263, 263, 263, 0, 263, 0, 129, 0, 0, 129, 0, 337, 263, 0, 263, 263, 263, 0, 0, 112, 0, 0, 316, 0, 263, 263, 129, 263, 263, 263, 263, 263, 0, 0, 0, 1063, 1064, 1065, 1066, 0, 0, 1216, 0, 1216, 569, 1216, 887, 1216, 570, 0, 0, 0, 0, 0, 316, 0, 337, 0, 0, 263, 263, 263, 263, 263, 1216, 0, 263, 263, 263, 263, 263, 263, 803, 803, 803, 0, 263, 263, 803, 803, 0, 803, 263, 0, 0, 676, 676, 263, 0, 803, 1105, 0, 0, 814, 814, 128, 0, 0, 814, 814, 1218, 263, 1120, 0, 263, 229, 0, 0, 0, 0, 675, 229, 0, 0, 1267, 0, 115, 0, 0, 1274, 675, 0, 0, 0, 0, 0, 128, 0, 0, 128, 0, 347, 0, 229, 0, 0, 0, 814, 814, 0, 814, 814, 229, 786, 0, 0, 128, 675, 675, 0, 786, 675, 675, 675, 675, 675, 675, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 675, 675, 130, 675, 675, 0, 0, 347, 0, 803, 0, 0, 0, 679, 679, 0, 0, 0, 0, 0, 0, 0, 316, 316, 316, 0, 0, 316, 316, 316, 0, 316, 675, 0, 675, 675, 0, 0, 0, 316, 0, 316, 316, 0, 0, 0, 1332, 1334, 1336, 1338, 814, 316, 316, 1340, 316, 316, 316, 316, 316, 678, 0, 0, 814, 229, 786, 675, 675, 786, 0, 678, 0, 0, 0, 0, 790, 129, 229, 0, 126, 814, 790, 1352, 1353, 1355, 1356, 0, 0, 0, 0, 1218, 0, 1218, 787, 1358, 0, 0, 678, 678, 1218, 787, 678, 678, 678, 678, 678, 678, 678, 0, 0, 0, 0, 0, 0, 0, 316, 0, 0, 678, 678, 678, 133, 678, 678, 0, 0, 790, 0, 0, 316, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 557, 0, 558, 559, 560, 561, 562, 678, 0, 678, 678, 0, 0, 1218, 790, 1218, 0, 1218, 0, 1218, 563, 229, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 564, 0, 1218, 0, 229, 787, 678, 678, 787, 0, 565, 0, 0, 0, 0, 566, 567, 568, 128, 0, 0, 786, 786, 786, 0, 786, 675, 675, 675, 786, 786, 675, 675, 675, 786, 675, 786, 786, 786, 786, 786, 786, 786, 675, 786, 675, 675, 675, 786, 786, 786, 786, 786, 786, 786, 675, 675, 786, 675, 675, 675, 675, 675, 569, 786, 0, 0, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 347, 347, 786, 0, 786, 786, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 786, 786, 0, 0, 675, 675, 675, 675, 786, 687, 675, 786, 786, 786, 786, 675, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 0, 786, 786, 675, 0, 0, 675, 145, 790, 0, 787, 787, 787, 0, 787, 678, 678, 678, 787, 787, 678, 678, 678, 787, 678, 787, 787, 787, 787, 787, 787, 787, 678, 787, 678, 678, 678, 787, 787, 787, 787, 787, 787, 787, 678, 678, 787, 678, 678, 678, 678, 678, 0, 787, 0, 0, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 790, 790, 787, 0, 787, 787, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 787, 787, 0, 0, 678, 678, 678, 678, 787, 690, 678, 787, 787, 787, 787, 678, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 793, 787, 787, 678, 0, 0, 678, 0, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 793, 793, 0, 789, 793, 793, 793, 793, 793, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 793, 793, 144, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 557, 0, 558, 559, 560, 561, 562, 793, 0, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 563, 0, 0, 0, 0, 0, 0, 0, 0, 935, 936, 937, 938, 789, 564, 0, 0, 0, 0, 793, 793, 793, 789, 789, 565, 939, 940, 941, 0, 0, 567, 568, 0, 0, 0, 40, 41, 42, 43, 44, 0, 0, 0, 0, 303, 0, 789, 0, 0, 0, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 143, 789, 789, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 0, 789, 793, 793, 793, 789, 789, 793, 793, 793, 789, 793, 789, 789, 789, 789, 789, 789, 789, 793, 793, 793, 793, 793, 789, 789, 789, 789, 789, 789, 789, 793, 793, 789, 793, 793, 793, 793, 793, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 789, 789, 0, 0, 793, 793, 793, 793, 789, 0, 793, 789, 789, 789, 789, 793, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 789, 793, 0, 0, 793, 0, 0, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 790, 789, 789, 789, 0, 0, 789, 0, 0, 0, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 790, 145, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 338, 0, 0, 0, 0, 0, 790, 790, 790, 790, 338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 788, 0, 0, 0, 338, 338, 0, 788, 338, 338, 338, 338, 338, 338, 338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 338, 338, 338, 0, 338, 338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 338, 0, 338, 338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 788, 338, 338, 788, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 790, 790, 0, 0, 790, 0, 0, 788, 788, 788, 0, 788, 338, 338, 338, 788, 788, 338, 338, 338, 788, 338, 788, 788, 788, 788, 788, 788, 788, 338, 788, 338, 338, 338, 788, 788, 788, 788, 788, 788, 788, 338, 338, 788, 338, 338, 338, 338, 338, 0, 788, 0, 0, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 0, 0, 788, 0, 788, 788, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 788, 788, 0, 0, 338, 338, 338, 338, 788, 0, 338, 788, 788, 788, 788, 338, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 794, 788, 788, 338, 0, 0, 338, 0, 0, 0, 794, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 791, 0, 0, 0, 794, 794, 0, 791, 794, 794, 794, 794, 794, 794, 794, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 794, 794, 794, 0, 794, 794, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 794, 0, 794, 794, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 795, 0, 0, 0, 0, 0, 794, 794, 794, 791, 795, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 792, 0, 0, 0, 795, 795, 0, 792, 795, 795, 795, 795, 795, 795, 795, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 795, 795, 795, 0, 795, 795, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 795, 0, 795, 795, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 795, 795, 795, 792, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 791, 791, 791, 0, 791, 794, 794, 794, 791, 791, 794, 794, 794, 791, 794, 791, 791, 791, 791, 791, 791, 791, 794, 794, 794, 794, 794, 791, 791, 791, 791, 791, 791, 791, 794, 794, 791, 794, 794, 794, 794, 794, 0, 791, 0, 0, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 0, 0, 791, 0, 791, 791, 794, 794, 794, 794, 794, 794, 794, 794, 794, 794, 794, 794, 794, 791, 791, 0, 0, 794, 794, 794, 794, 791, 0, 794, 791, 791, 791, 791, 794, 791, 791, 791, 791, 791, 791, 791, 791, 791, 791, 0, 791, 791, 794, 0, 0, 794, 0, 0, 792, 792, 792, 0, 792, 795, 795, 795, 792, 792, 795, 795, 795, 792, 795, 792, 792, 792, 792, 792, 792, 792, 795, 795, 795, 795, 795, 792, 792, 792, 792, 792, 792, 792, 795, 795, 792, 795, 795, 795, 795, 795, 0, 792, 0, 0, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 0, 0, 792, 0, 792, 792, 795, 795, 795, 795, 795, 795, 795, 795, 795, 795, 795, 795, 795, 792, 792, 0, 0, 795, 795, 795, 795, 792, 0, 795, 792, 792, 792, 792, 795, 792, 792, 792, 792, 792, 792, 792, 792, 792, 792, 346, 792, 792, 795, 0, 0, 795, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 346, 346, 0, 790, 346, 346, 346, 346, 346, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 346, 346, 146, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 0, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 0, 0, 0, 346, 346, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 681, 0, 0, 681, 681, 681, 681, 681, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 681, 681, 136, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 0, 0, 0, 0, 0, 0, 0, 0, 681, 0, 681, 681, 708, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 0, 212, 0, 212, 0, 0, 0, 683, 0, 0, 0, 0, 708, 681, 681, 0, 708, 0, 0, 0, 212, 0, 212, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 708, 0, 0, 790, 790, 790, 0, 790, 346, 346, 346, 790, 790, 346, 346, 346, 790, 346, 790, 790, 790, 790, 790, 790, 790, 346, 0, 346, 346, 346, 790, 790, 790, 790, 790, 790, 790, 346, 346, 790, 346, 346, 346, 346, 346, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 790, 790, 0, 0, 346, 346, 346, 346, 790, 0, 346, 790, 790, 790, 790, 346, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 790, 346, 0, 0, 346, 681, 681, 681, 0, 0, 681, 681, 681, 0, 681, 0, 0, 0, 0, 0, 0, 0, 681, 0, 681, 681, 681, 0, 0, 0, 0, 0, 0, 0, 681, 681, 0, 681, 681, 681, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 0, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 0, 0, 0, 0, 681, 681, 681, 681, 0, 693, 681, 0, 680, 680, 0, 681, 680, 680, 680, 680, 680, 680, 680, 0, 0, 0, 0, 0, 0, 681, 0, 0, 681, 680, 680, 680, 135, 680, 680, 212, 0, 212, 212, 212, 212, 212, 0, 0, 0, 0, 0, 0, 708, 0, 708, 708, 708, 708, 708, 212, 0, 0, 0, 0, 0, 0, 680, 0, 680, 680, 682, 0, 708, 212, 0, 0, 0, 0, 0, 683, 682, 0, 0, 212, 0, 0, 708, 0, 212, 212, 212, 0, 0, 0, 0, 0, 708, 0, 0, 680, 680, 708, 708, 708, 0, 0, 0, 682, 682, 0, 0, 682, 682, 682, 682, 682, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 682, 137, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 0, 682, 682, 0, 0, 0, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 683, 683, 0, 0, 683, 683, 683, 683, 683, 683, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 683, 683, 683, 138, 683, 683, 0, 0, 0, 0, 0, 680, 680, 680, 0, 0, 680, 680, 680, 0, 680, 0, 0, 0, 0, 0, 0, 0, 680, 0, 680, 680, 680, 683, 0, 683, 683, 0, 0, 0, 680, 680, 0, 680, 680, 680, 680, 680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 324, 0, 0, 0, 0, 0, 683, 683, 0, 0, 324, 0, 0, 0, 0, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 0, 0, 0, 0, 680, 680, 680, 680, 0, 692, 680, 0, 0, 324, 0, 680, 319, 0, 682, 682, 682, 0, 0, 682, 682, 682, 0, 682, 0, 680, 0, 324, 680, 0, 0, 682, 0, 682, 682, 682, 0, 0, 0, 0, 0, 0, 0, 682, 682, 0, 682, 682, 682, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 569, 0, 0, 0, 570, 0, 27, 0, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 0, 0, 324, 0, 682, 682, 682, 682, 0, 694, 682, 0, 0, 0, 0, 682, 27, 0, 0, 0, 0, 683, 683, 683, 0, 0, 683, 683, 683, 682, 683, 0, 682, 0, 27, 0, 0, 0, 683, 0, 683, 683, 683, 0, 0, 0, 0, 0, 0, 0, 683, 683, 0, 683, 683, 683, 683, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 0, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 0, 0, 27, 0, 683, 683, 683, 683, 0, 695, 683, 0, 685, 685, 0, 683, 685, 685, 685, 685, 685, 685, 685, 0, 0, 0, 0, 0, 0, 683, 0, 0, 683, 685, 685, 685, 140, 685, 685, 0, 0, 324, 324, 324, 0, 0, 0, 324, 324, 0, 324, 0, 0, 0, 0, 0, 0, 0, 324, 0, 0, 0, 0, 0, 0, 0, 685, 0, 685, 685, 684, 0, 0, 324, 324, 324, 324, 324, 0, 0, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 685, 0, 0, 0, 0, 0, 0, 684, 684, 0, 0, 684, 684, 684, 684, 684, 684, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 684, 139, 684, 684, 0, 0, 0, 0, 0, 27, 27, 27, 0, 0, 0, 27, 27, 324, 27, 557, 0, 558, 559, 560, 561, 562, 27, 0, 0, 0, 0, 684, 0, 684, 684, 0, 0, 0, 686, 563, 0, 27, 27, 27, 27, 27, 0, 0, 686, 0, 0, 0, 0, 564, 0, 0, 0, 0, 0, 0, 0, 0, 0, 565, 684, 684, 0, 0, 566, 567, 568, 0, 0, 0, 0, 686, 686, 0, 0, 686, 686, 686, 686, 686, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 686, 686, 686, 141, 686, 686, 0, 0, 0, 0, 0, 685, 685, 685, 0, 0, 685, 685, 685, 27, 685, 0, 0, 0, 0, 0, 0, 0, 685, 0, 685, 685, 685, 686, 0, 686, 686, 0, 0, 0, 685, 685, 0, 685, 685, 685, 685, 685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 686, 686, 0, 48, 0, 0, 0, 0, 0, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 0, 0, 0, 0, 685, 685, 685, 685, 0, 697, 685, 0, 48, 0, 0, 685, 0, 0, 684, 684, 684, 0, 0, 684, 684, 684, 0, 684, 0, 685, 48, 0, 685, 0, 0, 684, 0, 684, 684, 684, 0, 0, 0, 0, 0, 0, 0, 684, 684, 0, 684, 684, 684, 684, 684, 0, 0, 0, 0, 0, 569, 0, 0, 0, 570, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 0, 48, 0, 0, 684, 684, 684, 684, 0, 696, 684, 0, 0, 0, 0, 684, 0, 0, 0, 0, 0, 686, 686, 686, 0, 0, 686, 686, 686, 684, 686, 0, 684, 0, 0, 0, 0, 0, 686, 0, 686, 686, 686, 0, 0, 0, 0, 0, 0, 0, 686, 686, 0, 686, 686, 686, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 0, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 0, 0, 0, 0, 686, 686, 686, 686, 0, 698, 686, 0, 677, 677, 0, 686, 677, 677, 677, 677, 677, 677, 677, 0, 0, 0, 0, 0, 0, 686, 0, 0, 686, 677, 677, 677, 132, 677, 677, 0, 48, 48, 48, 0, 0, 0, 48, 48, 0, 48, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 677, 0, 677, 677, 676, 0, 48, 48, 48, 48, 48, 0, 0, 0, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 677, 0, 0, 0, 0, 0, 0, 676, 676, 0, 0, 676, 676, 676, 676, 676, 676, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 676, 676, 131, 676, 676, 0, 557, 0, 558, 559, 560, 561, 562, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 563, 0, 0, 0, 0, 0, 676, 0, 676, 676, 0, 0, 0, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 679, 565, 0, 0, 0, 0, 566, 567, 568, 0, 0, 0, 0, 0, 0, 0, 676, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 679, 679, 0, 0, 679, 679, 679, 679, 679, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 679, 679, 679, 134, 679, 679, 0, 0, 0, 0, 0, 677, 677, 677, 0, 0, 677, 677, 677, 0, 677, 0, 0, 0, 0, 0, 0, 0, 677, 0, 677, 677, 677, 679, 0, 679, 679, 0, 0, 0, 677, 677, 0, 677, 677, 677, 677, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 0, 679, 679, 0, 50, 0, 0, 0, 0, 0, 677, 677};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyTable2() {
        return new short[]{677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 0, 0, 0, 0, 677, 677, 677, 677, 0, 689, 677, 0, 50, 0, 0, 677, 0, 0, 676, 676, 676, 0, 0, 676, 676, 676, 0, 676, 0, 677, 50, 0, 677, 0, 0, 676, 0, 676, 676, 676, 0, 0, 0, 0, 0, 0, 0, 676, 676, 0, 676, 676, 676, 676, 676, 0, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 369, 0, 368, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 0, 50, 0, 0, 676, 676, 676, 676, 0, 688, 676, 0, 0, 0, 0, 676, 0, 0, 371, 0, 0, 679, 679, 679, 0, 0, 679, 679, 679, 676, 679, 0, 676, 0, 0, 0, 0, 0, 679, 0, 679, 679, 679, 0, 0, 0, 0, 0, 370, 0, 679, 679, 0, 679, 679, 679, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 483, 0, 0, 0, 0, 0, 0, 0, 0, 0, 483, 0, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 0, 0, 0, 0, 679, 679, 679, 679, 0, 691, 679, 0, 483, 483, 0, 679, 483, 483, 483, 483, 483, 483, 483, 0, 0, 0, 0, 0, 0, 679, 0, 0, 679, 483, 483, 483, 0, 483, 483, 0, 50, 50, 50, 0, 0, 0, 50, 50, 0, 50, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 483, 0, 483, 483, 816, 0, 50, 50, 50, 50, 50, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 483, 483, 483, 0, 0, 0, 0, 0, 0, 816, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 816, 0, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 351, 0, 0, 0, 0, 356, 357, 0, 0, 816, 0, 816, 816, 0, 0, 0, 337, 364, 365, 0, 0, 0, 0, 0, 0, 0, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 0, 0, 337, 337, 337, 337, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 337, 148, 337, 337, 0, 0, 0, 0, 0, 483, 483, 483, 0, 0, 483, 483, 483, 0, 483, 0, 0, 0, 0, 0, 0, 0, 483, 483, 483, 483, 483, 337, 0, 337, 337, 0, 0, 0, 483, 483, 0, 483, 483, 483, 483, 483, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 0, 0, 0, 337, 337, 0, 47, 0, 0, 0, 0, 0, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 0, 0, 0, 0, 483, 483, 483, 483, 0, 0, 483, 0, 47, 0, 0, 483, 0, 0, 816, 816, 816, 0, 0, 816, 816, 816, 0, 816, 0, 483, 47, 0, 483, 0, 0, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 0, 47, 0, 0, 816, 816, 816, 816, 0, 0, 816, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 337, 337, 337, 0, 0, 337, 337, 337, 816, 337, 0, 816, 0, 0, 0, 0, 0, 337, 0, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 337, 337, 0, 337, 337, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 0, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 0, 0, 0, 0, 337, 337, 337, 337, 0, 0, 337, 0, 347, 347, 0, 337, 347, 347, 347, 347, 347, 347, 347, 0, 0, 0, 0, 0, 0, 337, 0, 0, 337, 347, 347, 347, 147, 347, 347, 0, 47, 47, 47, 0, 0, 0, 47, 47, 0, 47, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 0, 0, 0, 0, 0, 347, 0, 347, 347, 619, 0, 47, 47, 47, 47, 0, 0, 0, 0, 619, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 347, 0, 0, 0, 0, 0, 0, 619, 619, 0, 0, 619, 619, 619, 619, 619, 619, 619, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 619, 619, 619, 0, 619, 619, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 619, 0, 619, 619, 0, 0, 0, 282, 0, 0, 0, 0, 0, 0, 0, 0, 0, 282, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 619, 619, 0, 0, 0, 0, 0, 0, 0, 0, 0, 282, 282, 0, 0, 282, 282, 282, 282, 282, 384, 282, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 282, 282, 282, 0, 282, 282, 0, 0, 0, 0, 0, 347, 347, 347, 0, 0, 347, 347, 347, 0, 347, 0, 0, 0, 0, 0, 0, 0, 347, 0, 347, 347, 347, 384, 0, 282, 282, 0, 0, 0, 347, 347, 0, 347, 347, 347, 347, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 282, 282, 0, 49, 0, 0, 0, 0, 0, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 0, 0, 0, 0, 347, 347, 347, 347, 0, 0, 347, 0, 49, 0, 0, 347, 0, 0, 619, 619, 619, 0, 0, 619, 619, 619, 0, 619, 0, 347, 49, 0, 347, 0, 0, 619, 0, 619, 619, 619, 0, 0, 0, 0, 0, 0, 0, 619, 619, 0, 619, 619, 619, 619, 619, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 619, 619, 619, 619, 619, 619, 619, 619, 619, 619, 619, 619, 619, 0, 49, 0, 0, 619, 619, 619, 619, 0, 0, 619, 0, 0, 0, 0, 619, 0, 0, 0, 0, 0, 282, 282, 282, 0, 0, 282, 282, 282, 619, 282, 0, 619, 0, 0, 0, 0, 0, 282, 0, 282, 282, 282, 0, 0, 0, 0, 0, 0, 0, 282, 282, 0, 282, 282, 282, 282, 282, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 359, 0, 0, 0, 0, 0, 0, 0, 0, 0, 359, 0, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 0, 0, 0, 0, 282, 282, 384, 384, 0, 0, 282, 0, 359, 359, 0, 282, 359, 359, 359, 359, 359, 359, 359, 0, 0, 0, 0, 0, 0, 282, 0, 0, 282, 359, 359, 359, 0, 359, 359, 0, 49, 49, 49, 0, 0, 0, 49, 49, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 359, 0, 359, 359, 353, 0, 49, 49, 49, 49, 0, 0, 0, 0, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 359, 359, 0, 0, 0, 0, 0, 0, 353, 353, 0, 0, 353, 353, 353, 353, 353, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 353, 353, 353, 0, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 353, 0, 353, 353, 0, 0, 0, 667, 0, 0, 0, 0, 0, 0, 0, 0, 0, 667, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 667, 667, 0, 0, 667, 667, 667, 667, 667, 667, 667, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 667, 667, 667, 0, 667, 667, 0, 0, 0, 0, 0, 359, 359, 359, 0, 0, 359, 359, 359, 0, 359, 0, 0, 0, 0, 0, 0, 0, 359, 0, 359, 359, 359, 667, 0, 667, 667, 0, 0, 0, 359, 359, 0, 359, 359, 359, 359, 359, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 667, 667, 0, 0, 52, 0, 0, 0, 0, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 0, 0, 0, 0, 359, 359, 359, 359, 0, 0, 359, 0, 0, 52, 0, 359, 0, 0, 353, 353, 353, 0, 0, 353, 353, 353, 0, 353, 0, 359, 0, 52, 359, 0, 0, 353, 0, 353, 353, 353, 0, 0, 0, 0, 0, 0, 0, 353, 353, 0, 353, 353, 353, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 321, 0, 0, 0, 0, 0, 0, 0, 0, 0, 321, 0, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 0, 0, 52, 0, 353, 353, 353, 353, 0, 0, 353, 0, 0, 0, 0, 353, 321, 0, 0, 321, 0, 667, 667, 667, 0, 0, 667, 667, 667, 353, 667, 0, 353, 0, 321, 0, 0, 0, 667, 0, 667, 667, 667, 0, 0, 0, 0, 0, 0, 0, 667, 667, 0, 667, 667, 667, 667, 667, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 321, 0, 0, 0, 0, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 0, 0, 667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 0, 0, 321, 0, 667, 667, 667, 667, 0, 0, 667, 0, 246, 246, 0, 667, 246, 246, 246, 246, 246, 0, 246, 0, 0, 0, 0, 0, 0, 667, 0, 0, 667, 246, 246, 246, 0, 246, 246, 0, 0, 52, 52, 52, 0, 0, 0, 52, 52, 0, 52, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 246, 247, 0, 0, 52, 52, 52, 52, 0, 0, 0, 247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 246, 0, 0, 0, 0, 0, 0, 247, 247, 0, 0, 247, 247, 247, 247, 247, 0, 247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 247, 247, 0, 247, 247, 0, 0, 0, 0, 0, 321, 321, 321, 0, 0, 321, 321, 321, 52, 321, 0, 0, 0, 0, 0, 0, 0, 321, 0, 321, 321, 0, 0, 0, 247, 247, 0, 258, 0, 321, 321, 0, 321, 321, 321, 321, 321, 258, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 247, 0, 0, 0, 0, 0, 0, 0, 258, 258, 0, 0, 258, 258, 258, 258, 258, 0, 258, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 258, 258, 258, 0, 258, 258, 0, 321, 0, 0, 0, 0, 0, 246, 246, 246, 0, 0, 246, 246, 246, 321, 246, 0, 0, 0, 0, 0, 0, 0, 246, 0, 246, 246, 246, 258, 258, 0, 0, 0, 0, 0, 246, 246, 0, 246, 246, 246, 246, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 817, 0, 0, 0, 0, 258, 258, 0, 0, 0, 817, 0, 0, 0, 0, 0, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 0, 0, 0, 0, 246, 246, 0, 0, 0, 0, 246, 0, 817, 0, 0, 246, 325, 0, 247, 247, 247, 0, 0, 247, 247, 247, 325, 247, 0, 246, 817, 0, 246, 0, 0, 247, 0, 247, 247, 247, 0, 0, 0, 0, 0, 0, 0, 247, 247, 0, 247, 247, 247, 247, 247, 0, 0, 325, 0, 0, 321, 0, 0, 0, 817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 325, 0, 0, 0, 0, 0, 0, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 0, 817, 0, 0, 247, 247, 0, 0, 0, 0, 247, 0, 0, 0, 0, 247, 0, 38, 0, 258, 258, 258, 0, 0, 258, 258, 258, 38, 258, 247, 0, 0, 247, 0, 0, 0, 258, 0, 258, 258, 258, 0, 0, 0, 0, 0, 325, 0, 258, 258, 0, 258, 258, 258, 258, 258, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 38, 0, 0, 0, 0, 255, 0, 0, 258, 258, 258, 258, 258, 258, 258, 258, 258, 258, 258, 258, 0, 0, 0, 0, 258, 258, 0, 0, 0, 0, 258, 0, 255, 255, 0, 258, 255, 255, 255, 255, 255, 0, 255, 0, 0, 0, 0, 0, 0, 258, 0, 0, 258, 255, 255, 255, 0, 255, 255, 0, 0, 0, 817, 817, 817, 0, 38, 817, 817, 817, 0, 817, 0, 0, 0, 0, 0, 0, 0, 817, 0, 817, 817, 0, 0, 0, 0, 0, 255, 255, 252, 817, 817, 0, 817, 817, 817, 817, 817, 0, 252, 0, 0, 0, 0, 0, 0, 325, 325, 325, 0, 0, 325, 325, 325, 0, 325, 0, 0, 255, 255, 0, 0, 0, 325, 0, 0, 252, 252, 0, 0, 252, 252, 252, 252, 252, 0, 252, 0, 325, 325, 325, 325, 325, 0, 0, 0, 0, 252, 252, 252, 0, 252, 252, 817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 252, 0, 253, 0, 0, 0, 0, 0, 0, 0, 325, 0, 253, 0, 0, 0, 0, 0, 0, 38, 38, 38, 0, 0, 0, 38, 38, 0, 38, 325, 252, 252, 0, 0, 0, 0, 38, 0, 0, 253, 253, 0, 0, 253, 253, 253, 253, 253, 0, 253, 0, 38, 38, 38, 38, 0, 0, 0, 0, 0, 253, 253, 253, 0, 253, 253, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 255, 255, 255, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 255, 255, 255, 253, 253, 0, 0, 0, 0, 0, 255, 255, 0, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 473, 0, 0, 0, 38, 253, 253, 0, 0, 0, 473, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 255, 0, 473, 0, 0, 255, 326, 473, 252, 252, 252, 0, 0, 252, 252, 252, 326, 252, 0, 255, 473, 0, 255, 0, 0, 252, 0, 252, 252, 252, 0, 0, 0, 0, 0, 0, 0, 252, 252, 0, 252, 252, 252, 252, 252, 0, 0, 326, 0, 0, 322, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 326, 0, 0, 0, 0, 0, 0, 0, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 0, 473, 0, 0, 252, 252, 0, 0, 0, 0, 252, 0, 0, 0, 0, 252, 0, 80, 0, 253, 253, 253, 0, 0, 253, 253, 253, 80, 253, 252, 0, 0, 252, 0, 0, 0, 253, 0, 253, 253, 253, 0, 0, 0, 0, 0, 326, 0, 253, 253, 0, 253, 253, 253, 253, 253, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 0, 0, 0, 0, 80, 0, 0, 0, 0, 254, 0, 0, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 0, 0, 0, 0, 253, 253, 0, 0, 0, 0, 253, 0, 254, 254, 80, 253, 254, 254, 254, 254, 254, 0, 254, 0, 0, 0, 0, 0, 0, 253, 0, 0, 253, 254, 254, 254, 0, 254, 254, 0, 0, 0, 473, 473, 473, 0, 80, 473, 473, 473, 0, 473, 0, 0, 0, 0, 0, 0, 0, 473, 0, 473, 0, 0, 0, 0, 0, 0, 254, 254, 256, 473, 473, 0, 473, 473, 473, 473, 473, 0, 256, 0, 0, 0, 0, 0, 0, 326, 326, 326, 0, 0, 326, 326, 326, 0, 326, 0, 0, 254, 254, 0, 0, 0, 326, 0, 0, 256, 256, 0, 0, 256, 256, 256, 256, 256, 0, 256, 0, 326, 326, 326, 326, 326, 0, 473, 473, 0, 256, 256, 256, 0, 256, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 473, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 256, 0, 250, 0, 0, 0, 0, 0, 0, 0, 326, 0, 250, 0, 0, 0, 0, 0, 0, 80, 80, 80, 0, 0, 80, 80, 80, 0, 80, 326, 256, 256, 0, 0, 0, 0, 80, 0, 80, 80, 250, 0, 0, 250, 0, 250, 250, 250, 80, 80, 0, 80, 80, 80, 80, 80, 0, 0, 0, 0, 250, 250, 250, 0, 250, 250, 0, 0, 0, 0, 0, 0, 0, 254, 254, 254, 0, 0, 254, 254, 254, 0, 254, 194, 0, 0, 0, 0, 0, 0, 254, 0, 254, 254, 254, 250, 250, 0, 0, 0, 0, 0, 254, 254, 0, 254, 254, 254, 254, 254, 0, 194, 0, 194, 0, 194, 0, 0, 0, 685, 0, 0, 0, 0, 0, 80, 250, 250, 0, 0, 0, 0, 194, 0, 194, 0, 0, 0, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 0, 0, 0, 0, 254, 254, 0, 0, 0, 0, 254, 0, 0, 0, 0, 254, 0, 0, 256, 256, 256, 0, 0, 256, 256, 256, 0, 256, 0, 254, 0, 0, 254, 0, 0, 256, 0, 256, 256, 256, 0, 0, 0, 0, 0, 0, 0, 256, 256, 0, 256, 256, 256, 256, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 0, 0, 0, 0, 256, 256, 84, 0, 0, 0, 256, 0, 0, 0, 0, 256, 84, 0, 0, 250, 250, 250, 0, 0, 250, 250, 250, 0, 250, 256, 0, 0, 256, 0, 0, 0, 250, 0, 250, 250, 250, 0, 0, 0, 0, 0, 0, 84, 250, 250, 0, 250, 250, 250, 250, 250, 0, 0, 0, 0, 0, 0, 0, 0, 251, 84, 0, 0, 0, 0, 0, 0, 0, 0, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 0, 0, 0, 84, 250, 250, 251, 0, 0, 251, 250, 251, 251, 251, 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 251, 251, 250, 251, 251, 250, 0, 0, 84, 0, 0, 194, 0, 194, 194, 194, 194, 194, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 0, 0, 251, 251, 271, 0, 0, 0, 0, 0, 0, 0, 0, 194, 271, 0, 377, 372, 0, 685, 0, 375, 373, 194, 374, 0, 376, 0, 194, 194, 194, 0, 0, 251, 251, 0, 0, 0, 0, 369, 0, 368, 271, 0, 0, 271, 0, 0, 271, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 271, 271, 271, 0, 271, 271, 0, 0, 0, 0, 0, 371, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 271, 271, 0, 272, 0, 0, 370, 0, 0, 0, 0, 0, 0, 272, 0, 0, 84, 84, 84, 0, 0, 84, 84, 84, 0, 84, 0, 0, 0, 0, 0, 271, 271, 84, 0, 84, 84, 0, 0, 0, 0, 272, 0, 0, 272, 84, 84, 272, 84, 84, 84, 84, 84, 0, 0, 0, 0, 0, 0, 0, 0, 272, 272, 272, 0, 272, 272, 0, 0, 0, 0, 0, 0, 0, 251, 251, 251, 0, 0, 251, 251, 251, 0, 251, 0, 0, 0, 0, 0, 0, 0, 251, 0, 251, 251, 251, 272, 272, 0, 0, 0, 0, 0, 251, 251, 0, 251, 251, 251, 251, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 276, 0, 0, 0, 272, 272, 0, 0, 0, 0, 276, 0, 0, 0, 0, 0, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 0, 0, 0, 0, 251, 251, 0, 0, 0, 0, 251, 0, 0, 276, 0, 251, 276, 0, 271, 271, 271, 0, 0, 271, 271, 271, 0, 271, 0, 251, 276, 276, 251, 0, 0, 271, 0, 271, 271, 271, 0, 0, 0, 0, 0, 0, 0, 271, 271, 0, 271, 271, 271, 271, 271, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 276, 360, 361, 0, 0, 0, 0, 0, 0, 364, 365, 0, 0, 0, 0, 0, 0, 0, 271, 271, 271, 271, 271, 271, 271, 271, 271, 271, 271, 271, 0, 0, 276, 0, 271, 271, 0, 0, 0, 0, 271, 0, 0, 0, 0, 271, 0, 0, 0, 272, 272, 272, 0, 0, 272, 272, 272, 0, 272, 271, 0, 0, 271, 0, 0, 0, 272, 0, 272, 272, 272, 0, 0, 0, 0, 0, 0, 0, 272, 272, 0, 272, 272, 272, 272, 272, 0, 0, 261, 0, 0, 0, 0, 0, 0, 0, 0, 0, 261, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 272, 272, 272, 272, 272, 272, 272, 272, 272, 272, 272, 272, 261, 0, 0, 261, 272, 272, 261, 0, 0, 0, 272, 0, 0, 0, 0, 272, 0, 0, 0, 0, 261, 261, 261, 0, 261, 261, 0, 0, 0, 272, 0, 0, 272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, 276, 276, 0, 0, 276, 276, 276, 0, 276, 0, 0, 261, 261, 259, 0, 0, 276, 0, 276, 276, 276, 0, 0, 259, 0, 0, 0, 0, 276, 276, 0, 276, 276, 276, 276, 276, 0, 0, 0, 0, 0, 0, 261, 261, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 259, 0, 0, 259, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 259, 259, 259, 0, 259, 259, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, 0, 0, 0, 0, 276, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, 259, 259, 276, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 259, 259, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 260, 0, 0, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 260, 260, 260, 0, 260, 260, 0, 0, 0, 0, 0, 0, 0, 261, 261, 261, 0, 0, 261, 261, 261, 0, 261, 0, 0, 0, 0, 0, 0, 0, 261, 0, 261, 261, 261, 260, 260, 0, 0, 0, 0, 0, 261, 261, 0, 261, 261, 261, 261, 261, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 260, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 261, 261, 261, 261, 261, 261, 261, 261, 261, 261, 261, 261, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 261, 0, 0, 0, 0, 261, 287, 0, 259, 259, 259, 0, 0, 259, 259, 259, 287, 259, 0, 261, 0, 0, 261, 0, 0, 259, 0, 259, 259, 259, 0, 0, 0, 0, 0, 0, 0, 259, 259, 0, 259, 259, 259, 259, 259, 0, 0, 287, 0, 0, 287, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 287, 287, 287, 0, 287, 287, 0, 0, 0, 259, 259, 259, 259, 259, 259, 259, 259, 259, 259, 259, 259, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 259, 0, 0, 0, 287, 259, 0, 288, 0, 260, 260, 260, 0, 0, 260, 260, 260, 288, 260, 259, 0, 0, 259, 0, 0, 0, 260, 0, 260, 260, 260, 0, 0, 0, 0, 0, 287, 0, 260, 260, 0, 260, 260, 260, 260, 260, 0, 0, 288, 0, 0, 288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 288, 288, 288, 0, 288, 288, 0, 0, 0, 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 260, 0, 0, 0, 288, 260, 262, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262, 0, 0, 260, 0, 195, 260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262, 0, 195, 262, 195, 0, 195, 0, 0, 0, 684, 0, 0, 0, 0, 0, 0, 262, 262, 0, 0, 0, 262, 195, 0, 195, 0, 0, 0, 0, 287, 287, 287, 0, 0, 287, 287, 287, 0, 287, 0, 0, 0, 0, 0, 0, 0, 287, 0, 287, 287, 287, 262, 0, 0, 0, 0, 0, 0, 287, 287, 0, 287, 287, 287, 287, 287, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264, 0, 0, 0, 0, 262, 0, 0, 0, 0, 264, 0, 0, 0, 0, 0, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 287, 0, 0, 264, 0, 287, 264, 0, 0, 288, 288, 288, 0, 0, 288, 288, 288, 0, 288, 287, 264, 264, 287, 0, 0, 264, 288, 0, 288, 288, 288, 0, 0, 0, 0, 0, 0, 0, 288, 288, 0, 288, 288, 288, 288, 288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 288, 288, 288, 288, 288, 288, 288, 288, 288, 288, 288, 288, 0, 264, 0, 0, 0, 0, 0, 0, 0, 0, 288, 0, 0, 0, 0, 288, 265, 0, 262, 262, 262, 0, 0, 262, 262, 262, 265, 262, 0, 288, 0, 0, 288, 0, 0, 262, 0, 262, 262, 262, 0, 0, 0, 0, 0, 0, 0, 262, 262, 0, 262, 262, 262, 262, 262, 0, 0, 265, 0, 0, 265, 0, 0, 0, 0, 0, 0, 195, 0, 195, 195, 195, 195, 195, 265, 265, 0, 0, 0, 265, 0, 0, 0, 0, 0, 0, 0, 195, 0, 262, 262, 0, 0, 262, 262, 0, 0, 0, 0, 0, 0, 195, 0, 0, 0, 262, 0, 684, 0, 265, 262, 195, 0, 0, 0, 0, 195, 195, 195, 0, 0, 0, 0, 0, 262, 0, 0, 262, 0, 0, 0, 0, 0, 0, 0, 0, 266, 0, 264, 264, 264, 265, 0, 264, 264, 264, 266, 264, 0, 0, 0, 0, 0, 0, 0, 264, 0, 264, 264, 264, 0, 0, 0, 0, 0, 0, 0, 264, 264, 0, 264, 264, 264, 264, 264, 0, 0, 266, 0, 0, 266, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 266, 266, 0, 273, 0, 266, 0, 0, 0, 0, 0, 0, 0, 273, 0, 264, 264, 0, 0, 264, 264, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264, 0, 0, 0, 266, 264, 0, 0, 0, 0, 0, 0, 0, 273, 0, 0, 273, 0, 0, 264, 0, 0, 264, 0, 0, 0, 0, 0, 0, 0, 273, 273, 0, 0, 0, 273, 266, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 265, 265, 265, 0, 0, 265, 265, 265, 0, 265, 0, 0, 273, 0, 0, 0, 0, 265, 0, 265, 265, 265, 0, 0, 0, 0, 0, 0, 0, 265, 265, 0, 265, 265, 265, 265, 265, 267, 0, 0, 0, 0, 0, 0, 273, 0, 0, 267, 0, 0, 0, 0, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 265, 265, 0, 0, 265, 265, 0, 267, 0, 196, 267, 196, 0, 196, 0, 0, 265, 686, 0, 0, 0, 265, 0, 0, 267, 267, 0, 0, 0, 267, 196, 0, 196, 0, 0, 265, 0, 0, 265, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 266, 266, 266, 0, 0, 266, 266, 266, 0, 266, 267, 0, 0, 0, 0, 0, 0, 266, 0, 266, 266, 266, 0, 0, 0, 0, 0, 0, 0, 266, 266, 0, 266, 266, 266, 266, 266, 0, 0, 0, 0, 0, 267, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 273, 273, 273, 268, 0, 273, 273, 273, 0, 273, 266, 266, 0, 268, 266, 266, 0, 273, 0, 273, 273, 273, 0, 0, 0, 0, 266, 0, 0, 273, 273, 266, 273, 273, 273, 273, 273, 0, 0, 0, 0, 0, 0, 0, 268, 266, 0, 268, 266, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 268, 268, 0, 0, 0, 268, 0, 0, 0, 0, 273, 273, 0, 0, 273, 273, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 273, 0, 0, 0, 0, 273, 0, 0, 0, 268, 0, 0, 0, 0, 0, 0, 0, 0, 0, 273, 0, 0, 273, 0, 0, 0, 0, 0, 0, 274, 0, 267, 267, 267, 0, 0, 267, 267, 267, 274, 267, 268, 0, 0, 0, 0, 0, 0, 267, 0, 267, 267, 267, 0, 0, 0, 0, 0, 0, 0, 267, 267, 0, 267, 267, 267, 267, 267, 0, 0, 274, 0, 0, 274, 0, 0, 0, 0, 0, 0, 196, 0, 196, 196, 196, 196, 196, 274, 274, 0, 0, 0, 274, 0, 0, 0, 0, 0, 0, 0, 196, 0, 267, 267, 0, 0, 267, 267, 0, 0, 0, 0, 0, 0, 196, 0, 0, 0, 267, 0, 686, 0, 274, 267, 196, 0, 0, 0, 0, 196, 196, 196, 0, 0, 0, 0, 0, 267, 0, 0, 267, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 274, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 0, 0, 268, 268, 268, 0, 0, 268, 268, 268, 0, 268, 0, 0, 0, 0, 0, 0, 0, 268, 0, 268, 268, 268, 0, 0, 0, 0, 0, 0, 248, 268, 268, 248, 268, 268, 268, 268, 268, 0, 0, 0, 0, 0, 0, 0, 0, 248, 248, 0, 0, 0, 248, 0, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 0, 0, 268, 268, 0, 0, 268, 268, 0, 0, 0, 248, 0, 0, 0, 0, 0, 0, 268, 0, 0, 0, 0, 268, 74, 0, 0, 0, 0, 0, 0, 249, 0, 0, 0, 0, 0, 268, 0, 0, 268, 249, 74, 248, 274, 274, 274, 0, 0, 274, 274, 274, 0, 274, 0, 0, 0, 0, 0, 0, 0, 274, 0, 274, 274, 274, 0, 0, 0, 0, 0, 244, 249, 274, 274, 249, 274, 274, 274, 274, 274, 244, 0, 0, 0, 0, 0, 0, 0, 249, 249, 0, 0, 0, 249, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 244, 0, 0, 244, 274, 377, 372, 274, 274, 0, 375, 373, 249, 374, 0, 376, 0, 244, 244, 274, 0, 0, 244, 0, 274, 0, 0, 0, 369, 0, 368, 0, 0, 0, 0, 0, 0, 0, 274, 0, 0, 274, 0, 0, 249, 0, 0, 0, 0, 0, 0, 0, 244, 0, 0, 245, 0, 0, 0, 0, 0, 0, 371, 0, 0, 245, 0, 0, 248, 248, 248, 0, 0, 248, 248, 248, 0, 248, 0, 0, 0, 0, 0, 0, 244, 248, 0, 248, 248, 248, 0, 0, 370, 0, 0, 154, 245, 248, 248, 245, 248, 248, 248, 248, 248, 0, 0, 0, 0, 0, 0, 0, 0, 245, 245, 0, 0, 0, 245, 0, 0, 0, 0, 154, 0, 154, 0, 154, 0, 0, 0, 675, 0, 74, 74, 74, 0, 0, 74, 74, 74, 0, 74, 0, 154, 0, 154, 0, 245, 0, 74, 0, 74, 0, 0, 248, 0, 0, 0, 0, 248, 0, 74, 74, 0, 74, 74, 74, 74, 74, 0, 0, 0, 0, 248, 0, 0, 248, 0, 0, 245, 249, 249, 249, 0, 0, 249, 249, 249, 0, 249, 0, 0, 0, 0, 0, 0, 0, 249, 0, 249, 249, 249, 0, 0, 0, 0, 0, 279, 0, 249, 249, 0, 249, 249, 249, 249, 249, 279, 0, 0, 244, 244, 244, 0, 0, 244, 244, 244, 0, 244, 0, 0, 0, 0, 0, 0, 0, 244, 74, 244, 244, 244, 0, 0, 0, 0, 0, 281, 279, 244, 244, 279, 244, 244, 244, 244, 244, 281, 0, 0, 0, 0, 0, 0, 0, 279, 279, 249, 0, 0, 0, 0, 249, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 0, 281, 249, 0, 281, 0, 351, 352, 353, 354, 355, 356, 357, 279, 0, 360, 361, 0, 281, 281, 244, 0, 0, 364, 365, 244, 0, 0, 0, 245, 245, 245, 0, 0, 245, 245, 245, 0, 245, 244, 0, 0, 244, 0, 0, 279, 245, 0, 245, 245, 245, 0, 0, 281, 0, 0, 277, 0, 245, 245, 0, 245, 245, 245, 245, 245, 277, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 281, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 277, 0, 0, 277, 297, 0, 154, 0, 154, 154, 154, 154, 154, 0, 297, 0, 0, 277, 277, 245, 0, 0, 0, 0, 245, 0, 154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 0, 154, 245, 0, 0, 0, 297, 675, 0, 297, 0, 154, 0, 277, 0, 291, 154, 154, 154, 0, 0, 0, 0, 297, 297, 291, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 277, 279, 279, 279, 0, 0, 279, 279, 279, 0, 279, 291, 0, 297, 291, 0, 0, 0, 279, 0, 279, 279, 279, 0, 0, 0, 0, 0, 0, 291, 279, 279, 0, 279, 279, 279, 279, 279, 0, 278, 0, 281, 281, 281, 0, 297, 281, 281, 281, 278, 281, 0, 0, 0, 0, 0, 0, 0, 281, 0, 281, 281, 281, 291, 0, 0, 0, 0, 0, 0, 281, 281, 0, 281, 281, 281, 281, 281, 0, 0, 278, 0, 280, 278, 0, 0, 0, 0, 279, 0, 0, 0, 280, 279, 0, 291, 0, 278, 278, 0, 0, 0, 0, 0, 0, 0, 0, 279, 0, 0, 279, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 280, 0, 0, 280, 0, 281, 0, 0, 0, 278, 281, 0, 0, 0, 277, 277, 277, 280, 280, 277, 277, 277, 0, 277, 281, 0, 0, 281, 296, 0, 0, 277, 0, 277, 277, 277, 0, 0, 296, 0, 0, 278, 0, 277, 277, 0, 277, 277, 277, 277, 277, 0, 280, 0, 0, 0, 0, 0, 0, 297, 297, 297, 0, 0, 297, 297, 297, 0, 297, 296, 0, 0, 296, 0, 0, 0, 297, 0, 297, 297, 297, 0, 0, 0, 280, 0, 296, 296, 297, 297, 0, 297, 297, 297, 297, 297, 0, 0, 0, 0, 0, 277, 0, 0, 0, 0, 277, 0, 0, 291, 291, 291, 0, 0, 291, 291, 291, 0, 291, 0, 277, 296, 0, 277, 0, 0, 291, 0, 291, 291, 291, 0, 0, 0, 0, 0, 0, 0, 291, 291, 0, 291, 291, 291, 291, 291, 297, 0, 0, 0, 66, 297, 0, 296, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 297, 0, 0, 297, 0, 0, 0, 0, 0, 0, 0, 0, 0, 278, 278, 278, 0, 0, 278, 278, 278, 0, 278, 0, 0, 0, 66, 0, 0, 0, 278, 291, 278, 278, 278, 0, 291, 0, 0, 0, 0, 0, 278, 278, 66, 278, 278, 278, 278, 0, 291, 0, 0, 291, 0, 0, 280, 280, 280, 0, 0, 280, 280, 280, 0, 280, 0, 0, 0, 0, 82, 0, 0, 280, 0, 280, 280, 280, 0, 0, 82, 0, 0, 0, 0, 280, 280, 0, 280, 280, 280, 280, 0, 0, 0, 0, 0, 0, 0, 0, 278, 0, 0, 0, 0, 278, 0, 0, 0, 0, 66, 82, 0, 0, 0, 0, 0, 0, 0, 278, 0, 0, 278, 0, 0, 296, 296, 296, 0, 82, 296, 296, 296, 0, 296, 0, 0, 0, 0, 483, 0, 0, 296, 280, 296, 296, 296, 0, 280, 483, 0, 0, 0, 0, 296, 296, 0, 296, 296, 296, 296, 0, 280, 82, 0, 280, 0, 0, 0, 0, 0, 0, 313, 0, 0, 0, 483, 483, 0, 0, 483, 483, 483, 483, 483, 483, 483, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 483, 483, 0, 483, 483, 0, 0, 0, 0, 0, 0, 0, 0, 0, 296, 0, 0, 0, 0, 296, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 483, 296, 483, 483, 296, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 66, 0, 816, 66, 66, 66, 0, 66, 0, 0, 0, 0, 816, 483, 483, 483, 313, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 0, 66, 66, 66, 66, 66, 313, 0, 0, 0, 816, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 82, 82, 0, 0, 82, 82, 82, 0, 82, 816, 0, 816, 816, 0, 0, 0, 82, 0, 82, 82, 66, 0, 0, 0, 0, 0, 0, 0, 82, 82, 0, 82, 82, 82, 82, 82, 0, 0, 0, 0, 0, 816, 816, 816, 313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 313, 313, 313, 0, 313, 483, 483, 483, 313, 313, 483, 483, 483, 313, 483, 313, 313, 313, 313, 313, 313, 313, 483, 483, 483, 483, 0, 313, 313, 313, 313, 313, 313, 313, 483, 483, 313, 483, 483, 483, 483, 483, 82, 313, 0, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 313, 313, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 483, 313, 313, 0, 0, 483, 483, 483, 483, 313, 0, 483, 313, 313, 313, 313, 483, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 313, 313, 483, 313, 313, 313, 0, 313, 816, 816, 816, 313, 313, 816, 816, 816, 313, 816, 313, 313, 313, 313, 313, 313, 313, 816, 816, 816, 816, 0, 313, 313, 313, 313, 313, 313, 313, 816, 816, 313, 816, 816, 816, 816, 816, 0, 313, 0, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 313, 313, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 313, 313, 0, 0, 816, 816, 816, 816, 313, 0, 816, 313, 313, 313, 313, 816, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 353, 313, 313, 816, 0, 0, 0, 0, 0, 0, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 313, 0, 0, 0, 353, 353, 0, 0, 353, 353, 353, 353, 353, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 353, 353, 0, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 353, 0, 353, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 0, 353, 353, 313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 786, 0, 0, 0, 675, 675, 0, 786, 675, 675, 675, 111, 675, 675, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 675, 130, 675, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 0, 0, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 786, 675, 675, 786, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 313, 313, 313, 0, 313, 353, 353, 353, 313, 313, 353, 353, 353, 313, 353, 313, 313, 313, 313, 313, 313, 313, 353, 0, 353, 353, 0, 313, 313, 313, 313, 313, 313, 313, 353, 353, 313, 353, 353, 353, 353, 353, 0, 313, 0, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 313, 313, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 313, 313, 0, 0, 353, 353, 353, 353, 313, 0, 353, 313, 313, 313, 313, 353, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 313, 313, 353, 786, 786, 786, 0, 786, 675, 675, 675, 786, 786, 0, 675, 675, 786, 675, 786, 786, 786, 786, 786, 786, 786, 675, 786, 0, 0, 0, 786, 786, 786, 786, 786, 786, 786, 675, 675, 786, 675, 675, 675, 675, 675, 0, 786, 0, 0, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 0, 0, 786, 0, 786, 786, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 675, 786, 786, 0, 0, 675, 675, 675, 675, 786, 687, 675, 786, 786, 786, 786, 0, 786, 786, 786, 786, 786, 786, 786, 786, 786, 786, 678, 786, 786, 675, 0, 0, 0, 0, 0, 0, 678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 787, 0, 0, 0, 678, 678, 0, 787, 678, 678, 678, 114, 678, 678, 678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 678, 678, 133, 678, 678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 678, 0, 0, 678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 787, 678, 678, 787, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 793, 793, 0, 789, 793, 793, 793, 125, 793, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 793, 144, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 793, 793, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 787, 787, 787, 0, 787, 678, 678, 678, 787, 787, 0, 678, 678, 787, 678, 787, 787, 787, 787, 787, 787, 787, 678, 787, 0, 0, 0, 787, 787, 787, 787, 787, 787, 787, 678, 678, 787, 678, 678, 678, 678, 678, 0, 787, 0, 0, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 0, 0, 787, 0, 787, 787, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 678, 787, 787, 0, 0, 678, 678, 678, 678, 787, 690, 678, 787, 787, 787, 787, 0, 787, 787, 787, 787, 787, 787, 787, 787, 787, 787, 0, 787, 787, 678, 789, 789, 789, 0, 789, 793, 793, 793, 789, 789, 0, 793, 793, 789, 793, 789, 789, 789, 789, 789, 789, 789, 793, 793, 0, 0, 0, 789, 789, 789, 789, 789, 789, 789, 793, 793, 789, 793, 793, 793, 793, 793, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 789, 789, 0, 0, 793, 793, 793, 793, 789, 0, 793, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 793, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 789, 789, 0, 789, 789, 789, 789, 124, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 143, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyTable3() {
        return new short[]{0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 789, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 790, 790, 0, 790, 790, 790, 790, 126, 790, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 145, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 789, 789, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 793, 790, 790, 790, 0, 0, 0, 0, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 793, 793, 0, 789, 793, 793, 793, 793, 793, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 793, 144, 793, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 793, 793, 793, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 143, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 789, 789, 789, 0, 789, 793, 793, 793, 789, 789, 0, 793, 793, 789, 793, 789, 789, 789, 789, 789, 789, 789, 793, 793, 0, 0, 0, 789, 789, 789, 789, 789, 789, 789, 793, 793, 789, 793, 793, 793, 793, 793, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 793, 789, 789, 0, 0, 793, 793, 793, 793, 789, 0, 793, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 789, 793, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 789, 0, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 0, 0, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 0, 789, 789, 789, 789, 789, 789, 789, 789, 789, 789, 790, 789, 789, 789, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 145, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 790, 790, 790, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 346, 346, 0, 790, 346, 346, 346, 127, 346, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 346, 146, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 346, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 0, 790, 346, 346, 346, 790, 790, 0, 346, 346, 790, 346, 790, 790, 790, 790, 790, 790, 790, 346, 0, 0, 0, 0, 790, 790, 790, 790, 790, 790, 790, 346, 346, 790, 346, 346, 346, 346, 346, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 790, 790, 0, 0, 346, 346, 346, 346, 790, 0, 346, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 346, 790, 790, 346, 0, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 0, 0, 0, 346, 346, 0, 790, 346, 346, 346, 346, 346, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 346, 146, 346, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 346, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 0, 346, 346, 790, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 313, 0, 0, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 0, 155, 0, 155, 0, 0, 0, 678, 0, 0, 816, 0, 816, 313, 0, 0, 0, 0, 0, 0, 155, 0, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 790, 790, 790, 0, 790, 346, 346, 346, 790, 790, 0, 346, 346, 790, 346, 790, 790, 790, 790, 790, 790, 790, 346, 0, 0, 0, 0, 790, 790, 790, 790, 790, 790, 790, 346, 346, 790, 346, 346, 346, 346, 346, 0, 790, 0, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 0, 790, 0, 790, 790, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 790, 790, 0, 0, 346, 346, 346, 346, 790, 0, 346, 790, 790, 790, 790, 0, 790, 790, 790, 790, 790, 790, 790, 790, 790, 790, 0, 790, 790, 346, 313, 313, 313, 0, 313, 816, 816, 816, 313, 313, 816, 816, 816, 313, 816, 313, 313, 313, 313, 313, 313, 313, 816, 816, 816, 0, 0, 313, 313, 313, 313, 313, 313, 313, 816, 816, 313, 816, 816, 816, 816, 816, 0, 313, 0, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 313, 313, 0, 0, 0, 0, 0, 0, 380, 0, 0, 0, 0, 0, 0, 313, 313, 0, 380, 0, 0, 816, 816, 313, 0, 0, 313, 313, 313, 313, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 313, 313, 816, 380, 380, 0, 0, 380, 380, 380, 380, 380, 380, 380, 155, 0, 155, 155, 155, 155, 155, 0, 0, 0, 0, 380, 380, 0, 380, 380, 0, 0, 0, 0, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 0, 0, 0, 0, 0, 678, 0, 0, 380, 155, 380, 380, 381, 0, 155, 155, 155, 0, 0, 0, 0, 0, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 380, 380, 0, 0, 0, 0, 0, 0, 381, 381, 0, 0, 381, 381, 381, 381, 381, 381, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 381, 381, 0, 381, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 381, 0, 381, 381, 0, 0, 0, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 381, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 350, 350, 0, 0, 350, 350, 350, 350, 350, 350, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 350, 350, 0, 350, 350, 0, 0, 0, 0, 0, 380, 380, 380, 0, 0, 380, 380, 380, 0, 380, 0, 0, 0, 0, 0, 0, 0, 380, 0, 380, 380, 0, 350, 0, 350, 350, 0, 0, 0, 380, 380, 0, 380, 380, 380, 380, 380, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 350, 350, 0, 0, 0, 0, 0, 0, 0, 380, 380, 380, 380, 380, 380, 380, 380, 380, 380, 380, 380, 380, 0, 0, 0, 0, 380, 380, 380, 380, 0, 0, 380, 0, 0, 0, 0, 380, 0, 0, 381, 381, 381, 0, 0, 381, 381, 381, 0, 381, 0, 380, 0, 0, 0, 0, 0, 381, 0, 381, 381, 0, 0, 0, 0, 0, 0, 0, 0, 381, 381, 0, 381, 381, 381, 381, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 381, 381, 381, 381, 381, 381, 381, 381, 381, 381, 381, 381, 381, 0, 0, 0, 0, 381, 381, 381, 381, 0, 0, 381, 0, 0, 0, 0, 381, 0, 0, 0, 0, 0, 350, 350, 350, 0, 0, 350, 350, 350, 381, 350, 0, 0, 0, 0, 0, 0, 0, 350, 0, 350, 350, 0, 0, 0, 0, 0, 0, 0, 0, 350, 350, 0, 350, 350, 350, 350, 350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 0, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 0, 0, 0, 0, 350, 350, 350, 350, 0, 0, 350, 0, 484, 484, 0, 350, 484, 484, 484, 123, 484, 484, 484, 0, 0, 0, 0, 0, 0, 350, 0, 0, 0, 0, 484, 484, 142, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 0, 0, 484, 0, 0, 0, 0, 0, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 484, 0, 484, 484, 0, 0, 484, 484, 484, 484, 484, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 142, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 681, 0, 484, 0, 0, 0, 0, 0, 0, 0, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 484, 0, 0, 0, 681, 681, 0, 0, 681, 681, 681, 117, 681, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 681, 136, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 484, 0, 0, 0, 484, 484, 0, 484, 0, 681, 0, 0, 681, 0, 0, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 0, 484, 484, 484, 484, 484, 0, 0, 0, 0, 0, 0, 0, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 0, 0, 0, 0, 484, 484, 484, 484, 0, 0, 484, 0, 0, 484, 484, 484, 0, 0, 0, 484, 484, 0, 484, 0, 0, 0, 0, 0, 0, 484, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 0, 484, 484, 484, 484, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 0, 0, 0, 0, 484, 484, 484, 484, 0, 0, 484, 0, 0, 0, 0, 681, 681, 681, 0, 0, 0, 681, 681, 0, 681, 0, 0, 0, 0, 484, 0, 0, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 681, 681, 0, 681, 681, 681, 681, 681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 0, 0, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 681, 0, 0, 0, 0, 681, 681, 681, 681, 0, 693, 681, 680, 680, 0, 0, 680, 680, 680, 116, 680, 680, 680, 0, 0, 0, 0, 0, 0, 0, 681, 0, 0, 0, 680, 680, 135, 680, 680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 680, 0, 0, 680, 0, 0, 0, 0, 0, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 680, 0, 682, 682, 0, 0, 682, 682, 682, 118, 682, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 137, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 683, 0, 682, 0, 0, 0, 0, 0, 0, 0, 683, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 369, 0, 368, 683, 683, 0, 0, 683, 683, 683, 119, 683, 683, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 683, 683, 138, 683, 683, 0, 0, 0, 0, 371, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 680, 680, 0, 0, 0, 680, 680, 0, 680, 0, 683, 0, 0, 683, 0, 0, 680, 370, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 680, 0, 680, 680, 680, 680, 680, 0, 0, 0, 0, 0, 0, 0, 683, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 680, 0, 0, 0, 0, 680, 680, 680, 680, 0, 692, 680, 0, 0, 682, 682, 682, 0, 0, 0, 682, 682, 0, 682, 0, 0, 0, 0, 0, 0, 680, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 0, 682, 682, 682, 682, 682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 682, 0, 0, 0, 0, 682, 682, 682, 682, 0, 694, 682, 0, 0, 0, 0, 683, 683, 683, 0, 0, 0, 683, 683, 0, 683, 0, 0, 0, 0, 682, 0, 0, 683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 683, 683, 0, 683, 683, 683, 683, 683, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 0, 0, 685, 0, 0, 0, 364, 365, 0, 0, 0, 0, 685, 0, 0, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 683, 0, 0, 0, 0, 683, 683, 683, 683, 0, 695, 683, 685, 685, 0, 0, 685, 685, 685, 121, 685, 685, 685, 0, 0, 0, 0, 0, 0, 0, 683, 0, 0, 0, 685, 685, 140, 685, 685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 685, 0, 0, 685, 0, 0, 0, 0, 0, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 685, 0, 684, 684, 0, 0, 684, 684, 684, 120, 684, 684, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 139, 684, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 686, 0, 684, 0, 0, 0, 0, 0, 0, 0, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 0, 0, 0, 686, 686, 0, 0, 686, 686, 686, 122, 686, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 686, 686, 141, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 685, 685, 0, 0, 0, 685, 685, 0, 685, 0, 686, 0, 0, 686, 0, 0, 685, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 685, 0, 685, 685, 685, 685, 685, 0, 0, 0, 0, 0, 0, 0, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 0, 0, 0, 0, 685, 685, 685, 685, 0, 697, 685, 0, 0, 684, 684, 684, 0, 0, 0, 684, 684, 0, 684, 0, 0, 0, 0, 0, 0, 685, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 0, 684, 684, 684, 684, 684, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 684, 0, 0, 0, 0, 684, 684, 684, 684, 0, 696, 684, 0, 0, 0, 0, 686, 686, 686, 0, 0, 0, 686, 686, 0, 686, 0, 0, 0, 0, 684, 0, 0, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 686, 686, 0, 686, 686, 686, 686, 686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 0, 0, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 686, 0, 0, 0, 0, 686, 686, 686, 686, 0, 698, 686, 677, 677, 0, 0, 677, 677, 677, 113, 677, 677, 677, 0, 0, 0, 0, 0, 0, 0, 686, 0, 0, 0, 677, 677, 132, 677, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 677, 0, 0, 677, 0, 0, 0, 0, 0, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 677, 0, 676, 676, 0, 0, 676, 676, 676, 112, 676, 676, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 676, 131, 676, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 679, 0, 676, 0, 0, 0, 0, 0, 0, 0, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 676, 0, 0, 0, 679, 679, 0, 0, 679, 679, 679, 115, 679, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 679, 679, 134, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 677, 677, 0, 0, 0, 677, 677, 0, 677, 0, 679, 0, 0, 679, 0, 0, 677, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 677, 0, 677, 677, 677, 677, 677, 0, 0, 0, 0, 0, 0, 0, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 677, 0, 0, 0, 0, 677, 677, 677, 677, 0, 689, 677, 0, 0, 676, 676, 676, 0, 0, 0, 676, 676, 0, 676, 0, 0, 0, 0, 0, 0, 677, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 676, 0, 676, 676, 676, 676, 676, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 676, 0, 0, 0, 0, 676, 676, 676, 676, 0, 688, 676, 0, 0, 0, 0, 679, 679, 679, 0, 0, 0, 679, 679, 0, 679, 0, 0, 0, 0, 676, 0, 0, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 679, 679, 0, 679, 679, 679, 679, 679, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 0, 0, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 679, 0, 0, 0, 0, 679, 679, 679, 679, 0, 691, 679, 337, 337, 0, 0, 337, 337, 337, 129, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 679, 0, 0, 0, 337, 337, 148, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 337, 0, 0, 337, 0, 0, 0, 0, 0, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 0, 347, 347, 0, 0, 347, 347, 347, 128, 347, 347, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 347, 147, 347, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 337, 0, 347, 0, 0, 0, 0, 0, 0, 0, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 347, 0, 0, 0, 337, 337, 0, 0, 337, 337, 337, 337, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 148, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 337, 337, 0, 0, 0, 337, 337, 0, 337, 0, 337, 0, 0, 337, 0, 0, 337, 575, 0, 0, 0, 0, 0, 0, 0, 0, 0, 575, 337, 337, 0, 337, 337, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 575, 0, 0, 575, 0, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 575, 0, 0, 0, 337, 337, 337, 337, 0, 0, 337, 0, 0, 347, 347, 347, 0, 0, 0, 347, 347, 0, 347, 0, 0, 0, 0, 0, 0, 337, 347, 582, 0, 0, 575, 0, 0, 0, 0, 0, 0, 582, 347, 347, 0, 347, 347, 347, 347, 347, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 575, 575, 0, 0, 0, 0, 0, 582, 0, 0, 582, 0, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 582, 0, 578, 0, 347, 347, 347, 347, 0, 0, 347, 0, 578, 0, 0, 337, 337, 337, 0, 0, 0, 337, 337, 0, 337, 0, 0, 0, 0, 347, 0, 0, 337, 0, 582, 0, 0, 0, 0, 0, 0, 0, 0, 578, 337, 337, 578, 337, 337, 337, 337, 337, 0, 0, 0, 0, 0, 0, 0, 0, 0, 578, 0, 0, 579, 582, 582, 0, 0, 0, 0, 0, 0, 0, 579, 0, 0, 0, 0, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 337, 0, 0, 0, 578, 337, 337, 337, 337, 0, 0, 337, 0, 0, 579, 0, 0, 579, 0, 0, 0, 0, 575, 575, 575, 0, 0, 575, 575, 575, 337, 575, 579, 519, 0, 578, 578, 0, 0, 575, 0, 575, 0, 519, 0, 0, 0, 0, 0, 0, 0, 575, 575, 0, 575, 575, 575, 575, 575, 0, 0, 0, 0, 0, 0, 0, 579, 0, 0, 0, 0, 0, 0, 0, 519, 0, 0, 519, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 519, 0, 556, 0, 0, 579, 579, 0, 0, 0, 0, 0, 556, 0, 0, 0, 0, 575, 0, 0, 582, 582, 582, 0, 0, 582, 582, 582, 0, 582, 0, 0, 0, 0, 519, 0, 575, 582, 0, 582, 0, 0, 0, 556, 0, 0, 556, 0, 0, 582, 582, 0, 582, 582, 582, 582, 582, 0, 0, 0, 567, 556, 0, 0, 0, 0, 519, 0, 0, 0, 567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 578, 578, 578, 0, 0, 578, 578, 578, 0, 578, 0, 0, 0, 0, 556, 0, 0, 578, 0, 578, 567, 0, 0, 567, 0, 0, 582, 0, 0, 578, 578, 0, 578, 578, 578, 578, 578, 0, 567, 0, 0, 542, 0, 0, 0, 582, 556, 0, 0, 0, 0, 542, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 579, 579, 579, 0, 0, 579, 579, 579, 0, 579, 567, 0, 0, 0, 0, 0, 0, 579, 0, 579, 542, 0, 0, 559, 0, 578, 0, 566, 0, 579, 579, 0, 579, 579, 579, 579, 579, 566, 542, 0, 0, 0, 567, 0, 578, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 519, 519, 519, 0, 0, 519, 519, 519, 566, 519, 559, 566, 542, 0, 0, 0, 0, 519, 0, 519, 559, 0, 0, 0, 0, 0, 566, 579, 0, 519, 519, 0, 519, 519, 519, 519, 519, 0, 0, 0, 0, 0, 0, 0, 542, 0, 579, 0, 561, 0, 0, 559, 0, 0, 559, 0, 0, 0, 561, 0, 566, 556, 556, 556, 0, 0, 556, 556, 556, 559, 556, 0, 0, 0, 0, 0, 0, 0, 556, 0, 556, 0, 0, 0, 0, 0, 0, 519, 0, 561, 556, 556, 566, 556, 556, 556, 556, 556, 552, 0, 0, 0, 0, 559, 0, 0, 519, 561, 552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 567, 567, 567, 0, 0, 567, 567, 567, 0, 567, 0, 0, 0, 0, 0, 0, 559, 567, 0, 567, 552, 0, 561, 0, 0, 0, 0, 0, 0, 567, 567, 0, 567, 567, 567, 567, 567, 0, 552, 0, 0, 571, 0, 0, 0, 0, 0, 0, 556, 0, 0, 571, 0, 0, 561, 0, 0, 0, 0, 0, 0, 0, 542, 542, 542, 0, 0, 542, 542, 542, 0, 542, 552, 0, 0, 0, 0, 0, 0, 542, 0, 542, 571, 0, 0, 0, 0, 0, 0, 0, 0, 542, 542, 0, 542, 542, 542, 542, 542, 0, 571, 0, 0, 0, 552, 0, 567, 0, 543, 0, 566, 566, 566, 0, 0, 566, 566, 566, 543, 566, 0, 0, 0, 0, 0, 0, 0, 566, 0, 566, 0, 0, 0, 0, 571, 0, 0, 0, 0, 566, 566, 0, 566, 566, 566, 566, 566, 0, 0, 543, 0, 0, 0, 559, 559, 559, 0, 0, 559, 559, 559, 0, 559, 562, 0, 0, 571, 543, 542, 0, 559, 0, 559, 562, 0, 0, 0, 0, 0, 0, 0, 0, 559, 559, 0, 559, 559, 559, 559, 559, 0, 561, 561, 561, 0, 0, 561, 561, 561, 0, 561, 543, 0, 547, 562, 0, 0, 0, 561, 0, 561, 0, 0, 547, 0, 0, 566, 0, 0, 0, 561, 561, 562, 561, 561, 561, 561, 561, 0, 0, 0, 0, 0, 543, 0, 0, 0, 0, 0, 0, 0, 552, 552, 552, 547, 0, 552, 552, 552, 0, 552, 0, 0, 0, 0, 0, 562, 544, 552, 559, 552, 0, 547, 0, 0, 0, 0, 544, 0, 0, 552, 552, 0, 552, 552, 552, 552, 552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 562, 0, 0, 0, 0, 0, 0, 0, 547, 561, 544, 0, 0, 0, 0, 571, 571, 571, 0, 0, 571, 571, 571, 0, 571, 0, 553, 0, 544, 0, 0, 0, 571, 0, 571, 0, 553, 0, 0, 0, 547, 0, 0, 0, 571, 571, 0, 571, 571, 571, 571, 571, 0, 0, 0, 0, 0, 0, 0, 552, 0, 0, 544, 0, 545, 0, 0, 553, 0, 0, 0, 0, 0, 0, 545, 0, 0, 0, 0, 0, 0, 0, 543, 543, 543, 553, 0, 543, 543, 543, 0, 543, 0, 0, 544, 0, 0, 0, 0, 543, 0, 543, 0, 0, 0, 545, 0, 0, 0, 0, 0, 543, 543, 0, 543, 543, 543, 543, 543, 553, 0, 571, 548, 545, 0, 0, 0, 0, 0, 0, 0, 0, 548, 0, 0, 0, 0, 562, 562, 562, 0, 0, 562, 562, 562, 0, 562, 0, 0, 0, 0, 553, 0, 0, 562, 0, 562, 545, 0, 0, 0, 0, 0, 548, 0, 0, 562, 562, 0, 562, 562, 562, 562, 562, 0, 546, 0, 547, 547, 547, 0, 548, 547, 547, 547, 546, 547, 0, 543, 545, 0, 0, 0, 0, 547, 0, 547, 0, 0, 0, 0, 0, 0, 0, 0, 0, 547, 547, 0, 547, 547, 547, 547, 547, 76, 548, 546, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0, 0, 0, 0, 0, 544, 544, 544, 546, 0, 544, 544, 544, 0, 544, 0, 0, 562, 0, 0, 0, 548, 544, 0, 544, 0, 0, 0, 0, 76, 0, 0, 0, 0, 544, 544, 0, 544, 544, 544, 544, 544, 546, 0, 77, 0, 0, 76, 0, 0, 0, 0, 0, 0, 77, 0, 0, 547, 0, 0, 0, 0, 553, 553, 553, 0, 0, 553, 553, 553, 0, 553, 0, 0, 546, 0, 0, 0, 0, 553, 0, 553, 0, 511, 0, 77, 0, 0, 0, 0, 0, 553, 553, 511, 553, 553, 553, 553, 553, 0, 545, 545, 545, 77, 0, 545, 545, 545, 0, 545, 0, 544, 0, 76, 0, 0, 0, 545, 0, 545, 0, 0, 0, 0, 511, 0, 0, 0, 0, 545, 545, 0, 545, 545, 545, 545, 545, 512, 0, 0, 0, 0, 511, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 548, 548, 548, 0, 0, 548, 548, 548, 0, 548, 553, 77, 0, 0, 0, 0, 552, 548, 0, 548, 512, 0, 0, 0, 0, 0, 552, 0, 0, 548, 548, 0, 548, 548, 548, 548, 548, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 545, 0, 511, 0, 0, 546, 546, 546, 0, 552, 546, 546, 546, 553, 546, 0, 0, 0, 0, 0, 0, 0, 546, 553, 546, 0, 0, 552, 0, 0, 0, 0, 0, 0, 546, 546, 0, 546, 546, 546, 546, 546, 0, 0, 76, 76, 76, 0, 0, 76, 76, 76, 0, 76, 553, 296, 512, 0, 548, 0, 0, 76, 0, 76, 0, 296, 0, 0, 0, 0, 0, 0, 553, 76, 76, 0, 76, 76, 76, 76, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552, 0, 0, 296, 0, 0, 291, 77, 77, 77, 0, 0, 77, 77, 77, 0, 77, 0, 546, 0, 0, 296, 0, 0, 77, 0, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 77, 0, 77, 77, 77, 77, 77, 0, 553, 511, 511, 511, 0, 0, 511, 511, 511, 0, 511, 0, 76, 0, 0, 0, 0, 0, 511, 0, 511, 0, 0, 0, 0, 0, 0, 0, 0, 0, 511, 511, 0, 511, 511, 511, 511, 511, 0, 0, 0, 0, 296, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 512, 0, 0, 512, 512, 512, 0, 512, 0, 0, 0, 77, 0, 0, 0, 512, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 512, 512, 512, 512, 512, 552, 552, 552, 0, 0, 552, 552, 552, 0, 552, 0, 0, 0, 0, 0, 511, 0, 552, 0, 552, 0, 0, 0, 0, 0, 0, 953, 0, 0, 552, 552, 0, 552, 552, 552, 552, 552, 0, 0, 0, 0, 0, 0, 0, 0, 553, 553, 553, 0, 0, 553, 553, 553, 0, 553, 0, 0, 0, 0, 0, 0, 0, 553, 0, 553, 0, 0, 0, 0, 512, 0, 0, 0, 0, 553, 553, 0, 553, 553, 553, 553, 553, 149, 0, 0, 0, 0, 296, 296, 296, 0, 0, 0, 296, 296, 0, 296, 0, 0, 0, 0, 0, 0, 0, 296, 149, 552, 0, 0, 0, 0, 0, 786, 0, 0, 0, 296, 296, 675, 296, 296, 296, 296, 0, 0, 0, 0, 0, 0, 0, 0, 149, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 553, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 675, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 296, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 296, 150, 786, 0, 0, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, 935, 936, 937, 938, 0, 787, 0, 0, 0, 0, 0, 678, 0, 0, 0, 0, 939, 940, 941, 942, 0, 0, 0, 943, 150, 150, 40, 41, 42, 43, 44, 0, 0, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 945, 946, 0, 0, 678, 0, 0, 0, 947, 0, 0, 948, 0, 949, 950, 0, 1178, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 787, 0, 0, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 149, 0, 149, 149, 149, 149, 149, 149, 149, 0, 786, 249, 0, 0, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 0, 0, 0, 0, 0, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 0, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 0, 149, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 149, 0, 0, 0, 0, 675, 675, 149, 0, 0, 149, 149, 149, 149, 0, 149, 0, 0, 149, 149, 149, 149, 149, 149, 149, 953, 149, 149, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 0, 787, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 0, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 0, 150, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 150, 0, 149, 0, 0, 678, 678, 150, 0, 0, 150, 150, 150, 150, 0, 150, 0, 0, 150, 150, 150, 150, 150, 150, 150, 149, 150, 150, 0, 0, 0, 0, 789, 0, 0, 0, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 793, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 935, 936, 937, 938, 0, 0, 0, 0, 150, 793, 0, 0, 149, 0, 0, 0, 939, 940, 941, 942, 0, 0, 0, 943, 0, 0, 40, 41, 42, 43, 44, 150, 0, 0, 0, 303, 0, 0, 790, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 945, 946, 0, 249, 0, 150, 150, 0, 947, 0, 0, 948, 0, 949, 950, 0, 951, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 377, 372, 0, 0, 0, 375, 373, 346, 374, 0, 376, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 369, 0, 368, 367, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 371, 0, 0, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 149, 0, 149, 149, 149, 149, 149, 149, 149, 0, 793, 0, 0, 370, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 0, 0, 0, 0, 226, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 0, 149, 149, 149, 149, 149, 149, 149, 0, 0, 149, 0, 149, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 149, 0, 0, 0, 0, 793, 793, 149, 0, 0, 149, 149, 149, 149, 0, 149, 0, 0, 149, 149, 149, 149, 149, 149, 149, 0, 149, 149, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 68, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 0, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 150, 0, 150, 0, 150, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 150, 0, 0, 150, 0, 346, 346, 150, 0, 0, 150, 150, 150, 150, 0, 150, 347, 0, 150, 150, 150, 150, 150, 150, 150, 0, 150, 150, 0, 150, 150, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 0, 0, 0, 364, 365, 0, 0, 0, 0, 0, 0, 0, 0, 0, 347, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 404, 0, 0, 0, 150, 19, 20, 21, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 404, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 404, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 222, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 404, 804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 0, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 0, 522, 150, 0, 0, 0, 0, 0, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 0, 150, 150, 150, 150, 150, 150, 150, 0, 0, 150, 0, 150, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 150, 0, 0, 0, 0, 347, 347, 150, 0, 0, 150, 150, 150, 150, 0, 150, 0, 0, 150, 150, 150, 150, 150, 150, 150, 0, 150, 150, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 0, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 0, 0, 0, 0, 404, 404, 404, 404, 404, 404, 404, 0, 0, 404, 0, 0, 0, 707, 0, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 404, 0, 404, 404, 404, 404, 404, 404, 404, 707, 0, 404, 0, 404, 404, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 404, 404, 0, 0, 0, 0, 0, 707, 404, 704, 0, 404, 404, 404, 404, 0, 404, 0, 0, 404, 404, 404, 404, 404, 404, 404, 0, 404, 404, 0, 0, 0, 0, 0, 522, 522, 522, 522, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 522, 522, 522, 522, 0, 0, 0, 522, 0, 522, 522, 522, 522, 522, 522, 0, 0, 0, 0, 522, 703, 0, 0, 522, 707, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 522, 522, 0, 0, 0, 0, 0, 703, 522, 0, 0, 522, 0, 522, 522, 0, 522, 522, 0, 522, 522, 522, 522, 522, 522, 522, 0, 522, 522, 0, 0, 0, 0, 703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 369, 0, 368, 367, 703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 0, 371, 707, 707, 0, 707, 707, 707, 707, 707, 707, 707, 0, 0, 0, 0, 0, 707, 707, 707, 707, 707, 707, 707, 0, 0, 707, 0, 0, 0, 0, 370, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 707, 0, 707, 707, 707, 707, 707, 707, 707, 0, 0, 707, 0, 707, 707, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 707, 707, 0, 0, 0, 0, 0, 0, 707, 0, 0, 707};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyTable4() {
        return new short[]{707, 707, 707, 816, 707, 0, 0, 707, 707, 707, 707, 707, 707, 707, 0, 707, 707, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 0, 816, 703, 703, 0, 703, 703, 703, 703, 703, 703, 703, 0, 0, 0, 0, 0, 703, 703, 703, 703, 703, 703, 703, 0, 0, 703, 0, 0, 0, 0, 0, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 703, 0, 703, 703, 703, 703, 703, 703, 703, 0, 0, 703, 0, 703, 703, 0, 0, 0, 0, 0, 816, 0, 0, 0, 816, 0, 0, 0, 703, 703, 350, 0, 0, 0, 0, 0, 703, 0, 0, 703, 703, 703, 703, 816, 703, 0, 0, 703, 703, 703, 703, 703, 703, 703, 0, 703, 703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 0, 0, 0, 364, 365, 0, 0, 0, 0, 366, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 0, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 369, 0, 368, 367, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 371, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 370, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 249, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 0, 0, 0, 0, 226, 816, 0, 0, 816, 816, 816, 816, 0, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 816, 816, 0, 0, 0, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 339, 816, 816, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 0, 0, 0, 0, 67, 816, 0, 0, 816, 816, 816, 816, 0, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 0, 0, 0, 0, 338, 0, 931, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 0, 0, 0, 364, 365, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 222, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 67, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 26, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 67, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 26, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 68, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 3, 4, 5, 6, 7, 8, 0, 67, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 270, 4, 5, 6, 7, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 271, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 67, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 598, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 272, 54, 55, 56, 0, 57, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 270, 4, 5, 6, 7, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 68, 26, 0, 0, 0, 0, 0, 27, 28, 271, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 67, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 598, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8, 0, 67, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 4, 5, 6, 7, 8, 0, 67, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 271, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8, 0, 226, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 4, 5, 6, 7, 8, 0, 226, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 0, 0, 0, 0, 0, 27, 28, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 52, 0, 0, 53, 54, 55, 56, 0, 57, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 226, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 493, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 222, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 4, 5, 6, 68, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 313, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 707, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 493, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 707, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 226, 313, 313, 313, 0, 313, 0, 0, 0, 313, 313, 0, 0, 0, 313, 0, 313, 313, 313, 313, 313, 313, 313, 0, 0, 0, 0, 0, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 0, 0, 0, 0, 0, 313, 0, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 0, 313, 0, 313, 313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 313, 313, 0, 0, 0, 0, 0, 0, 313, 0, 68, 313, 313, 313, 313, 0, 313, 313, 313, 313, 313, 313, 313, 313, 313, 313, 0, 313, 313, 4, 5, 6, 0, 8, 0, 0, 226, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 222, 223, 68, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 226, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 0, 223, 224, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 68, 0, 0, 0, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 226, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 707, 223, 0, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 0, 226, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 219, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 0, 223, 68, 58, 59, 225, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 226, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 826, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 226, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 826, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 226, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 1029, 68, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 4, 5, 6, 0, 8, 0, 0, 804, 9, 10, 0, 0, 0, 11, 804, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 1128, 0, 804, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 816, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 1229, 816, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 804, 804, 804, 0, 804, 226, 0, 0, 804, 804, 0, 0, 0, 804, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 0, 0, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 804, 0, 0, 0, 0, 0, 0, 804, 0, 0, 804, 804, 804, 804, 804, 804, 804, 804, 804, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 804, 0, 804, 804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 804, 804, 0, 0, 0, 0, 0, 0, 804, 0, 0, 804, 804, 804, 804, 0, 68, 0, 0, 804, 804, 804, 804, 804, 804, 804, 0, 804, 804, 0, 0, 0, 0, 0, 226, 816, 816, 816, 0, 816, 0, 0, 0, 816, 816, 0, 0, 0, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 0, 0, 0, 0, 0, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 0, 0, 0, 0, 0, 816, 0, 68, 816, 816, 816, 816, 0, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 67, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 68, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 804, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 210, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 804, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 4, 5, 6, 0, 8, 275, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 15, 16, 17, 18, 0, 0, 0, 0, 0, 19, 20, 21, 206, 207, 208, 209, 0, 0, 26, 0, 0, 0, 0, 0, 0, 28, 0, 0, 211, 212, 213, 214, 35, 215, 216, 217, 218, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 47, 0, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 0, 0, 0, 220, 0, 0, 221, 54, 55, 56, 0, 275, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 816, 804, 804, 804, 0, 804, 0, 0, 0, 804, 804, 0, 0, 0, 804, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 0, 0, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 804, 0, 0, 0, 0, 0, 0, 804, 0, 0, 804, 804, 804, 804, 804, 804, 804, 804, 804, 0, 804, 804, 804, 804, 804, 804, 804, 0, 0, 804, 0, 804, 804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 804, 804, 0, 0, 0, 0, 0, 0, 804, 0, 816, 804, 804, 804, 804, 0, 0, 0, 0, 804, 804, 804, 804, 804, 804, 804, 0, 804, 804, 0, 275, 275, 275, 0, 275, 0, 0, 0, 275, 275, 0, 0, 0, 275, 0, 275, 275, 275, 275, 275, 275, 275, 0, 0, 0, 0, 0, 275, 275, 275, 275, 275, 275, 275, 0, 0, 275, 0, 0, 0, 0, 0, 0, 275, 0, 0, 275, 275, 275, 275, 275, 275, 275, 275, 275, 0, 275, 275, 275, 275, 275, 275, 275, 0, 0, 275, 0, 275, 275, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 275, 275, 0, 0, 0, 0, 0, 0, 275, 0, 0, 275, 275, 275, 275, 953, 0, 0, 0, 275, 275, 275, 275, 275, 275, 275, 0, 275, 275, 816, 816, 816, 0, 816, 0, 0, 0, 816, 816, 0, 0, 0, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 0, 0, 0, 0, 0, 816, 0, 0, 816, 816, 816, 816, 816, 816, 816, 816, 816, 0, 816, 816, 816, 816, 816, 816, 816, 0, 0, 816, 0, 816, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 816, 0, 0, 0, 0, 0, 0, 816, 0, 0, 816, 816, 816, 816, 0, 0, 0, 0, 816, 816, 816, 816, 816, 816, 816, 197, 816, 816, 0, 196, 191, 0, 0, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 935, 936, 937, 938, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 939, 940, 941, 942, 189, 0, 198, 943, 0, 944, 40, 41, 42, 43, 44, 0, 197, 0, 0, 303, 196, 191, 0, 563, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 945, 946, 0, 0, 0, 0, 0, 188, 947, 187, 0, 948, 0, 949, 950, 0, 951, 567, 0, 58, 59, 952, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 0, 0, 0, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 0, 0, 0, 0, 0, 160, 161, 162, 163, 164, 165, 166, 167, 168, 251, 0, 169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185, 186, 0, 0, 59, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 0, 0, 953, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 0, 0, 0, 0, 0, 160, 161, 162, 163, 164, 165, 166, 167, 168, 0, 0, 169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 185, 186, 196, 191, 59, 438, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 198, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 0, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 935, 936, 937, 938, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 939, 940, 941, 942, 0, 0, 0, 943, 0, 0, 40, 41, 42, 43, 44, 0, 0, 0, 0, 303, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 945, 946, 0, 0, 0, 0, 0, 0, 947, 0, 0, 948, 0, 949, 950, 0, 189, 0, 198, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 0, 0, 0, 150, 151, 152, 429, 430, 431, 432, 157, 158, 159, 0, 0, 0, 0, 0, 160, 161, 162, 163, 433, 434, 435, 436, 168, 415, 416, 437, 418, 0, 0, 305, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185, 186, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 0, 0, 0, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 0, 0, 0, 0, 0, 160, 161, 162, 163, 164, 165, 166, 167, 168, 313, 314, 169, 315, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 185, 186, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 189, 11, 198, 12, 13, 14, 258, 259, 17, 18, 0, 0, 665, 0, 0, 19, 260, 261, 290, 291, 292, 293, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 295, 296, 297, 298, 35, 299, 300, 301, 302, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 197, 65, 66, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 190, 0, 199, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 0, 0, 0, 0, 0, 160, 161, 162, 163, 164, 165, 166, 167, 168, 0, 0, 169, 189, 0, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 4, 5, 6, 0, 8, 0, 185, 186, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 290, 291, 292, 293, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 295, 296, 297, 298, 35, 299, 300, 301, 302, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 637, 638, 0, 0, 639, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 190, 0, 199, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 185, 186, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 198, 0, 0, 0, 0, 0, 197, 190, 0, 199, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 646, 647, 0, 0, 648, 0, 0, 0, 0, 188, 0, 187, 0, 189, 0, 198, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 198, 0, 0, 702, 638, 0, 0, 703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 705, 647, 0, 0, 706, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 737, 638, 0, 0, 738, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 740, 647, 0, 0, 741, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 377, 372, 0, 185, 186, 375, 373, 0, 374, 0, 376, 0, 0, 0, 843, 638, 0, 0, 844, 0, 0, 0, 0, 369, 0, 368, 367, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 371, 0, 0, 0, 197, 0, 185, 186, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 370, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 0, 0, 0, 364, 365, 189, 0, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 658, 647, 0, 0, 659, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 198, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 858, 638, 0, 0, 859, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 861, 647, 0, 0, 862, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 1122, 638, 0, 0, 1123, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 1125, 647, 0, 0, 1126, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 1297, 638, 0, 0, 1298, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 804, 523, 0, 197, 0, 185, 186, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 245, 0, 194, 192, 0, 193, 0, 195, 0, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 196, 191, 0, 0, 0, 194, 192, 0, 193, 189, 195, 198, 0, 0, 0, 0, 0, 0, 190, 0, 199, 0, 0, 188, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 0, 0, 189, 0, 198, 0, 0, 0, 0, 0, 0, 190, 369, 199, 368, 367, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 377, 372, 0, 0, 0, 375, 373, 0, 374, 0, 376, 189, 0, 198, 0, 0, 371, 0, 0, 0, 0, 0, 0, 369, 0, 368, 367, 0, 0, 0, 0, 0, 0, 523, 523, 523, 523, 0, 0, 0, 0, 0, 0, 0, 0, 0, 370, 0, 0, 523, 523, 523, 523, 0, 0, 0, 523, 371, 523, 523, 523, 523, 523, 523, 0, 0, 0, 0, 523, 0, 0, 0, 523, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 523, 523, 370, 0, 0, 0, 0, 0, 523, 0, 0, 523, 0, 523, 523, 0, 523, 523, 0, 523, 523, 523, 523, 523, 523, 523, 0, 523, 523, 0, 1300, 647, 953, 0, 1301, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 1341, 638, 0, 0, 1342, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 658, 647, 0, 0, 659, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 0, 0, 170, 171, 172, 173, 174, 175, 176, 177, 178, 933, 0, 179, 180, 0, 0, 0, 0, 181, 182, 183, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185, 186, 0, 0, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 998, 0, 0, 0, 364, 365, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 0, 0, 0, 364, 365, 0, 0, 935, 936, 937, 938, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 939, 940, 941, 942, 0, 0, 0, 943, 0, 0, 40, 41, 42, 43, 44, 0, 0, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 945, 946, 0, 0, 0, 0, 0, 0, 947, 0, 0, 948, 0, 949, 950, 0, 951, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 290, 291, 292, 293, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 295, 296, 297, 298, 35, 299, 300, 301, 302, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 0, 0, 402, 54, 55, 56, 0, 403, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 407, 408, 409, 410, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 411, 412, 413, 414, 35, 415, 416, 417, 418, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 419, 0, 0, 0, 420, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 446, 447, 448, 449, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 450, 451, 452, 453, 35, 454, 455, 456, 457, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 458, 0, 0, 53, 54, 55, 56, 0, 57, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 407, 408, 409, 410, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 411, 412, 413, 414, 35, 415, 416, 417, 418, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 290, 291, 292, 293, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 295, 296, 297, 298, 35, 299, 300, 301, 302, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 0, 0, 402, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 1158, 1159, 1160, 1161, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 1162, 1163, 1164, 1165, 35, 1166, 1167, 1168, 1169, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1170, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66, 4, 5, 6, 0, 8, 0, 0, 0, 9, 10, 0, 0, 0, 11, 0, 12, 13, 14, 258, 259, 17, 18, 0, 0, 0, 0, 0, 19, 260, 261, 407, 408, 409, 410, 0, 0, 210, 0, 0, 0, 0, 0, 0, 294, 0, 0, 411, 412, 413, 1275, 35, 415, 416, 1276, 418, 0, 40, 41, 42, 43, 44, 45, 46, 0, 0, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1277, 0, 0, 221, 54, 55, 56, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 0, 65, 66};
    }

    /*
     * Opcode count of 31312 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyCheck1() {
        return new short[]{2, 60, 59, 15, 16, 87, 2, 3, 95, 121, 96, 109, 67, 336, 123, 124, 102, 330, 587, 7, 763, 330, 335, 2, 3, 335, 335, 420, 467, 767, 27, 870, 237, 57, 485, 7, 15, 16, 388, 27, 284, 123, 245, 866, 288, 3, 10, 320, 321, 15, 16, 32, 38, 55, 56, 27, 21, 10, 54, 57, 15, 16, 119, 657, 10, 10, 565, 661, 763, 793, 765, 59, 903, 765, 53, 54, 10, 528, 57, 10, 47, 1091, 84, 85, 32, 10, 118, 123, 67, 55, 56, 123, 124, 792, 793, 41, 41, 123, 44, 44, 55, 53, 114, 426, 481, 663, 59, 41, 485, 10, 44, 109, 44, 59, 59, 61, 41, 115, 116, 44, 272, 541, 283, 10, 122, 59, 0, 10, 905, 479, 109, 119, 97, 10, 59, 114, 115, 116, 269, 118, 271, 21, 40, 122, 123, 124, 232, 10, 114, 1264, 10, 949, 46, 10, 44, 46, 10, 44, 59, 114, 60, 44, 62, 40, 10, 40, 225, 44, 44, 46, 945, 946, 59, 26, 59, 28, 59, 263, 41, 124, 0, 46, 59, 38, 46, 61, 123, 10, 87, 539, 124, 1106, 274, 91, 288, 283, 59, 91, 657, 59, 10, 37, 661, 662, 1233, 59, 42, 305, 40, 10, 371, 47, 306, 59, 91, 10, 248, 97, 250, 123, 1335, 10, 360, 309, 10, 227, 228, 785, 10, 91, 242, 41, 244, 245, 343, 344, 345, 346, 10, 124, 41, 124, 221, 245, 280, 665, 41, 124, 274, 59, 402, 125, 254, 1263, 10, 248, 755, 756, 254, 41, 61, 124, 310, 242, 59, 244, 245, 10, 719, 248, 93, 250, 44, 59, 270, 254, 242, 256, 244, 61, 553, 674, 555, 371, 46, 10, 279, 242, 281, 244, 245, 270, 497, 272, 10, 1210, 1325, 10, 10, 10, 1098, 1099, 85, 59, 93, 125, 288, 305, 32, 1052, 46, 343, 344, 345, 346, 271, 348, 349, 1093, 1094, 272, 1152, 37, 279, 306, 675, 305, 42, 43, 91, 45, 44, 47, 44, 59, 444, 303, 283, 283, 320, 717, 691, 719, 59, 85, 341, 915, 59, 59, 283, 93, 347, 331, 1048, 677, 91, 1048, 336, 283, 32, 291, 292, 341, 264, 343, 344, 345, 346, 347, 348, 349, 357, 320, 459, 1151, 274, 388, 2, 3, 403, 267, 261, 464, 341, 264, 349, 388, 419, 369, 370, 15, 16, 1231, 395, 32, 989, 990, 399, 400, 401, 994, 995, 390, 279, 903, 403, 905, 267, 1231, 388, 398, 1106, 444, 267, 1138, 368, 306, 349, 53, 839, 283, 369, 370, 402, 403, 371, 371, 804, 53, 54, 743, 331, 332, 743, 743, 281, 32, 371, 464, 1138, 419, 294, 67, 541, 227, 228, 371, 426, 346, 46, 402, 345, 346, 37, 763, 346, 765, 312, 42, 43, 40, 45, 349, 47, 443, 444, 445, 479, 345, 346, 44, 326, 46, 283, 41, 748, 41, 479, 279, 752, 345, 346, 484, 345, 346, 487, 488, 228, 283, 114, 326, 735, 480, 118, 91, 349, 489, 279, 123, 124, 479, 356, 357, 496, 1343, 710, 499, 500, 371, 506, 390, 267, 514, 595, 717, 481, 0, 91, 506, 842, 10, 1115, 282, 1266, 517, 513, 10, 539, 41, 522, 989, 990, 1270, 10, 506, 994, 995, 539, 10, 387, 10, 520, 390, 541, 320, 321, 59, 61, 264, 348, 398, 41, 540, 269, 947, 267, 267, 124, 524, 124, 539, 371, 541, 279, 41, 10, 307, 665, 348, 1264, 40, 1266, 44, 767, 887, 59, 371, 887, 887, 572, 0, 693, 594, 345, 346, 597, 221, 1038, 1331, 40, 10, 593, 1031, 369, 370, 40, 221, 61, 792, 793, 480, 46, 657, 93, 10, 687, 661, 662, 663, 345, 346, 326, 320, 10, 59, 594, 93, 242, 597, 244, 245, 256, 1061, 248, 46, 250, 269, 44, 10, 254, 478, 256, 480, 513, 44, 41, 279, 272, 736, 59, 1335, 125, 1211, 10, 41, 270, 91, 272, 650, 1218, 682, 1001, 1151, 1152, 46, 61, 1115, 365, 660, 10, 540, 1038, 10, 675, 61, 513, 10, 665, 1127, 91, 40, 664, 123, 675, 41, 880, 641, 59, 657, 691, 310, 46, 661, 662, 663, 650, 665, 1010, 676, 691, 41, 723, 540, 41, 61, 660, 675, 1136, 677, 91, 697, 680, 1095, 682, 692, 279, 331, 662, 663, 697, 61, 336, 691, 61, 10, 59, 341, 696, 343, 344, 345, 346, 347, 348, 349, 697, 91, 729, 46, 271, 816, 10, 841, 15, 16, 822, 93, 279, 736, 1048, 263, 839, 326, 125, 723, 41, 269, 1316, 345, 346, 349, 717, 44, 10, 10, 348, 10, 736, 840, 343, 344, 641, 41, 388, 10, 61, 759, 402, 125, 622, 650, 345, 346, 91, 1251, 44, 10, 402, 10, 1256, 660, 783, 61, 785, 1107, 40, 10, 41, 1227, 44, 10, 46, 645, 10, 419, 852, 676, 1106, 800, 801, 46, 426, 59, 59, 10, 807, 808, 61, 443, 841, 445, 320, 692, 59, 46, 10, 348, 41, 443, 444, 445, 10, 267, 61, 1147, 59, 1303, 59, 676, 280, 785, 10, 114, 306, 10, 41, 91, 310, 804, 59, 40, 839, 59, 326, 692, 91, 41, 849, 728, 729, 326, 704, 41, 10, 479, 61, 365, 41, 851, 91, 839, 10, 841, 842, 852, 41, 348, 124, 870, 93, 59, 873, 874, 575, 876, 877, 125, 579, 291, 292, 59, 10, 279, 59, 863, 93, 739, 1081, 881, 882, 124, 123, 310, 952, 306, 520, 1246, 46, 310, 44, 345, 346, 59, 61, 1098, 1099, 1100, 10, 901, 10, 59, 1020, 279, 61, 539, 125, 10, 10, 354, 1081, 792, 793, 323, 345, 346, 10, 928, 44, 279, 1011, 59, 279, 10, 704, 989, 990, 1098, 1099, 41, 994, 995, 44, 91, 44, 1138, 124, 10, 926, 41, 125, 44, 10, 60, 345, 346, 1264, 41, 1266, 59, 44, 242, 46, 244, 41, 310, 59, 59, 61, 739, 594, 10, 10, 597, 279, 10, 56, 61, 41, 61, 1088, 345, 346, 41, 279, 803, 987, 988, 59, 1020, 1001, 992, 40, 811, 846, 61, 44, 41, 46, 125, 1001, 279, 1003, 41, 999, 44, 41, 91, 860, 264, 320, 989, 990, 1008, 269, 1002, 994, 995, 44, 320, 59, 999, 267, 1001, 124, 279, 279, 1335, 345, 346, 1008, 124, 1010, 657, 1035, 10, 267, 661, 662, 663, 44, 1019, 1020, 91, 44, 264, 680, 263, 264, 280, 269, 675, 271, 677, 44, 365, 680, 1088, 682, 369, 370, 1115, 696, 1060, 365, 125, 41, 691, 369, 370, 2, 3, 696, 1127, 279, 123, 846, 1270, 949, 44, 1058, 320, 1060, 15, 16, 124, 1171, 262, 263, 264, 860, 345, 346, 268, 269, 44, 271, 949, 950, 723, 345, 346, 44, 312, 279, 1097, 262, 263, 264, 320, 1088, 306, 983, 269, 345, 346, 44, 326, 264, 267, 40, 53, 54, 1002, 44, 1183, 46, 306, 320, 1107, 369, 370, 1110, 372, 10, 67, 264, 1115, 262, 219, 268, 269, 222, 223, 224, 10, 125, 356, 348, 1127, 767, 360, 348, 1000, 365, 1002, 1157, 774, 369, 370, 44, 372, 294, 295, 1142, 41, 337, 338, 44, 1147, 1148, 91, 1150, 365, 348, 1283, 1284, 369, 370, 949, 372, 46, 114, 1175, 348, 61, 118, 268, 269, 1041, 44, 123, 124, 368, 59, 279, 1174, 345, 346, 267, 1071, 320, 10, 123, 1196, 1197, 1198, 908, 909, 910, 10, 912, 10, 348, 2, 3, 917, 841, 842, 1216, 1091, 1073, 1074, 279, 10, 10, 91, 1098, 1099, 863, 1231, 279, 280, 41, 44, 1246, 46, 271, 1216, 863, 44, 41, 46, 41, 1096, 1246, 365, 1248, 1226, 348, 369, 370, 1283, 1284, 1106, 41, 41, 348, 263, 264, 1247, 345, 346, 308, 269, 53, 54, 1138, 1246, 57, 1075, 312, 1124, 318, 319, 765, 306, 307, 348, 769, 1281, 91, 1279, 1091, 44, 326, 46, 91, 32, 221, 1098, 1099, 926, 399, 400, 401, 1101, 345, 346, 10, 32, 1279, 926, 1073, 1074, 1283, 1284, 10, 44, 44, 242, 61, 244, 245, 298, 356, 248, 298, 250, 360, 10, 109, 254, 348, 256, 58, 1096, 115, 116, 40, 41, 91, 1184, 44, 122, 46, 93, 40, 270, 298, 272, 44, 1343, 46, 1322, 125, 61, 1199, 1200, 1201, 61, 41, 44, 298, 1124, 269, 59, 348, 1210, 279, 280, 44, 44, 123, 44, 989, 990, 44, 1247, 59, 994, 995, 44, 320, 44, 999, 306, 1001, 484, 349, 91, 487, 488, 306, 1008, 1019, 1010, 320, 91, 306, 124, 308, 309, 310, 311, 1019, 1020, 477, 44, 331, 1247, 481, 267, 596, 336, 485, 124, 44, 514, 341, 44, 343, 344, 345, 346, 347, 348, 349, 365, 44, 123, 124, 369, 370, 1058, 345, 346, 349, 320, 1199, 1200, 1201, 365, 221, 1058, 125, 369, 370, 1290, 632, 125, 41, 306, 636, 524, 59, 1251, 1299, 528, 44, 263, 1256, 1153, 1154, 1155, 1156, 388, 306, 1263, 308, 309, 310, 311, 44, 1088, 310, 254, 41, 256, 279, 402, 44, 44, 365, 124, 279, 1110, 369, 370, 44, 345, 346, 270, 1107, 272, 678, 1110, 419, 44, 1106, 44, 1115, 44, 686, 426, 688, 125, 368, 1303, 308, 309, 350, 311, 1127, 584, 44, 355, 124, 1142, 318, 319, 443, 444, 445, 1148, 10, 1150, 305, 1142, 279, 280, 310, 44, 1147, 1148, 1330, 1150, 44, 44, 1299, 46, 313, 314, 315, 316, 345, 346, 44, 44, 44, 1174, 345, 346, 331, 10, 40, 41, 479, 336, 44, 1174, 46, 44, 341, 2, 3, 93, 125, 1048, 347, 1050, 271, 41, 657, 1054, 93, 61, 661, 279, 40, 125, 58, 262, 263, 264, 91, 271, 280, 268, 269, 46, 271, 662, 663, 93, 345, 346, 125, 520, 279, 10, 93, 1226, 59, 70, 1296, 91, 40, 264, 555, 852, 44, 1226, 46, 116, 53, 54, 539, 516, 57, 254, 44, 1281, 46, 402, 403, 1106, 711, 698, 713, 40, 41, 1246, 520, 44, 91, 46, 707, 123, 294, 295, 296, 297, 298, 345, 346, 730, 717, 426, 719, 1248, 61, 345, 346, 660, 1106, 1157, 1264, 91, 1266, 119, 1266, 763, 1270, 847, 443, 1273, 445, 91, 1283, 1284, 109, 594, 903, 988, 597, 755, 115, 116, 767, 1270, 91, 865, 1325, 122, 868, 652, 385, 368, 1343, 123, 44, 306, 46, 308, 309, 310, 311, 1322, 823, 122, 10, 772, 1092, 800, 801, 1090, 1100, 1322, 98, 783, 807, 808, 123, 1184, 785, -1, 306, 1100, 308, 309, 10, 311, 1217, 1331, -1, 1333, 0, 1335, 38, 1337, -1, -1, 42, 804, 657, 350, 10, 91, 661, 662, 663, 520, -1, -1, -1, 306, 1354, 308, 309, 310, 311, -1, 675, -1, 677, 826, 46, 680, 1239, 682, 350, -1, 541, -1, -1, -1, -1, 41, 691, 59, 44, -1, 279, 696, -1, -1, 873, 874, -1, 876, 877, -1, 221, 1264, -1, 59, -1, -1, -1, -1, -1, -1, 1273, 279, 280, -1, -1, -1, 869, -1, 723, 91, -1, -1, -1, -1, 41, -1, -1, -1, 267, -1, -1, 10, 44, 254, 46, 256, -1, 93, -1, 792, 793, -1, -1, -1, -1, -1, 1012, -1, -1, 270, 1016, 272, -1, 10, -1, -1, 345, 346, 1024, -1, -1, 1027, 41, 279, 280, 44, 1032, 46, -1, 125, 1333, -1, 1335, 279, 1337, 37, 38, 345, 346, 91, 42, 43, 61, 45, 305, 47, 279, 280, -1, 46, -1, 1354, -1, -1, -1, 44, 657, 46, -1, -1, 661, 662, 59, -1, 665, -1, 345, 346, 125, -1, 331, -1, 91, 992, -1, 336, 677, -1, -1, 680, 341, -1, 989, 990, 1003, -1, 347, 994, 995, 345, 346, -1, 94, -1, 91, 696, 841, 842, -1, 345, 346, -1, 91, 279, 123, -1, -1, -1, -1, -1, 10, -1, 345, 346, 1007, -1, 1035, -1, 863, -1, -1, -1, 124, -1, -1, 1131, 1033, 1034, -1, 1036, 1037, -1, 792, 793, -1, 736, 1029, -1, -1, -1, -1, 402, 403, -1, 745, 1038, 46, -1, -1, -1, -1, -1, 945, 946, -1, 267, 949, -1, -1, 59, -1, -1, -1, -1, -1, 426, 262, 263, 264, 345, 346, 267, 268, 269, 306, 271, 308, 309, 310, 311, 312, 926, 443, 279, 445, 281, 282, -1, -1, -1, 983, 91, -1, -1, 326, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 262, 263, 264, 1115, -1, -1, 268, 269, -1, 271, -1, -1, -1, 350, -1, -1, -1, 279, 355, 356, 357, -1, 279, 1234, -1, -1, -1, -1, 345, 346, 1128, -1, 1144, 839, -1, -1, 842, -1, -1, 989, 990, -1, 10, 1141, 994, 995, -1, -1, -1, 999, -1, 1001, -1, 354, 520, 279, 280, 863, 1008, -1, 1010, 2, 3, -1, -1, 267, -1, 368, -1, 1019, 1020, -1, 40, 1071, -1, 541, 44, 1075, 46, -1, 945, 946, -1, 10, 949, 279, -1, -1, 345, 346, -1, 59, -1, 1091, 1092, 1093, 1094, 2, 3, -1, 1098, 1099, -1, 1101, -1, -1, 368, -1, 1058, 10, -1, 38, 53, 54, -1, 42, 57, -1, 983, 326, 926, 345, 346, 91, -1, -1, -1, -1, -1, -1, -1, 1229, 59, -1, 61, -1, 343, 344, 1088, -1, 1138, -1, -1, 345, 346, 46, -1, -1, 53, 54, -1, 345, 346, -1, -1, 123, 124, 1107, 59, -1, 1110, -1, 267, -1, -1, 1115, -1, -1, 109, -1, -1, -1, -1, -1, 115, 116, -1, 1127, -1, -1, -1, 122, -1, 989, 990, -1, -1, -1, 994, 995, 91, 657, 1142, 999, -1, 661, 662, 1147, 1148, 665, 1150, 10, 1008, -1, 1010, -1, 1071, -1, -1, -1, 1075, 677, 10, 1019, 680, -1, -1, 122, -1, -1, -1, -1, -1, -1, 1174, -1, 1091, 1092, 1093, 1094, 696, 40, -1, 1098, 1099, -1, 1101, 46, -1, -1, 345, 346, 40, 41, -1, -1, 44, -1, 46, 10, 59, -1, 1058, 1251, 1060, -1, 37, 38, 1256, -1, -1, 42, 43, 61, 45, 1263, 47, -1, -1, -1, 736, -1, -1, 1138, -1, -1, 1226, -1, -1, 40, 221, -1, 91, 44, -1, 46, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 1246, -1, 59, -1, -1, 1107, -1, -1, 1110, 1303, 2, 3, -1, 1115, 792, 793, 280, 254, 123, 256, 221, -1, -1, -1, -1, 1127, -1, 792, 793, 123, -1, -1, -1, 270, 91, 272, 1330, 1283, 1284, -1, 1142, -1, -1, -1, -1, 1147, 1148, -1, 1150, -1, -1, -1, -1, 254, -1, 256, -1, -1, -1, -1, 10, 53, 54, -1, -1, -1, 123, 124, 305, 270, 267, 272, 1174, 44, -1, 46, 1322, 839, -1, -1, 842, 345, 346, 306, -1, 308, 309, 310, 311, 312, 1251, -1, -1, -1, 331, 1256, 46, -1, -1, 336, -1, 863, 1263, 326, 341, -1, -1, -1, -1, 59, 347, -1, -1, -1, 1216, -1, -1, 340, -1, -1, 91, -1, 10, -1, 1226, -1, -1, 350, -1, 44, 331, 46, 355, 356, 357, 336, -1, -1, -1, -1, 341, 91, 1303, -1, -1, -1, 347, -1, 345, 346, -1, -1, 40, 41, -1, -1, 44, -1, 46, -1, -1, -1, 267, -1, 926, 402, 403, 945, 946, 1330, -1, 949, -1, 61, -1, 280, 91, 1279, -1, -1, 945, 946, -1, -1, 949, 279, 280, -1, -1, 426, -1, -1, 44, -1, 46, -1, -1, -1, -1, -1, -1, 402, -1, 91, -1, 983, 443, -1, 445, 792, 793, 10, -1, -1, 10, -1, -1, -1, 983, -1, 1322, -1, -1, 280, -1, 426, -1, 989, 990, 221, -1, -1, 994, 995, 44, 123, 46, 999, -1, 91, 345, 346, 443, -1, 445, -1, 1008, 46, 1010, 326, 46, 345, 346, -1, -1, -1, -1, 1019, -1, -1, 59, -1, 254, 59, 256, -1, 343, 344, -1, 38, -1, -1, -1, 10, -1, -1, 10, -1, 270, -1, 272, 91, -1, 520, 792, 793, -1, -1, 345, 346, -1, -1, 91, 1071, -1, 91, 1058, 1075, 1060, -1, -1, 38, -1, 40, 541, 42, 1071, -1, 279, 46, 1075, -1, 46, 1091, 1092, 1093, 1094, 267, -1, 520, 1098, 1099, 59, 1101, 61, 59, 1091, 1092, 1093, 1094, -1, -1, -1, 1098, 1099, -1, 1101, -1, -1, 331, -1, -1, -1, -1, 336, 1107, -1, -1, 1110, 341, -1, -1, -1, 1115, -1, 347, -1, 91, -1, -1, 1138, -1, 945, 946, 279, 1127, 949, 10, -1, -1, -1, 10, -1, 1138, 345, 346, -1, 792, 793, -1, 1142, -1, -1, -1, -1, 1147, 1148, -1, 1150, -1, -1, 279, 280, -1, -1, 345, 346, 40, 41, -1, 983, 44, 41, 46, -1, 44, -1, 46, -1, -1, 402, -1, 1174, -1, 10, -1, -1, -1, 61, -1, 657, -1, 61, -1, 661, 662, -1, 279, 665, -1, 345, 346, -1, -1, 426, -1, -1, 945, 946, -1, 677, 949, 38, 680, 40, -1, 42, -1, 91, -1, 46, 443, 91, 445, 1216, -1, 657, 345, 346, 696, 661, 662, -1, 59, 1226, 61, -1, -1, 267, 279, 10, 267, -1, 1251, -1, 983, 677, -1, 1256, 680, 123, -1, -1, -1, -1, 1263, 1251, -1, 1071, -1, -1, 1256, 1075, 345, 346, 696, -1, -1, 1263, 736, -1, 41, -1, -1, 44, -1, 46, -1, 1091, 1092, 1093, 1094, -1, -1, -1, 1098, 1099, 1279, 1101, -1, -1, 61, -1, -1, -1, 1303, -1, -1, 520, -1, 945, 946, -1, 267, 949, 345, 346, 306, 1303, 308, 309, 310, 311, 312, -1, -1, 345, 346, -1, 345, 346, 91, 1330, -1, -1, 1138, -1, 326, -1, -1, 1322, -1, -1, 1071, -1, 1330, -1, 1075, 983, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, 350, -1, 1091, 1092, 1093, 1094, 356, 357, 326, 1098, 1099, -1, 1101, -1, -1, -1, -1, -1, -1, -1, -1, 839, 340, -1, 842, -1, -1, -1, 346, -1, 345, 346, 350, -1, -1, 10, -1, 355, 356, 357, -1, -1, 10, -1, -1, 863, -1, -1, -1, 1138, -1, -1, -1, -1, -1, 279, 280, -1, -1, 279, 842, -1, -1, -1, -1, -1, 41, -1, -1, 44, 38, 46, 40, -1, 42, 1071, -1, -1, 46, 1075, -1, 863, -1, -1, 657, -1, 61, 1251, 661, 662, -1, 59, 1256, 61, -1, 1091, 1092, 1093, 1094, 1263, -1, -1, 1098, 1099, 677, 1101, -1, 680, 926, -1, -1, -1, -1, -1, -1, -1, 91, 10, -1, -1, -1, 345, 346, 696, -1, 345, 346, -1, -1, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, 1303, -1, -1, 1138, -1, 926, -1, -1, -1, 41, 326, -1, 44, -1, 46, -1, 10, -1, 10, 279, -1, -1, -1, 1251, 340, 792, 793, 1330, 1256, 61, 346, -1, 989, 990, 350, 1263, -1, 994, 995, 355, 356, 357, 999, -1, -1, -1, 40, -1, 40, -1, -1, 1008, 46, 1010, 46, -1, -1, -1, -1, 91, -1, -1, 1019, -1, -1, 59, -1, 59, 989, 990, -1, -1, -1, 994, 995, 1303, 10, -1, 999, -1, -1, 792, 793, -1, -1, 345, 346, 1008, -1, 1010, -1, -1, -1, -1, -1, -1, -1, 91, 1019, 91, -1, 1058, 1330, 1060, -1, -1, -1, 41, 15, 16, 44, -1, 46, -1, -1, -1, 1251, -1, -1, -1, -1, 1256, -1, -1, -1, -1, -1, 61, 1263, 123, 842, 123, -1, -1, -1, -1, -1, 1058, -1, 1060, -1, 48, 49, 50, 51, -1, -1, 10, 55, 56, 1107, 863, -1, 1110, -1, -1, -1, 91, 1115, -1, 67, 68, -1, -1, -1, 279, -1, -1, 1303, 40, 1127, -1, -1, 44, -1, 46, -1, 40, 945, 946, -1, -1, 949, 46, -1, 1142, 1107, -1, -1, 1110, 1147, 1148, -1, 1150, 1115, 1330, 59, -1, -1, 306, -1, 308, 309, 310, 311, 312, 1127, 114, -1, -1, -1, -1, -1, -1, 926, -1, 983, 1174, -1, 326, 91, 1142, -1, -1, -1, -1, 1147, 1148, 91, 1150, 0, 345, 346, 340, 945, 946, -1, -1, 949, 346, 10, -1, -1, 350, -1, -1, -1, 279, 355, 356, 357, -1, 123, 1174, -1, -1, -1, -1, -1, 1216, 123, 10, -1, -1, -1, -1, -1, -1, -1, 1226, -1, 41, 983, 267, 44, 267, -1, 989, 990, -1, -1, -1, 994, 995, -1, -1, 280, 999, 280, 59, -1, 40, -1, -1, -1, -1, 1008, 46, 1010, -1, -1, -1, -1, -1, 1071, 1226, -1, 1019, 1075, -1, 59, -1, 219, 345, 346, 222, 223, 224, -1, 226, -1, -1, 1279, 93, 1091, 1092, 1093, 1094, -1, -1, -1, 1098, 1099, -1, 1101, 242, -1, 244, 245, -1, -1, -1, 91, -1, -1, 279, 1058, -1, -1, -1, -1, 345, 346, 345, 346, 125, -1, -1, -1, -1, 1071, -1, -1, -1, 1075, 1322, 0, -1, -1, -1, -1, 1138, -1, -1, 123, -1, 10, -1, -1, -1, 1091, 1092, 1093, 1094, -1, -1, -1, 1098, 1099, -1, 1101, -1, -1, -1, -1, 1107, -1, -1, 1110, -1, -1, 1322, -1, 1115, 267, -1, -1, 41, 279, 280, 44, 345, 346, -1, -1, 1127, -1, 280, -1, -1, -1, -1, -1, -1, -1, 59, -1, 1138, -1, -1, 1142, 0, -1, -1, -1, 1147, 1148, -1, 1150, -1, -1, 10, -1, -1, 351, 352, 353, 354, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, 365, -1, 367, -1, 1174, 370, 371, 372, 373, 374, 375, 376, 377, 378, 41, -1, 345, 346, -1, -1, -1, -1, -1, 388, 345, 346, 1251, -1, -1, 394, -1, 1256, 59, 125, 262, 263, 264, -1, 1263, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, 10, -1, 279, -1, 281, 282, 10, 1226, -1, -1, -1, 267, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 280, -1, -1, -1, -1, 1303, -1, 41, -1, 1251, 44, -1, 46, 41, 1256, -1, 44, -1, 46, -1, -1, 1263, -1, -1, -1, 125, -1, 61, -1, -1, -1, -1, 1330, 61, -1, 0, -1, -1, -1, 477, -1, 479, -1, 481, -1, 10, -1, 485, -1, -1, -1, -1, -1, 354, -1, 493, -1, 91, -1, -1, -1, 1303, -1, 91, -1, 345, 346, 368, -1, -1, 508, -1, -1, 511, -1, -1, 41, -1, -1, 1322, -1, 0, -1, -1, -1, -1, 524, -1, 1330, -1, 528, 10, -1, -1, 59, -1, -1, 262, 263, 264, -1, 539, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, 584, -1, -1, -1, -1, -1, -1, -1, -1, -1, 594, -1, -1, 597, 125, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 91, -1, 93, 94, -1, -1, -1, 279, -1, 281, -1, -1, 349, -1, -1, -1, -1, -1, -1, 0, -1, -1, 294, 295, 296, 297, 298, -1, -1, 10, -1, 368, 123, 124, 125, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 657, -1, -1, -1, 661, 662, 663, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 675, 47, 41, -1, -1, 44, -1, 46, 279, -1, -1, -1, 58, 59, 279, -1, 691, 63, -1, -1, -1, -1, 61, 698, 699, 700, -1, -1, -1, -1, -1, 368, 707, -1, -1, -1, 711, 1106, 713, 714, -1, -1, 717, -1, 719, -1, -1, 93, 94, -1, -1, -1, 91, -1, -1, 730, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, 10, 271, -1, -1, 41, -1, 345, 346, -1, 279, 124, 125, 345, 346, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 294, 295, 296, 297, 298, 772, -1, 41, -1, -1, 44, -1, 46, -1, 262, 263, 264, -1, 785, 267, 268, 269, -1, 271, -1, -1, -1, 61, -1, -1, -1, 279, 280, 281, 282, 283, -1, 804, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, 91, 0, 826, -1, -1, -1, -1, 125, -1, -1, -1, 10, -1, -1, -1, -1, -1, 368, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, 41, -1, 349, 869, 1264, 10, 1266, 354, -1, -1, 1270, -1, -1, 1273, -1, -1, -1, -1, 59, -1, -1, 368, -1, -1, 371, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 41, -1, -1, 44, -1, 46, 279, -1, 281, 282, 283, -1, -1, 279, -1, -1, 93, -1, 291, 292, 61, 294, 295, 296, 297, 298, -1, -1, -1, 931, 932, 933, 934, -1, -1, 1331, -1, 1333, 38, 1335, 40, 1337, 42, -1, -1, -1, -1, -1, 125, -1, 91, -1, -1, 326, 327, 328, 329, 330, 1354, -1, 333, 334, 335, 336, 337, 338, 262, 263, 264, -1, 343, 344, 268, 269, -1, 271, 349, -1, -1, 345, 346, 354, -1, 279, 986, -1, -1, 989, 990, 10, -1, -1, 994, 995, 1106, 368, 998, -1, 371, 1001, -1, -1, -1, -1, 0, 1007, -1, -1, 1209, -1, 279, -1, -1, 1214, 10, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, 46, -1, 1029, -1, -1, -1, 1033, 1034, -1, 1036, 1037, 1038, 33, -1, -1, 61, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, 91, -1, 368, -1, -1, -1, 345, 346, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 91, -1, 93, 94, -1, -1, -1, 279, -1, 281, 282, -1, -1, -1, 1310, 1311, 1312, 1313, 1115, 291, 292, 1317, 294, 295, 296, 297, 298, 0, -1, -1, 1127, 1128, 123, 124, 125, 126, -1, 10, -1, -1, -1, -1, 40, 279, 1141, -1, 44, 1144, 46, 1345, 1346, 1347, 1348, -1, -1, -1, -1, 1264, -1, 1266, 33, 1357, -1, -1, 37, 38, 1273, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, 354, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, 91, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 345, 346, 306, -1, 308, 309, 310, 311, 312, 91, -1, 93, 94, -1, -1, 1331, 123, 1333, -1, 1335, -1, 1337, 326, 1229, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 340, -1, 1354, -1, 1246, 123, 124, 125, 126, -1, 350, -1, -1, -1, -1, 355, 356, 357, 279, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 38, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 345, 346, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, -1, -1, 371, 279, 280, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 345, 346, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, 371, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 306, -1, 308, 309, 310, 311, 312, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, -1, -1, -1, -1, -1, -1, -1, -1, 287, 288, 289, 290, 0, 340, -1, -1, -1, -1, 123, 124, 125, 126, 10, 350, 303, 304, 305, -1, -1, 356, 357, -1, -1, -1, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, -1, -1, 371, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, 371, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 123, 124, 125, 126, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, -1, -1, 371, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, 371, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 123, 124, 125, 126, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, -1, -1, 371, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, 371, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 38, -1, 40, -1, 42, -1, -1, -1, 46, -1, -1, -1, -1, 38, 124, 125, -1, 42, -1, -1, -1, 59, -1, 61, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, -1, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, -1, -1, 371, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, 61, 62, 63, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, 306, -1, 308, 309, 310, 311, 312, 326, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, 326, 340, -1, -1, -1, -1, -1, 346, 10, -1, -1, 350, -1, -1, 340, -1, 355, 356, 357, -1, -1, -1, -1, -1, 350, -1, -1, 124, 125, 355, 356, 357, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 124, 125, -1, -1, 10, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, 41, -1, 354, 44, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, 59, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, 38, -1, -1, -1, 42, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, 125, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 354, 41, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, 59, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, 125, -1, 343, 344, 345, 346, -1, 348, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, 61, 62, 63, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, -1, 294, 295, 296, 297, 298, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, 368, 271, 306, -1, 308, 309, 310, 311, 312, 279, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, 326, -1, 294, 295, 296, 297, 298, -1, -1, 10, -1, -1, -1, -1, 340, -1, -1, -1, -1, -1, -1, -1, -1, -1, 350, 124, 125, -1, -1, 355, 356, 357, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 124, 125, -1, 10, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, 41, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 59, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 38, -1, -1, -1, 42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, 61, 62, 63, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, 294, 295, 296, 297, 298, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, 326, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 350, -1, -1, -1, -1, 355, 356, 357, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 124, 125, -1, 10, -1, -1, -1, -1, -1, 326, 327};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyCheck2() {
        return new short[]{328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, 41, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 59, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 354, -1, -1, 94, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 124, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, -1, 62, 63, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, 294, 295, 296, 297, 298, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, 326, -1, -1, -1, -1, 331, 332, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, 343, 344, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, 280, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 124, 125, -1, 10, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, 41, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 59, -1, 371, -1, -1, 279, 280, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, 61, 62, 63, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, 294, 295, 296, 297, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 124, 125, -1, 10, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, 41, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 59, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, -1, 62, 63, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, 0, -1, 294, 295, 296, 297, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 124, 125, -1, -1, 10, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, 41, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, 59, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, 125, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 354, 41, -1, -1, 44, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, 371, -1, 59, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, 125, -1, 343, 344, 345, 346, -1, -1, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, -1, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, -1, 62, 63, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 94, 0, -1, -1, 294, 295, 296, 297, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, -1, -1, -1, 93, 94, -1, 0, -1, 291, 292, -1, 294, 295, 296, 297, 298, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, 354, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, 94, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 124, 125, -1, -1, -1, 10, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, 41, -1, -1, 354, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, -1, 368, 59, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, 368, -1, -1, 371, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 125, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 59, -1, -1, -1, -1, 10, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, -1, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, -1, 62, 63, -1, -1, -1, 262, 263, 264, -1, 125, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, -1, -1, -1, -1, -1, 93, 94, 0, 291, 292, -1, 294, 295, 296, 297, 298, -1, 10, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, 124, 125, -1, -1, -1, 279, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, -1, 47, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, 354, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 94, -1, 0, -1, -1, -1, -1, -1, -1, -1, 349, -1, 10, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, 368, 124, 125, -1, -1, -1, -1, 279, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, -1, 47, -1, 294, 295, 296, 297, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, 94, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, 368, 124, 125, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, 41, -1, -1, 354, 0, 46, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, -1, 368, 59, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, 368, -1, -1, 371, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 125, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 59, -1, -1, -1, -1, 10, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, 37, 38, 93, 354, 41, 42, 43, 44, 45, -1, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, 58, 59, 60, -1, 62, 63, -1, -1, -1, 262, 263, 264, -1, 125, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, 93, 94, 0, 291, 292, -1, 294, 295, 296, 297, 298, -1, 10, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, 124, 125, -1, -1, -1, 279, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, -1, 47, -1, 294, 295, 296, 297, 298, -1, 345, 346, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 94, -1, 0, -1, -1, -1, -1, -1, -1, -1, 349, -1, 10, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, 124, 125, -1, -1, -1, -1, 279, -1, 281, 282, 38, -1, -1, 41, -1, 43, 44, 45, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 10, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, 94, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 38, -1, 40, -1, 42, -1, -1, -1, 46, -1, -1, -1, -1, -1, 368, 124, 125, -1, -1, -1, -1, 59, -1, 61, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 0, -1, -1, -1, 349, -1, -1, -1, -1, 354, 10, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, -1, -1, 371, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, 41, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, 0, 59, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, 93, 343, 344, 38, -1, -1, 41, 349, 43, 44, 45, -1, 354, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, 368, 62, 63, 371, -1, -1, 125, -1, -1, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, -1, -1, 93, 94, 0, -1, -1, -1, -1, -1, -1, -1, -1, 340, 10, -1, 37, 38, -1, 346, -1, 42, 43, 350, 45, -1, 47, -1, 355, 356, 357, -1, -1, 124, 125, -1, -1, -1, -1, 60, -1, 62, 38, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 94, -1, 0, -1, -1, 124, -1, -1, -1, -1, -1, -1, 10, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, 124, 125, 279, -1, 281, 282, -1, -1, -1, -1, 38, -1, -1, 41, 291, 292, 44, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, 94, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, 0, -1, -1, -1, 124, 125, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, 41, -1, 354, 44, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 58, 59, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 93, 335, 336, -1, -1, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, 125, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, -1, -1, 371, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 38, -1, -1, 41, 343, 344, 44, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, 93, 94, 0, -1, -1, 279, -1, 281, 282, 283, -1, -1, 10, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, 93, 94, 371, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, 94, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, -1, 368, -1, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, 93, 354, -1, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, 368, -1, -1, 371, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 125, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, 93, 354, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 368, -1, 10, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, 38, 44, 40, -1, 42, -1, -1, -1, 46, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, 59, -1, 61, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 125, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, 41, -1, 354, 44, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, 58, 59, 371, -1, -1, 63, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, -1, 368, -1, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, 306, -1, 308, 309, 310, 311, 312, 58, 59, -1, -1, -1, 63, -1, -1, -1, -1, -1, -1, -1, 326, -1, 333, 334, -1, -1, 337, 338, -1, -1, -1, -1, -1, -1, 340, -1, -1, -1, 349, -1, 346, -1, 93, 354, 350, -1, -1, -1, -1, 355, 356, 357, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 262, 263, 264, 125, -1, 267, 268, 269, 10, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, 0, -1, 63, -1, -1, -1, -1, -1, -1, -1, 10, -1, 333, 334, -1, -1, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, 93, 354, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, 93, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 0, -1, -1, -1, -1, -1, -1, 125, -1, -1, 10, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 333, 334, -1, -1, 337, 338, -1, 41, -1, 38, 44, 40, -1, 42, -1, -1, 349, 46, -1, -1, -1, 354, -1, -1, 58, 59, -1, -1, -1, 63, 59, -1, 61, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 93, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, 0, -1, 267, 268, 269, -1, 271, 333, 334, -1, 10, 337, 338, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, 349, -1, -1, 291, 292, 354, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 41, 368, -1, 44, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, -1, -1, -1, -1, 333, 334, -1, -1, 337, 338, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, 125, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, 306, -1, 308, 309, 310, 311, 312, 58, 59, -1, -1, -1, 63, -1, -1, -1, -1, -1, -1, -1, 326, -1, 333, 334, -1, -1, 337, 338, -1, -1, -1, -1, -1, -1, 340, -1, -1, -1, 349, -1, 346, -1, 93, 354, 350, -1, -1, -1, -1, 355, 356, 357, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, 41, 291, 292, 44, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, 333, 334, -1, -1, 337, 338, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, 41, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 368, -1, -1, 371, 10, 59, 125, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 0, 41, 291, 292, 44, 294, 295, 296, 297, 298, 10, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, -1, 41, -1, -1, 44, 334, 37, 38, 337, 338, -1, 42, 43, 93, 45, -1, 47, -1, 58, 59, 349, -1, -1, 63, -1, 354, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, 0, -1, -1, -1, -1, -1, -1, 94, -1, -1, 10, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 125, 279, -1, 281, 282, 283, -1, -1, 124, -1, -1, 10, 41, 291, 292, 44, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, -1, -1, -1, -1, 38, -1, 40, -1, 42, -1, -1, -1, 46, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 59, -1, 61, -1, 93, -1, 279, -1, 281, -1, -1, 349, -1, -1, -1, -1, 354, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, 125, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, 0, -1, 291, 292, -1, 294, 295, 296, 297, 298, 10, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, 368, 281, 282, 283, -1, -1, -1, -1, -1, 0, 41, 291, 292, 44, 294, 295, 296, 297, 298, 10, -1, -1, -1, -1, -1, -1, -1, 58, 59, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, 41, 371, -1, 44, -1, 326, 327, 328, 329, 330, 331, 332, 93, -1, 335, 336, -1, 58, 59, 349, -1, -1, 343, 344, 354, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, -1, -1, 371, -1, -1, 125, 279, -1, 281, 282, 283, -1, -1, 93, -1, -1, 0, -1, 291, 292, -1, 294, 295, 296, 297, 298, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, 0, -1, 306, -1, 308, 309, 310, 311, 312, -1, 10, -1, -1, 58, 59, 349, -1, -1, -1, -1, 354, -1, 326, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, 340, 371, -1, -1, -1, 41, 346, -1, 44, -1, 350, -1, 93, -1, 0, 355, 356, 357, -1, -1, -1, -1, 58, 59, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 41, -1, 93, 44, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, 59, 291, 292, -1, 294, 295, 296, 297, 298, -1, 0, -1, 262, 263, 264, -1, 125, 267, 268, 269, 10, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, 283, 93, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, 0, 44, -1, -1, -1, -1, 349, -1, -1, -1, 10, 354, -1, 125, -1, 58, 59, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, 349, -1, -1, -1, 93, 354, -1, -1, -1, 262, 263, 264, 58, 59, 267, 268, 269, -1, 271, 368, -1, -1, 371, 0, -1, -1, 279, -1, 281, 282, 283, -1, -1, 10, -1, -1, 125, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 93, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 41, -1, -1, 44, -1, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, 125, -1, 58, 59, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, 93, -1, 371, -1, -1, 279, -1, 281, 282, 283, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 349, -1, -1, -1, 0, 354, -1, 125, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, 41, -1, -1, -1, 279, 349, 281, 282, 283, -1, 354, -1, -1, -1, -1, -1, 291, 292, 59, 294, 295, 296, 297, -1, 368, -1, -1, 371, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, 0, -1, -1, 279, -1, 281, 282, 283, -1, -1, 10, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, 125, 41, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, 371, -1, -1, 262, 263, 264, -1, 59, 267, 268, 269, -1, 271, -1, -1, -1, -1, 0, -1, -1, 279, 349, 281, 282, 283, -1, 354, 10, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, -1, 368, 93, -1, 371, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 368, 93, 94, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, 0, 267, 268, 269, -1, 271, -1, -1, -1, -1, 10, 123, 124, 125, 126, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 33, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 91, -1, 93, 94, -1, -1, -1, 279, -1, 281, 282, 368, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 368, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, -1, 281, 282, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyCheck3() {
        return new short[]{-1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 123, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 0, 366, 367, 368, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 124, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1, -1, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 38, -1, 40, -1, 42, -1, -1, -1, 46, -1, -1, 123, -1, 125, 126, -1, -1, -1, -1, -1, -1, 59, -1, 61, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, -1, -1, 343, 344, 345, 346, 347, -1, 349, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 257, 258, 259, -1, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 339, 340, -1, 10, -1, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 368, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, 306, -1, 308, 309, 310, 311, 312, -1, -1, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, 326, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 340, -1, -1, -1, -1, -1, 346, -1, -1, 91, 350, 93, 94, 0, -1, 355, 356, 357, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, 93, 94, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, -1, 91, -1, 93, 94, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, -1, -1, -1, -1, 279, -1, 281, 282, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 354, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, 282, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, 37, 38, -1, 354, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 91, -1, -1, 94, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 0, -1, 94, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 124, 125, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, 91, -1, -1, 94, -1, -1, 279, 280, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 368, 279, 280, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, 368, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 91, -1, -1, 94, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 0, -1, 94, -1, -1, -1, -1, -1, -1, -1, 10, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, 60, -1, 62, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, 91, -1, -1, 94, -1, -1, 279, 124, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 368, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, 368, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, -1, -1, 0, -1, -1, -1, 343, 344, -1, -1, -1, -1, 10, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 91, -1, -1, 94, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 0, -1, 94, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, 91, -1, -1, 94, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 368, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, 368, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 91, -1, -1, 94, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 0, -1, 94, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, 91, -1, -1, 94, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 368, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, 368, -1, -1, 279, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 345, 346, -1, 348, 349, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 91, -1, -1, 94, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 0, -1, 94, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, 37, 38, -1, -1, 41, 42, 43, 44, 45, 46, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, 91, -1, -1, 94, -1, -1, 279, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 59, -1, -1, -1, 343, 344, 345, 346, -1, -1, 349, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 368, 279, 0, -1, -1, 93, -1, -1, -1, -1, -1, -1, 10, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 59, -1, 0, -1, 343, 344, 345, 346, -1, -1, 349, -1, 10, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, 368, -1, -1, 279, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, 41, 291, 292, 44, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, 0, 124, 125, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, 93, 343, 344, 345, 346, -1, -1, 349, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 368, 271, 59, 0, -1, 124, 125, -1, -1, 279, -1, 281, -1, 10, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, 0, -1, -1, 124, 125, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, 349, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, 93, -1, 368, 279, -1, 281, -1, -1, -1, 41, -1, -1, 44, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, 0, 59, -1, -1, -1, -1, 125, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, 93, -1, -1, 279, -1, 281, 41, -1, -1, 44, -1, -1, 349, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 59, -1, -1, 0, -1, -1, -1, 368, 125, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 93, -1, -1, -1, -1, -1, -1, 279, -1, 281, 41, -1, -1, 44, -1, 349, -1, 0, -1, 291, 292, -1, 294, 295, 296, 297, 298, 10, 59, -1, -1, -1, 125, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, 41, 271, 0, 44, 93, -1, -1, -1, -1, 279, -1, 281, 10, -1, -1, -1, -1, -1, 59, 349, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 125, -1, 368, -1, 0, -1, -1, 41, -1, -1, 44, -1, -1, -1, 10, -1, 93, 262, 263, 264, -1, -1, 267, 268, 269, 59, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, 349, -1, 41, 291, 292, 125, 294, 295, 296, 297, 298, 0, -1, -1, -1, -1, 93, -1, -1, 368, 59, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, 125, 279, -1, 281, 41, -1, 93, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 59, -1, -1, 0, -1, -1, -1, -1, -1, -1, 368, -1, -1, 10, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 93, -1, -1, -1, -1, -1, -1, 279, -1, 281, 41, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 59, -1, -1, -1, 125, -1, 368, -1, 0, -1, 262, 263, 264, -1, -1, 267, 268, 269, 10, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, 93, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 41, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 0, -1, -1, 125, 59, 368, -1, 279, -1, 281, 10, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 93, -1, 0, 41, -1, -1, -1, 279, -1, 281, -1, -1, 10, -1, -1, 368, -1, -1, -1, 291, 292, 59, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, 41, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, 93, 0, 279, 368, 281, -1, 59, -1, -1, -1, -1, 10, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, 93, 368, 41, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 0, -1, 59, -1, -1, -1, 279, -1, 281, -1, 10, -1, -1, -1, 125, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, 93, -1, 0, -1, -1, 41, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, 59, -1, 267, 268, 269, -1, 271, -1, -1, 125, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, 41, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 93, -1, 368, 0, 59, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, 125, -1, -1, 279, -1, 281, 93, -1, -1, -1, -1, -1, 41, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 0, -1, 262, 263, 264, -1, 59, 267, 268, 269, 10, 271, -1, 368, 125, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 0, 93, 41, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, 262, 263, 264, 59, -1, 267, 268, 269, -1, 271, -1, -1, 368, -1, -1, -1, 125, 279, -1, 281, -1, -1, -1, -1, 41, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 93, -1, 0, -1, -1, 59, -1, -1, -1, -1, -1, -1, 10, -1, -1, 368, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, 125, -1, -1, -1, -1, 279, -1, 281, -1, 0, -1, 41, -1, -1, -1, -1, -1, 291, 292, 10, 294, 295, 296, 297, 298, -1, 262, 263, 264, 59, -1, 267, 268, 269, -1, 271, -1, 368, -1, 125, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, 41, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 0, -1, -1, -1, -1, 59, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 368, 125, -1, -1, -1, -1, 0, 279, -1, 281, 41, -1, -1, -1, -1, -1, 10, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, 125, -1, -1, 262, 263, 264, -1, 41, 267, 268, 269, 0, 271, -1, -1, -1, -1, -1, -1, -1, 279, 10, 281, -1, -1, 59, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, 41, 0, 125, -1, 368, -1, -1, 279, -1, 281, -1, 10, -1, -1, -1, -1, -1, -1, 59, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, -1, -1, 41, -1, -1, 44, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, -1, 59, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, 125, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, 368, -1, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, 125, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, 368, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, 368, -1, 279, -1, 281, -1, -1, -1, -1, -1, -1, 94, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, 264, -1, -1, 267, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, -1, 281, -1, -1, -1, -1, 368, -1, -1, -1, -1, 291, 292, -1, 294, 295, 296, 297, 298, 10, -1, -1, -1, -1, 262, 263, 264, -1, -1, -1, 268, 269, -1, 271, -1, -1, -1, -1, -1, -1, -1, 279, 33, 368, -1, -1, -1, -1, -1, 40, -1, -1, -1, 291, 292, 46, 294, 295, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 349, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, 10, 123, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, 287, 288, 289, 290, -1, 40, -1, -1, -1, -1, -1, 46, -1, -1, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, 59, 60, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, 91, -1, -1, -1, 347, -1, -1, 350, -1, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, 123, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, 280, 10, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, 94, 366, 367, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, 10, -1, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, 33, 366, 367, -1, -1, -1, -1, 40, -1, -1, -1, -1, -1, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 287, 288, 289, 290, -1, -1, -1, -1, 10, 123, -1, -1, 126, -1, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, -1, -1, 313, 314, 315, 316, 317, 33, -1, -1, -1, 322, -1, -1, 40, -1, -1, -1, -1, -1, 46, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, 10, -1, 59, 60, -1, 347, -1, -1, 350, -1, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 37, 38, -1, -1, -1, 42, 43, 91, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, -1, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, 280, -1, -1, 124, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, 33, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, 126, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, 10, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, 33, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, 46, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 59, 60, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, 10, -1, -1, -1, 126, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, 33, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, 94, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, 345, 346, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, 10, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, 33, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, 59, 347, 61, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, 287, 288, 289, 290, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, -1, 312, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, 10, -1, -1, 326, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, 33, 347, -1, -1, 350, -1, 352, 353, -1, 355, 356, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, 63, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, 94, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, 124, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350};
    }

    /*
     * Opcode count of 31316 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final short[] yyCheck4() {
        return new short[]{351, 352, 353, 33, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, 59, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, 10, -1, -1, -1, 126, -1, -1, -1, 339, 340, 279, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, 33, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, 349, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, 125, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, 63, -1, -1, -1, -1, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, -1, -1, 269, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, 94, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 124, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, 10, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, 33, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 256, 257, 258, 259, 260, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, 10, 324, 325, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, 33, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, 59, -1, 298, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, 33, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 126, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 256, 257, 258, 259, 260, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, 256, 257, 258, 259, 260, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 33, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 256, 257, 258, 259, 260, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, 126, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 33, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, 257, 258, 259, 260, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, 257, 258, 259, 260, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, 299, 300, -1, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, 33, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, 257, 258, 259, 126, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, 33, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, 33, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, 126, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, 33, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, 356, 357, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, 126, -1, -1, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, 33, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 356, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, -1, 33, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, 356, 126, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 257, 258, 259, -1, 261, -1, -1, 33, 265, 266, -1, -1, -1, 270, 40, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, 126, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, 33, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, 126, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, 257, 258, 259, -1, 261, 33, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 126, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, 33, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 126, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 257, 258, 259, -1, 261, 33, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 126, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, 33, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, 126, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, 94, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, 324, 325, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, 33, 366, 367, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, 287, 288, 289, 290, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, 304, 305, 306, 124, -1, 126, 310, -1, 312, 313, 314, 315, 316, 317, -1, 33, -1, -1, 322, 37, 38, -1, 326, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, 60, 347, 62, -1, 350, -1, 352, 353, -1, 355, 356, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 355, 356, -1, -1, 359, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, 94, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, 355, 356, 37, 38, 359, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, 126, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, 287, 288, 289, 290, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, -1, -1, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, -1, 352, 353, -1, 124, -1, 126, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, -1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 355, 356, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 355, 356, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, 124, 270, 126, 272, 273, 274, 275, 276, 277, 278, -1, -1, 44, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, 33, 366, 367, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 94, -1, 96, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, -1, -1, -1, -1, -1, 299, 300, 301, 302, 303, 304, 305, 306, 307, -1, -1, 310, 124, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, 257, 258, 259, -1, 261, -1, 355, 356, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, 94, -1, 96, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 355, 356, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, 126, -1, -1, -1, -1, -1, 33, 94, -1, 96, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, 306, 307, -1, -1, 310, -1, -1, -1, -1, 60, -1, 62, -1, 124, -1, 126, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, 126, -1, -1, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, 355, 356, 42, 43, -1, 45, -1, 47, -1, -1, -1, 306, 307, -1, -1, 310, -1, -1, -1, -1, 60, -1, 62, 63, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, 94, -1, -1, -1, 33, -1, 355, 356, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, 124, -1, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, 126, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, 93, 94, -1, 33, -1, 355, 356, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, 40, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, 124, 47, 126, -1, -1, -1, -1, -1, -1, 94, -1, 96, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, 124, -1, 126, -1, -1, -1, -1, -1, -1, 94, 60, 96, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, 124, -1, 126, -1, -1, 94, -1, -1, -1, -1, -1, -1, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, 287, 288, 289, 290, -1, -1, -1, -1, -1, -1, -1, -1, -1, 124, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, 94, 312, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, -1, -1, -1, 326, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, 124, -1, -1, -1, -1, -1, 347, -1, -1, 350, -1, 352, 353, -1, 355, 356, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, -1, 306, 307, 94, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, -1, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, 306, 307, -1, -1, 310, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 330, 331, 332, 298, -1, 335, 336, -1, -1, -1, -1, 341, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 355, 356, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 298, -1, -1, -1, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, -1, -1, -1, -1, 343, 344, -1, -1, 287, 288, 289, 290, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, 304, 305, 306, -1, -1, -1, 310, -1, -1, 313, 314, 315, 316, 317, -1, -1, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 339, 340, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, -1, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 343, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, 355, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367, 257, 258, 259, -1, 261, -1, -1, -1, 265, 266, -1, -1, -1, 270, -1, 272, 273, 274, 275, 276, 277, 278, -1, -1, -1, -1, -1, 284, 285, 286, 287, 288, 289, 290, -1, -1, 293, -1, -1, -1, -1, -1, -1, 300, -1, -1, 303, 304, 305, 306, 307, 308, 309, 310, 311, -1, 313, 314, 315, 316, 317, 318, 319, -1, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 347, -1, -1, 350, 351, 352, 353, -1, -1, -1, -1, 358, 359, 360, 361, 362, 363, 364, -1, 366, 367};
    }
}

