/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.nio.ByteBuffer;
import java.util.Locale;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;
import org.jruby.util.TypeConverter;

public class Option
extends RubyObject {
    private ProtocolFamily family;
    private SocketLevel level;
    private SocketOption option;
    private ByteList data;

    public static void createOption(Ruby runtime2) {
        RubyClass addrinfo = runtime2.getClass("Socket").defineClassUnder("Option", runtime2.getObject(), Option::new);
        addrinfo.defineAnnotatedMethods(Option.class);
    }

    public Option(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public Option(Ruby runtime2, ProtocolFamily family2, SocketLevel level2, SocketOption option, ByteList data2) {
        this(runtime2, (RubyClass)runtime2.getClassFromPath("Socket::Option"), family2, level2, option, data2);
    }

    public Option(Ruby runtime2, RubyClass klass, ProtocolFamily family2, SocketLevel level2, SocketOption option, ByteList data2) {
        super(runtime2, klass);
        this.family = family2;
        this.level = level2;
        this.option = option;
        this.data = data2;
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.family = SocketUtils.protocolFamilyFromArg(args2[0]);
        this.level = SocketUtils.levelFromArg(args2[1]);
        this.option = SocketUtils.optionFromArg(args2[2]);
        this.data = args2[3].convertToString().getByteList();
        return this;
    }

    @JRubyMethod
    public IRubyObject family(ThreadContext context) {
        return context.runtime.newFixnum(this.family.longValue());
    }

    @JRubyMethod
    public IRubyObject level(ThreadContext context) {
        return context.runtime.newFixnum(this.level.longValue());
    }

    @JRubyMethod
    public IRubyObject optname(ThreadContext context) {
        return context.runtime.newFixnum(this.option.longValue());
    }

    @JRubyMethod
    public IRubyObject data(ThreadContext context) {
        return RubyString.newString(context.runtime, this.data).freeze(context);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("#<");
        buf.append(this.metaClass.getRealClass().getName()).append(": ").append(this.noPrefix(this.family));
        if (this.level == SocketLevel.SOL_SOCKET) {
            buf.append(" SOCKET ").append(this.noPrefix(this.option));
        } else if (this.family == ProtocolFamily.PF_UNIX) {
            buf.append(" level:").append(this.level.longValue()).append(' ').append(this.noPrefix(this.option));
        } else {
            buf.append(" level:").append(this.level.description()).append(' ').append(this.noPrefix(this.option));
        }
        buf.append(' ').append(this.optionValue()).append('>');
        return context.runtime.newString(buf.toString());
    }

    private String noPrefix(ProtocolFamily family2) {
        return family2.description().substring("PF_".length());
    }

    private String noPrefix(SocketOption option) {
        return option.description().substring("SO_".length());
    }

    private String optionValue() {
        switch (this.option) {
            case SO_DEBUG: 
            case SO_ACCEPTCONN: 
            case SO_BROADCAST: 
            case SO_REUSEADDR: 
            case SO_KEEPALIVE: 
            case SO_OOBINLINE: 
            case SO_SNDBUF: 
            case SO_RCVBUF: 
            case SO_DONTROUTE: 
            case SO_RCVLOWAT: 
            case SO_SNDLOWAT: {
                return String.valueOf(Option.unpackInt(this.data));
            }
            case SO_LINGER: {
                int[] linger2 = Option.unpackLinger(this.data);
                return (linger2[0] == 0 ? "off " : "on ") + linger2[1] + "sec";
            }
            case SO_RCVTIMEO: 
            case SO_SNDTIMEO: {
                return Sprintf.getNumberFormat(Locale.getDefault()).format((double)Option.unpackInt(this.data) / 1000.0);
            }
            case SO_ERROR: {
                return Errno.valueOf((long)Option.unpackInt(this.data)).description();
            }
            case SO_TYPE: {
                return Sock.valueOf((long)Option.unpackInt(this.data)).description();
            }
        }
        return "";
    }

    public static ByteList packInt(int i2) {
        ByteList result2 = new ByteList(4);
        Pack.packInt_i(result2, i2);
        return result2;
    }

    public static ByteList packLinger(int vonoff, int vsecs) {
        ByteList result2 = new ByteList(8);
        Pack.packInt_i(result2, vonoff);
        Pack.packInt_i(result2, vsecs);
        return result2;
    }

    public static int unpackInt(ByteList data2) {
        return Pack.unpackInt_i(ByteBuffer.wrap(data2.unsafeBytes(), data2.begin(), data2.realSize()));
    }

    public static int[] unpackLinger(ByteList data2) {
        ByteList result2 = new ByteList(8);
        ByteBuffer buf = ByteBuffer.wrap(data2.unsafeBytes(), data2.begin(), data2.realSize());
        int vonoff = Pack.unpackInt_i(buf);
        int vsecs = Pack.unpackInt_i(buf);
        return new int[]{vonoff, vsecs};
    }

    @JRubyMethod(name={"int"}, required=4, meta=true)
    public static IRubyObject rb_int(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        ProtocolFamily family2 = SocketUtils.protocolFamilyFromArg(args2[0]);
        SocketLevel level2 = SocketUtils.levelFromArg(args2[1]);
        SocketOption option = SocketUtils.optionFromArg(args2[2]);
        ByteList data2 = Option.packInt(RubyNumeric.fix2int(args2[3]));
        return new Option(context.getRuntime(), family2, level2, option, data2);
    }

    @JRubyMethod(name={"int"})
    public IRubyObject asInt(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Option.validateDataSize(runtime2, this.data, 4);
        return runtime2.newFixnum(Option.unpackInt(this.data));
    }

    @JRubyMethod(required=4, meta=true)
    public static IRubyObject bool(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        ProtocolFamily family2 = SocketUtils.protocolFamilyFromArg(args2[0]);
        SocketLevel level2 = SocketUtils.levelFromArg(args2[1]);
        SocketOption option = SocketUtils.optionFromArg(args2[2]);
        ByteList data2 = Option.packInt(args2[3].isTrue() ? 1 : 0);
        return new Option(context.getRuntime(), family2, level2, option, data2);
    }

    @JRubyMethod
    public IRubyObject bool(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Option.validateDataSize(runtime2, this.data, 4);
        return runtime2.newBoolean(Option.unpackInt(this.data) != 0);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject linger(ThreadContext context, IRubyObject self2, IRubyObject vonoff, IRubyObject vsecs) {
        ProtocolFamily family2 = ProtocolFamily.PF_UNSPEC;
        SocketLevel level2 = SocketLevel.SOL_SOCKET;
        SocketOption option = SocketOption.SO_LINGER;
        int coercedVonoff = !TypeConverter.checkToInteger(context, vonoff).isNil() ? vonoff.convertToInteger().getIntValue() : (vonoff.isTrue() ? 1 : 0);
        ByteList data2 = Option.packLinger(coercedVonoff, vsecs.convertToInteger().getIntValue());
        return new Option(context.getRuntime(), family2, level2, option, data2);
    }

    @JRubyMethod
    public IRubyObject linger(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Option.validateDataSize(runtime2, this.data, 8);
        int[] linger2 = Option.unpackLinger(this.data);
        return runtime2.newArray((IRubyObject)runtime2.newBoolean(linger2[0] != 0), (IRubyObject)runtime2.newFixnum(linger2[1]));
    }

    @JRubyMethod
    public IRubyObject unpack(ThreadContext context, IRubyObject arg0) {
        return Pack.unpack(context.runtime, this.data, arg0.convertToString().getByteList());
    }

    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newString(context.runtime, this.data);
    }

    private static void validateDataSize(Ruby runtime2, ByteList data2, int size2) {
        int realSize = data2.realSize();
        if (realSize != size2) {
            throw runtime2.newTypeError("size differ.  expected as sizeof(int)=" + size2 + " but " + realSize);
        }
    }
}

