/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Library;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JRubyFile;

@JRubyClass(name={"FFI::DynamicLibrary"}, parent="Object")
public class DynamicLibrary
extends RubyObject {
    @JRubyConstant
    public static final int RTLD_LAZY = 1;
    @JRubyConstant
    public static final int RTLD_NOW = 2;
    @JRubyConstant
    public static final int RTLD_LOCAL = 4;
    @JRubyConstant
    public static final int RTLD_GLOBAL = 8;
    private final Library library;
    private final String name;
    private static HashMap<String, String> extractedLibraries = null;

    public static RubyClass createDynamicLibraryClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("DynamicLibrary", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass symClass = result2.defineClassUnder("Symbol", module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        symClass.defineAnnotatedMethods(Symbol.class);
        result2.defineAnnotatedMethods(DynamicLibrary.class);
        result2.defineAnnotatedConstants(DynamicLibrary.class);
        return result2;
    }

    private static final int getNativeLibraryFlags(IRubyObject rbFlags) {
        int f = 0;
        int flags2 = RubyNumeric.fix2int(rbFlags);
        f |= (flags2 & 1) != 0 ? 1 : 0;
        f |= (flags2 & 2) != 0 ? 2 : 0;
        f |= (flags2 & 4) != 0 ? 4 : 0;
        return f |= (flags2 & 8) != 0 ? 8 : 0;
    }

    public DynamicLibrary(Ruby runtime2, RubyClass klass, String name2, Library library2) {
        super(runtime2, klass);
        this.name = name2;
        this.library = library2;
    }

    final Library getNativeLibrary() {
        return this.library;
    }

    @JRubyMethod(name={"open"}, meta=true)
    public static final IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject libraryName, IRubyObject libraryFlags) {
        String loadName;
        String libName;
        String string2 = libName = libraryName.isNil() ? null : libraryName.toString();
        if (libName != null && libName.contains(":") && !new File(libName).isAbsolute()) {
            FileResource resource = JRubyFile.createResource(context, libName);
            if (JRubyFile.isResourceRegularFile(resource)) {
                loadName = resource.absolutePath();
            } else {
                try (InputStream internalStream = resource.openInputStream();){
                    loadName = DynamicLibrary.extractLibrary(resource.path(), internalStream);
                }
                catch (IOException e) {
                    loadName = resource.absolutePath();
                }
            }
        } else {
            loadName = libName;
        }
        try {
            Library library2 = Library.getCachedInstance((String)loadName, (int)DynamicLibrary.getNativeLibraryFlags(libraryFlags));
            if (library2 == null) {
                throw new UnsatisfiedLinkError(Library.getLastError());
            }
            return new DynamicLibrary(context.runtime, (RubyClass)recv2, libName, library2);
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.runtime.newLoadError(String.format("Could not open library '%s' : %s", libName != null ? libName : "current process", ex.getMessage()));
        }
    }

    private static synchronized String extractLibrary(String name2, InputStream resourceAsStream) throws IOException {
        if (resourceAsStream == null) {
            return name2;
        }
        if (extractedLibraries == null) {
            extractedLibraries = new HashMap();
        } else if (extractedLibraries.containsKey(name2)) {
            return extractedLibraries.get(name2);
        }
        String basename2 = new File(name2).getName();
        String[] names2 = basename2.split("\\.");
        Path tempfile2 = Files.createTempFile(JRubyClassLoader.getTempDir().toPath(), names2[0], "." + names2[names2.length - 1], new FileAttribute[0]);
        Files.copy(resourceAsStream, tempfile2, StandardCopyOption.REPLACE_EXISTING);
        File file2 = tempfile2.toFile();
        file2.setExecutable(true);
        extractedLibraries.put(name2, file2.getAbsolutePath());
        return file2.getAbsolutePath();
    }

    @JRubyMethod(name={"find_variable", "find_symbol"})
    public IRubyObject findVariable(ThreadContext context, IRubyObject symbolName) {
        String sym = symbolName.toString();
        long address2 = this.library.getSymbolAddress(sym);
        if (address2 == 0L) {
            return context.nil;
        }
        return new Symbol(context.runtime, this, sym, new DataSymbolMemoryIO(context.runtime, this, address2));
    }

    @JRubyMethod(name={"find_function"})
    public IRubyObject findFunction(ThreadContext context, IRubyObject symbolName) {
        String sym = symbolName.toString();
        long address2 = this.library.getSymbolAddress(sym);
        if (address2 == 0L) {
            return context.nil;
        }
        return new Symbol(context.runtime, this, sym, new TextSymbolMemoryIO(context.runtime, this, address2));
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return this.name != null ? RubyString.newString(context.runtime, this.name) : context.nil;
    }

    private static final class TextSymbolMemoryIO
    extends InvalidMemoryIO {
        private final DynamicLibrary library;

        public TextSymbolMemoryIO(Ruby runtime2, DynamicLibrary library2, long address2) {
            super(runtime2, true, address2, "Library text region is inaccessible");
            this.library = library2;
        }
    }

    private static final class DataSymbolMemoryIO
    extends NativeMemoryIO {
        private final DynamicLibrary library;

        public DataSymbolMemoryIO(Ruby runtime2, DynamicLibrary library2, long address2) {
            super(runtime2, address2);
            this.library = library2;
        }
    }

    public static final class Symbol
    extends Pointer {
        private final DynamicLibrary library;
        private final String name;

        public Symbol(Ruby runtime2, DynamicLibrary library2, String name2, MemoryIO io2) {
            super(runtime2, runtime2.getModule("FFI").getClass("DynamicLibrary").getClass("Symbol"), io2, Long.MAX_VALUE);
            this.library = library2;
            this.name = name2;
        }

        @JRubyMethod(name={"library"})
        public IRubyObject library(ThreadContext context) {
            return this.library;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect(ThreadContext context) {
            return RubyString.newString(context.runtime, String.format("#<%s library=%s symbol=%s address=%#x>", this.getMetaClass().getName(), this.library.name, this.name, this.getAddress()));
        }

        @Override
        @JRubyMethod(name={"to_s"}, optional=1)
        public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
            return RubyString.newString(context.runtime, this.name);
        }

        @Override
        public final String toString() {
            return this.name;
        }

        final String getName() {
            return this.name;
        }
    }
}

