/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import java.util.EnumSet;
import java.util.Set;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.func.TriFunction;

public class RubyWarnings
implements IRubyWarnings,
WarnCallback {
    private static final int LINE_NUMBER_NON_WARNING = Integer.MIN_VALUE;
    private final Ruby runtime;
    private final Set<IRubyWarnings.ID> oncelers = EnumSet.allOf(IRubyWarnings.ID.class);

    public RubyWarnings(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public static RubyModule createWarningModule(ThreadContext context) {
        Object Warning = Define.defineModule(context, "Warning").defineMethods(context, RubyWarnings.class);
        ((RubyModule)Warning).extend_object(context, (IRubyObject)Warning);
        return Warning;
    }

    public void warn(String message2) {
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    public <Context, State> void warn(Context context, State state2, TriFunction<Context, State, RubyStackTraceElement, String> callback) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyStackTraceElement trace2 = this.runtime.getCurrentContext().getSingleBacktrace();
        String message2 = callback.apply(context, state2, trace2);
        if (trace2 == null) {
            file2 = "(unknown)";
            line = 0;
        } else {
            file2 = trace2.getFileName();
            line = trace2.getLineNumber();
        }
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, file2, line, message2);
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isVerbose() {
        return this.runtime.isVerbose();
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        this.doWarn(fileName, lineNumber, message2, null);
    }

    public void warn(String fileName, int lineNumber, String message2) {
        this.doWarn(fileName, lineNumber, message2, null);
    }

    private void doWarn(String fileName, int lineNumber, CharSequence message2, Category category) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        String fullMessage = lineNumber != Integer.MIN_VALUE ? fileName + ":" + lineNumber + ": warning: " + String.valueOf(message2) + "\n" : fileName + ": " + String.valueOf(message2) + "\n";
        ThreadContext context = this.runtime.getCurrentContext();
        RubyWarnings.writeWarningDyncall(context, Create.newString(context, fullMessage), category);
    }

    private static IRubyObject writeWarningDyncall(ThreadContext context, RubyString errorString, Category category) {
        RubyModule warning = context.runtime.getWarning();
        CachingCallSite warn2 = RubyWarnings.sites((ThreadContext)context).warn;
        if (category == null || warn2.retrieveCache((IRubyObject)warning).method.getSignature() == Signature.ONE_ARGUMENT) {
            return warn2.call(context, (IRubyObject)warning, (IRubyObject)warning, (IRubyObject)errorString);
        }
        RubyHash opts = Create.newSmallHash(context, Convert.asSymbol(context, "category"), Convert.asSymbol(context, category.id));
        context.callInfo = 2;
        return warn2.call(context, (IRubyObject)warning, (IRubyObject)warning, (IRubyObject)errorString, (IRubyObject)opts);
    }

    private static IRubyObject writeWarningToError(ThreadContext context, RubyString errorString) {
        IRubyObject errorStream = Access.globalVariables(context).get("$stderr");
        return RubyWarnings.sites((ThreadContext)context).write.call(context, (IRubyObject)context.runtime.getWarning(), errorStream, (IRubyObject)errorString);
    }

    public static IRubyObject warnWithCategory(ThreadContext context, IRubyObject errorString, IRubyObject category) {
        RubySymbol cat = (RubySymbol)TypeConverter.convertToType(category, Access.symbolClass(context), "to_sym");
        if (context.runtime.getWarningCategories().contains((Object)Category.fromId(cat.idString()))) {
            RubyWarnings.warn(context, (IRubyObject)Access.kernelModule(context), errorString);
        }
        return context.nil;
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String message2) {
        this.warn(message2, (Category)null);
    }

    public void warn(String message2, Category category) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyStackTraceElement stack = this.runtime.getCurrentContext().getSingleBacktrace();
        if (stack == null) {
            file2 = "(unknown)";
            line = 0;
        } else {
            file2 = stack.getFileName();
            line = stack.getLineNumber();
        }
        this.doWarn(file2, line, message2, category);
    }

    public void warn(String file2, int line, String message2, Category category) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.doWarn(file2, line, message2, category);
    }

    public void warn(String filename2, String message2) {
        this.doWarn(filename2, Integer.MIN_VALUE, message2, null);
    }

    @Deprecated
    public void warnExperimental(String filename2, int line, String message2) {
        this.warnWithCategory(filename2, line, message2, Category.EXPERIMENTAL);
    }

    @Deprecated(since="10.0")
    public void warnDeprecated(IRubyWarnings.ID id2, String message2) {
        this.warnWithCategory(message2, Category.DEPRECATED);
    }

    public void warnDeprecated(String message2) {
        this.warnWithCategory(message2, Category.DEPRECATED);
    }

    public void warnExperimental(String message2) {
        this.warnWithCategory(message2, Category.EXPERIMENTAL);
    }

    public void warnPerformance(String message2) {
        this.warnWithCategory(message2, Category.PERFORMANCE);
    }

    private void warnWithCategory(String message2, Category category) {
        if (this.runtime.getWarningCategories().contains((Object)category)) {
            this.warn(message2, category);
        }
    }

    private void warnWithCategory(String filename2, int line, String message2, Category category) {
        if (this.runtime.getWarningCategories().contains((Object)category)) {
            this.warn(filename2, line, message2, category);
        }
    }

    @Deprecated(since="10.0")
    public void warnDeprecatedAlternate(String name2, String alternate) {
        if (this.hasDeprecationWarningEnabled()) {
            this.warn(IRubyWarnings.ID.DEPRECATED_METHOD, name2 + " is deprecated; use " + alternate + " instead");
        }
    }

    @Deprecated(since="10.0")
    public void warnDeprecatedForRemoval(String name2, String version) {
        if (this.hasDeprecationWarningEnabled()) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, name2 + " is deprecated and will be removed in Ruby " + version);
        }
    }

    public void warnDeprecatedForRemovalAlternate(String name2, String version, String alternate) {
        if (this.hasDeprecationWarningEnabled()) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, name2 + " is deprecated and will be removed in Ruby " + version + "; use " + alternate + " instead");
        }
    }

    public boolean hasDeprecationWarningEnabled() {
        return this.runtime.getWarningCategories().contains((Object)Category.DEPRECATED);
    }

    public void warnOnce(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        if (this.oncelers.contains((Object)id2)) {
            return;
        }
        this.oncelers.add(id2);
        this.warn(id2, message2);
    }

    public void warning(String message2) {
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    public void warningDeprecated(String message2) {
        this.warningDeprecated(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String message2) {
        if (!this.isVerbose()) {
            return;
        }
        this.warn(id2, message2);
    }

    public void warningDeprecated(IRubyWarnings.ID id2, String message2) {
        if (!this.isVerbose() && !this.runtime.getWarningCategories().contains((Object)Category.DEPRECATED)) {
            return;
        }
        this.warning(id2, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.isVerbose()) {
            return;
        }
        this.warn(id2, fileName, lineNumber, message2);
    }

    public void warning(String fileName, int lineNumber, String message2) {
        if (!this.isVerbose()) {
            return;
        }
        this.warn(fileName, lineNumber, message2);
    }

    @JRubyMethod(name={"[]"})
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        TypeConverter.checkType(context, arg2, Access.symbolClass(context));
        String categoryId = ((RubySymbol)arg2).idString();
        Category category = Category.fromId(categoryId);
        if (category == null) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "unknown category: ", arg2));
        }
        return Convert.asBoolean(context, context.runtime.getWarningCategories().contains((Object)category));
    }

    @JRubyMethod(name={"[]="})
    public static IRubyObject op_aset(ThreadContext context, IRubyObject self2, IRubyObject arg2, IRubyObject flag) {
        TypeConverter.checkType(context, arg2, Access.symbolClass(context));
        String categoryId = ((RubySymbol)arg2).idString();
        Category category = Category.fromId(categoryId);
        if (category != null) {
            if (flag.isTrue()) {
                context.runtime.getWarningCategories().add(category);
            } else {
                context.runtime.getWarningCategories().remove((Object)category);
            }
        } else {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "unknown category: ", arg2));
        }
        return flag;
    }

    @JRubyMethod(keywords=true)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        ThreadContext.resetCallInfo(context);
        TypeConverter.checkType(context, arg2, Access.stringClass(context));
        return RubyWarnings.warn(context, (RubyString)arg2);
    }

    @JRubyMethod(keywords=true)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        if ((ThreadContext.resetCallInfo(context) & 2) == 0) {
            throw Error.argumentError(context, 2, 1);
        }
        IRubyObject opts = TypeConverter.checkHashType(context.runtime, arg1);
        IRubyObject ret = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "category");
        return ret.isNil() ? RubyWarnings.warn(context, recv2, arg0) : RubyWarnings.warnWithCategory(context, arg0, ret);
    }

    public static IRubyObject warn(ThreadContext context, RubyString str) {
        str.verifyAsciiCompatible();
        RubyWarnings.writeWarningToError(context, str);
        return context.nil;
    }

    @JRubyMethod
    public static IRubyObject categories(ThreadContext context, IRubyObject recv2) {
        return Create.newArrayFrom(context, Category.values(), (ctx, c) -> Convert.asSymbol(ctx, c.id));
    }

    private static JavaSites.WarningSites sites(ThreadContext context) {
        return context.sites.Warning;
    }

    @Override
    @Deprecated
    public void warn(IRubyWarnings.ID id2, String fileName, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        RubyWarnings.warn(context, Create.newString(context, fileName + " warning: " + message2 + "\n"));
    }

    @Deprecated
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return switch (args2.length) {
            case 1 -> RubyWarnings.warn(context, recv2, args2[0]);
            case 2 -> RubyWarnings.warn(context, recv2, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 1, 2);
        };
    }

    public static enum Category {
        EXPERIMENTAL("experimental"),
        DEPRECATED("deprecated"),
        PERFORMANCE("performance");

        private String id;

        private Category(String id2) {
            this.id = id2;
        }

        public static Category fromId(String id2) {
            return switch (id2) {
                case "experimental" -> EXPERIMENTAL;
                case "deprecated" -> DEPRECATED;
                case "performance" -> PERFORMANCE;
                default -> null;
            };
        }
    }
}

