/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.ExplicitVertexID;
import org.jruby.dirgra.Vertex;

public class DirectedGraph<T extends ExplicitVertexID, U> {
    private static final int INITIAL_SIZE = 4;
    private final Map<T, Vertex<T, U>> vertices = new HashMap<T, Vertex<T, U>>();
    private Edge<T, U>[] edges = new Edge[4];
    private int edgeLength = 0;
    private ArrayList inOrderVerticeData = new ArrayList();
    int vertexIDCounter = 0;

    protected Edge<T, U>[] growEdges(Edge<T, U>[] array, int realLength) {
        int newLength = array.length == 0 ? 2 : array.length * 2;
        Edge[] newEdges = new Edge[newLength];
        System.arraycopy(array, 0, newEdges, 0, realLength);
        return newEdges;
    }

    protected Edge<T, U>[] getEdges() {
        return this.edges;
    }

    protected Edge<T, U> addEdge(Edge<T, U> newEdge) {
        for (int i = 0; i < this.edgeLength; ++i) {
            if (!this.edges[i].equals(newEdge)) continue;
            return newEdge;
        }
        if (this.edgeLength >= this.edges.length) {
            this.edges = this.growEdges(this.edges, this.edgeLength);
        }
        this.edges[this.edgeLength++] = newEdge;
        return newEdge;
    }

    public void removeEdge(Edge<T, U> edge) {
        int splitPoint = -1;
        for (int i = 0; i < this.edgeLength; ++i) {
            if (!this.edges[i].equals(edge)) continue;
            splitPoint = i;
            break;
        }
        if (splitPoint != -1) {
            Edge<T, U> edgeToRemove = this.edges[splitPoint];
            if (splitPoint < this.edgeLength - 1) {
                System.arraycopy(this.edges, splitPoint + 1, this.edges, splitPoint, this.edgeLength - 1 - splitPoint);
            }
            this.edges[this.edgeLength - 1] = null;
            --this.edgeLength;
            edge.getSource().removeOutgoingEdge(edgeToRemove);
            edge.getDestination().removeIncomingEdge(edgeToRemove);
        }
    }

    public Collection<Vertex<T, U>> vertices() {
        return this.vertices.values();
    }

    public Collection<Edge<T, U>> edges() {
        return Arrays.asList(Arrays.copyOf(this.edges, this.edgeLength));
    }

    public Iterable<Edge<T, U>> edgesOfType(U type) {
        return new EdgeTypeIterable<T, U>(this.edges, this.edgeLength, type);
    }

    public Collection<T> allData() {
        return this.vertices.keySet();
    }

    public Collection<T> getInorderData() {
        return this.inOrderVerticeData;
    }

    public void addEdge(T source, T destination, U type) {
        this.findOrCreateVertexFor(source).addEdgeTo(destination, type);
    }

    public void removeEdge(T source, T destination) {
        if (this.findVertexFor(source) != null) {
            for (Edge<T, U> edge : this.findOrCreateVertexFor(source).getOutgoingEdges()) {
                if (edge.getDestination().getData() != destination) continue;
                this.findOrCreateVertexFor(source).removeEdgeTo(edge.getDestination());
                return;
            }
        }
    }

    public Vertex<T, U> findVertexFor(T data) {
        return this.vertices.get(data);
    }

    public Vertex<T, U> findOrCreateVertexFor(T data) {
        Vertex<T, U> vertex = this.vertices.get(data);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex(this, data, this.vertexIDCounter++);
        this.inOrderVerticeData.add(data);
        this.vertices.put(data, vertex);
        return vertex;
    }

    public void removeVertexFor(T data) {
        if (this.findVertexFor(data) != null) {
            Vertex<T, U> vertex = this.findOrCreateVertexFor(data);
            this.vertices.remove(data);
            this.inOrderVerticeData.remove(data);
            vertex.removeAllEdges();
        }
    }

    public int size() {
        return this.allData().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<Vertex<T, U>> verts = new ArrayList<Vertex<T, U>>(this.vertices.values());
        Collections.sort(verts);
        for (Vertex<T, U> vertex : verts) {
            buf.append(vertex);
        }
        return buf.toString();
    }
}

