/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.zulip;

import java.util.LinkedHashMap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Zulip;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.zulip.ZulipException;
import org.jreleaser.sdk.zulip.ZulipSdk;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class ZulipAnnouncer
implements Announcer {
    private final JReleaserContext context;

    ZulipAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "zulip";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getZulip().isEnabled();
    }

    public void announce() throws AnnounceException {
        Zulip zulip = this.context.getModel().getAnnounce().getZulip();
        String message = "";
        if (StringUtils.isNotBlank((String)zulip.getMessage())) {
            message = zulip.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = zulip.getResolvedMessageTemplate(this.context, props);
        }
        String subject = zulip.getResolvedSubject(this.context);
        this.context.getLogger().info("channel: {}", new Object[]{zulip.getChannel()});
        this.context.getLogger().info("subject: {}", new Object[]{subject});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            ZulipSdk sdk = ZulipSdk.builder(this.context.getLogger()).apiHost(zulip.getApiHost()).account(zulip.getAccount()).apiKey(this.context.isDryrun() ? "**UNDEFINED**" : zulip.getResolvedApiKey()).connectTimeout(zulip.getConnectTimeout()).readTimeout(zulip.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.message(zulip.getChannel(), subject, message);
        }
        catch (ZulipException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

