/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.slack;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.slack.SlackException;
import org.jreleaser.sdk.slack.api.Message;
import org.jreleaser.sdk.slack.api.SlackAPI;
import org.jreleaser.sdk.slack.api.SlackResponse;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class SlackSdk {
    private final JReleaserLogger logger;
    private final SlackAPI api;
    private final boolean dryrun;

    private SlackSdk(JReleaserLogger logger, String token, String apiHost, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        this.logger = logger;
        this.dryrun = dryrun;
        this.api = (SlackAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", token)})).target(SlackAPI.class, apiHost);
        this.logger.debug("Slack dryrun set to {}", new Object[]{dryrun});
    }

    public void message(String channel, String message) throws SlackException {
        Message payload = Message.of(channel, message);
        this.logger.debug("slack.message: " + payload.toString());
        this.decode(this.wrap(() -> {
            SlackResponse response = this.api.message(payload);
            return response.getError();
        }));
    }

    private void decode(String error) throws SlackException {
        if (StringUtils.isNotBlank((String)error) && !"null".equals(error)) {
            throw new SlackException(error);
        }
    }

    private String wrap(Callable<String> runnable) throws SlackException {
        try {
            if (!this.dryrun) {
                return runnable.call();
            }
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            throw new SlackException("Slack operation failed", e);
        }
        return null;
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String token;
        private String apiHost;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder token(String token) {
            this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank").trim();
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.token, (String)"'token' must not be blank");
        }

        public SlackSdk build() {
            if (StringUtils.isBlank((String)this.apiHost)) {
                this.apiHost("https://slack.com/api/");
            }
            this.validate();
            return new SlackSdk(this.logger, this.token, this.apiHost, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

