/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util.signing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.jreleaser.util.signing.SigningException;

public abstract class Keyring {
    private final KeyFingerPrintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
    private PGPPublicKeyRingCollection publicKeyRings = new PGPPublicKeyRingCollection(Collections.emptyList());
    private PGPSecretKeyRingCollection secretKeyRings = new PGPSecretKeyRingCollection(Collections.emptyList());

    public Keyring initialize(boolean armored) throws IOException, PGPException {
        try (InputStream pub = this.getPublicKeyRingStream();
             InputStream sec = this.getSecretKeyRingStream();){
            this.addPublicKey(armored, pub);
            this.addSecretKey(armored, sec);
        }
        return this;
    }

    public KeyFingerPrintCalculator getKeyFingerPrintCalculator() {
        return this.keyFingerPrintCalculator;
    }

    protected abstract InputStream getPublicKeyRingStream() throws IOException;

    protected abstract InputStream getSecretKeyRingStream() throws IOException;

    public void addPublicKey(boolean armored, InputStream raw) throws IOException, PGPException {
        if (!armored) {
            this.addPublicKeyRing(new PGPPublicKeyRing(raw, this.keyFingerPrintCalculator));
            return;
        }
        try (InputStream decoded = PGPUtil.getDecoderStream((InputStream)raw);){
            this.addPublicKeyRing(new PGPPublicKeyRing(decoded, this.keyFingerPrintCalculator));
        }
    }

    public void addSecretKey(boolean armored, InputStream raw) throws IOException, PGPException {
        if (!armored) {
            this.addSecretKeyRing(new PGPSecretKeyRing(raw, this.keyFingerPrintCalculator));
            return;
        }
        try (InputStream decoded = PGPUtil.getDecoderStream((InputStream)raw);){
            this.addSecretKeyRing(new PGPSecretKeyRing(decoded, this.keyFingerPrintCalculator));
        }
    }

    public void addSecretKeyRing(PGPSecretKeyRing keyring) {
        this.secretKeyRings = PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)this.secretKeyRings, (PGPSecretKeyRing)keyring);
    }

    public void addPublicKeyRing(PGPPublicKeyRing keyring) {
        this.publicKeyRings = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.publicKeyRings, (PGPPublicKeyRing)keyring);
    }

    public PGPSecretKey getSecretKey() throws SigningException, PGPException {
        return this.secretKeyRings.getSecretKey(this.readPublicKey().getKeyID());
    }

    public PGPPublicKey readPublicKey() throws SigningException {
        Iterator keyRingIter = this.publicKeyRings.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                if (!Keyring.isSigningKey(key)) continue;
                return key;
            }
        }
        throw new SigningException("Did not find public key for signing.");
    }

    private static boolean isSigningKey(PGPPublicKey key) {
        int algorithm = key.getAlgorithm();
        return algorithm == 22 || algorithm == 19 || algorithm == 20 || algorithm == 16 || algorithm == 3 || algorithm == 1 || algorithm == 17;
    }
}

