/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ssh;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.FingerprintVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Ssh;
import org.jreleaser.model.internal.download.SshDownloader;
import org.jreleaser.model.internal.upload.SshUploader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.util.StringUtils;

public class SshUtils {
    private SshUtils() {
    }

    public static SSHClient createSSHClient(JReleaserContext context, SshUploader<?> uploader) throws UploadException {
        if (context.isDryrun()) {
            return null;
        }
        try {
            SSHClient client = SshUtils.sshClient(context, uploader);
            client.setConnectTimeout(uploader.getConnectTimeout() * 1000);
            client.setTimeout(uploader.getReadTimeout() * 1000);
            return client;
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_unexpected_upload_to", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    public static SSHClient createSSHClient(JReleaserContext context, SshDownloader<?> downloader) throws DownloadException {
        if (context.isDryrun()) {
            return null;
        }
        try {
            SSHClient client = SshUtils.sshClient(context, downloader);
            client.setConnectTimeout(downloader.getConnectTimeout() * 1000);
            client.setTimeout(downloader.getReadTimeout() * 1000);
            return client;
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_unexpected_download_from", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }

    private static SSHClient sshClient(JReleaserContext context, Ssh ssh) throws IOException {
        SSHClient client = new SSHClient();
        Path defaultKnownHostsFilePath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ssh/known_hosts");
        if (StringUtils.isNotBlank((String)ssh.getKnownHostsFile())) {
            Path knownHostsFilePath = context.getBasedir().resolve(ssh.getKnownHostsFile());
            if (Files.exists(knownHostsFilePath, new LinkOption[0])) {
                client.loadKnownHosts(knownHostsFilePath.toFile());
            } else {
                if (!Files.exists(defaultKnownHostsFilePath, new LinkOption[0])) {
                    Files.createDirectories(defaultKnownHostsFilePath.getParent(), new FileAttribute[0]);
                    Files.createFile(defaultKnownHostsFilePath, new FileAttribute[0]);
                }
                client.loadKnownHosts();
            }
        } else {
            if (!Files.exists(defaultKnownHostsFilePath, new LinkOption[0])) {
                Files.createDirectories(defaultKnownHostsFilePath.getParent(), new FileAttribute[0]);
                Files.createFile(defaultKnownHostsFilePath, new FileAttribute[0]);
            }
            client.loadKnownHosts();
        }
        String publicKey = ssh.getPublicKey();
        String privateKey = ssh.getPrivateKey();
        String passphrase = ssh.getPassphrase();
        String fingerprint = ssh.getFingerprint();
        if (StringUtils.isNotBlank((String)publicKey) && StringUtils.isNotBlank((String)privateKey)) {
            PasswordFinder passwordFinder = null;
            if (StringUtils.isNotBlank((String)passphrase)) {
                passwordFinder = PasswordUtils.createOneOff((char[])passphrase.toCharArray());
            }
            client.loadKeys(privateKey, publicKey, passwordFinder);
        }
        if (StringUtils.isNotBlank((String)fingerprint)) {
            client.addHostKeyVerifier(FingerprintVerifier.getInstance((String)fingerprint));
        }
        if (Boolean.getBoolean("jreleaser.disableSshVerification")) {
            context.getLogger().warn(RB.$((String)"warn_ssh_disabled", (Object[])new Object[0]));
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
        client.connect(ssh.getHost(), ssh.getPort().intValue());
        client.authPassword(ssh.getUsername(), ssh.getPassword());
        return client;
    }

    public static SFTPClient createSFTPClient(JReleaserContext context, SshUploader<?> uploader, SSHClient ssh) throws UploadException {
        if (null == ssh) {
            return null;
        }
        try {
            return ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_unexpected_upload_to", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    public static SFTPClient createSFTPClient(JReleaserContext context, SshDownloader<?> downloader, SSHClient ssh) throws DownloadException {
        if (null == ssh) {
            return null;
        }
        try {
            return ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_unexpected_download_from", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }

    public static void createDirectories(JReleaserContext context, SshUploader<?> uploader, SSHClient ssh, Path path) throws UploadException {
        try (Session session = ssh.startSession();){
            Session.Command cmd = session.exec("mkdir -p " + path.toAbsolutePath());
            cmd.join((long)uploader.getReadTimeout().intValue(), TimeUnit.SECONDS);
        }
        catch (SSHException e) {
            context.getLogger().trace((Throwable)e);
            throw new UploadException(RB.$((String)"ERROR_ssh_mkdir", (Object[])new Object[]{path}), (Throwable)e);
        }
    }

    public static void disconnect(SshUploader<?> uploader, SSHClient ssh) throws UploadException {
        try {
            if (null != ssh) {
                ssh.disconnect();
            }
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    public static void disconnect(SshDownloader<?> downloader, SSHClient ssh) throws DownloadException {
        try {
            if (null != ssh) {
                ssh.disconnect();
            }
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }

    public static void close(SshUploader<?> uploader, SFTPClient sftp) throws UploadException {
        try {
            if (null != sftp) {
                sftp.close();
            }
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    public static void close(SshDownloader<?> downloader, SFTPClient sftp) throws DownloadException {
        try {
            if (null != sftp) {
                sftp.close();
            }
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }
}

