/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Webhook;
import org.jreleaser.model.Webhooks;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class WebhooksValidator
extends Validator {
    private static final String DEFAULT_TPL = "src/jreleaser/templates/";

    public static void validateWebhooks(JReleaserContext context, Webhooks webhooks, Errors errors) {
        context.getLogger().debug("announce.webhooks");
        Map<String, Webhook> webhook = webhooks.getWebhooks();
        boolean enabled = false;
        for (Map.Entry<String, Webhook> e : webhook.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!WebhooksValidator.validateWebhook(context, webhooks, e.getValue(), errors)) continue;
            enabled = true;
        }
        if (enabled) {
            webhooks.setActive(Active.ALWAYS);
            webhooks.resolveEnabled(context.getModel().getProject());
        }
    }

    public static boolean validateWebhook(JReleaserContext context, Webhooks webhooks, Webhook webhook, Errors errors) {
        if (!webhook.resolveEnabled(context.getModel().getProject())) {
            return false;
        }
        if (StringUtils.isBlank((String)webhook.getName())) {
            webhook.disable();
            return false;
        }
        context.getLogger().debug("announce.webhook." + webhook.getName());
        webhook.setWebhook(WebhooksValidator.checkProperty(context, Env.toVar((String)webhook.getName()) + "_WEBHOOK", "webhook." + webhook.getName() + ".webhook", webhook.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)webhook.getMessage()) && StringUtils.isBlank((String)webhook.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_TPL + webhook.getName() + ".tpl"), new LinkOption[0])) {
                webhook.setMessageTemplate(DEFAULT_TPL + webhook.getName() + ".tpl");
            } else {
                webhook.setMessage(RB.$((String)"default_release_message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)webhook.getMessage()) && StringUtils.isBlank((String)webhook.getMessageProperty())) {
            webhook.setMessageProperty("text");
        }
        if (StringUtils.isNotBlank((String)webhook.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(webhook.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"webhook." + webhook.getName() + ".messageTemplate", webhook.getMessageTemplate()}));
        }
        WebhooksValidator.validateTimeout(webhook);
        return true;
    }
}

