/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Docker;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.TemplateTool;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TemplateValidator
extends Validator {
    public static void validateTemplate(JReleaserContext context, Distribution distribution, TemplateTool tool, TemplateTool parentTool, Errors errors) {
        if (StringUtils.isBlank((String)tool.getTemplateDirectory())) {
            tool.setTemplateDirectory(parentTool.getTemplateDirectory());
            if (StringUtils.isNotBlank((String)tool.getTemplateDirectory()) && !context.getBasedir().resolve(tool.getTemplateDirectory().trim()).toFile().exists()) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + tool.getName() + ".template", tool.getTemplateDirectory()}));
            } else {
                tool.setTemplateDirectory("src/jreleaser/distributions/" + distribution.getName() + "/" + tool.getName());
            }
            return;
        }
        if (StringUtils.isNotBlank((String)tool.getTemplateDirectory()) && !context.getBasedir().resolve(tool.getTemplateDirectory().trim()).toFile().exists()) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + tool.getName() + ".template", tool.getTemplateDirectory()}));
        } else {
            tool.setTemplateDirectory("src/jreleaser/distributions/" + distribution.getName() + "/" + tool.getName());
        }
    }

    public static void validateTemplate(JReleaserContext context, JavaAssembler assembler, Errors errors) {
        if (StringUtils.isNotBlank((String)assembler.getTemplateDirectory()) && !context.getBasedir().resolve(assembler.getTemplateDirectory().trim()).toFile().exists()) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".template", assembler.getTemplateDirectory()}));
        } else {
            assembler.setTemplateDirectory("src/jreleaser/assemblers/" + assembler.getName() + "/" + assembler.getType());
        }
    }

    public static void validateTemplate(JReleaserContext context, Distribution distribution, DockerSpec spec, Docker docker, Errors errors) {
        if (StringUtils.isNotBlank((String)spec.getTemplateDirectory()) && !context.getBasedir().resolve(spec.getTemplateDirectory().trim()).toFile().exists()) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".docker." + spec.getName() + ".template", spec.getTemplateDirectory()}));
        } else {
            spec.setTemplateDirectory("src/jreleaser/distributions/" + distribution.getName() + "/" + spec.getName() + "/" + docker.getName());
        }
    }
}

