/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Telegram;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TelegramValidator
extends Validator {
    private static final String DEFAULT_TELEGRAM_TPL = "src/jreleaser/templates/telegram.tpl";

    public static void validateTelegram(JReleaserContext context, Telegram telegram, Errors errors) {
        if (!telegram.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.telegram");
        telegram.setToken(TelegramValidator.checkProperty(context, "TELEGRAM_TOKEN", "telegram.token", telegram.getToken(), errors, context.isDryrun()));
        telegram.setChatId(TelegramValidator.checkProperty(context, "TELEGRAM_CHAT_ID", "telegram.chatId", telegram.getChatId(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)telegram.getMessage()) && StringUtils.isBlank((String)telegram.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_TELEGRAM_TPL), new LinkOption[0])) {
                telegram.setMessageTemplate(DEFAULT_TELEGRAM_TPL);
            } else {
                telegram.setMessage(RB.$((String)"default_release_message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)telegram.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(telegram.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"telegram.messageTemplate", telegram.getMessageTemplate()}));
        }
        TelegramValidator.validateTimeout(telegram);
    }
}

