/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Java;
import org.jreleaser.model.Packagers;
import org.jreleaser.model.Project;
import org.jreleaser.model.Tool;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class Distribution
extends Packagers
implements ExtraProperties,
Activatable {
    public static final EnumSet<DistributionType> JAVA_DISTRIBUTION_TYPES = EnumSet.of(DistributionType.JAVA_BINARY, DistributionType.JLINK, DistributionType.SINGLE_JAR);
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final Java java = new Java();
    private Active active;
    private boolean enabled;
    private String name;
    private DistributionType type = DistributionType.JAVA_BINARY;
    private String executable;

    void setAll(Distribution distribution) {
        super.setAll(distribution);
        this.active = distribution.active;
        this.enabled = distribution.enabled;
        this.name = distribution.name;
        this.type = distribution.type;
        this.executable = distribution.executable;
        this.setJava(distribution.java);
        this.setTags(distribution.tags);
        this.setExtraProperties(distribution.extraProperties);
        this.setArtifacts(distribution.artifacts);
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        props.put("distributionExecutable", this.executable);
        props.put("distributionTagsBySpace", String.join((CharSequence)" ", this.tags));
        props.put("distributionTagsByComma", String.join((CharSequence)",", this.tags));
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            Version jv = Version.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public String getPrefix() {
        return "distribution";
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public DistributionType getType() {
        return this.type;
    }

    public void setType(DistributionType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = DistributionType.of(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public Set<Artifact> getArtifacts() {
        return Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.add(tag.trim());
        }
    }

    public void removeTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.remove(tag.trim());
        }
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.setAll(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.extraProperties.containsKey(k)) {
                this.extraProperties.put((String)k, v);
            }
        });
    }

    public <T extends Tool> T findTool(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_tool_name_not_blank", (Object[])new Object[0]));
        }
        return this.resolveTool(name);
    }

    public <T extends Tool> T getTool(String name) {
        T tool = this.findTool(name);
        if (null != tool) {
            return tool;
        }
        throw new JReleaserException(RB.$((String)"ERROR_tool_not_configured", (Object[])new Object[]{name}));
    }

    private <T extends Tool> T resolveTool(String name) {
        switch (name.toLowerCase().trim()) {
            case "brew": {
                return (T)this.getBrew();
            }
            case "chocolatey": {
                return (T)this.getChocolatey();
            }
            case "docker": {
                return (T)this.getDocker();
            }
            case "jbang": {
                return (T)this.getJbang();
            }
            case "scoop": {
                return (T)this.getScoop();
            }
            case "sdkman": {
                return (T)this.getSdkman();
            }
            case "snap": {
                return (T)this.getSnap();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_tool", (Object[])new Object[]{name}));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("type", (Object)this.type);
        props.put("executable", this.executable);
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        props.put("artifacts", mappedArtifacts);
        props.put("tags", this.tags);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
        props.putAll(super.asMap(full));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, props);
        return map;
    }

    public static Set<String> supportedTools() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("brew");
        set.add("chocolatey");
        set.add("docker");
        set.add("jbang");
        set.add("scoop");
        set.add("sdkman");
        set.add("snap");
        return Collections.unmodifiableSet(set);
    }

    public static enum DistributionType {
        BINARY,
        JAVA_BINARY,
        JLINK,
        SINGLE_JAR,
        NATIVE_IMAGE,
        NATIVE_PACKAGE;


        public static DistributionType of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return DistributionType.valueOf(str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase().trim());
        }
    }
}

