/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.CaskItem;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class Cask
implements Domain {
    private final List<CaskItem> uninstall = new ArrayList<CaskItem>();
    private final List<CaskItem> zap = new ArrayList<CaskItem>();
    protected Boolean enabled;
    private String name;
    private String displayName;
    private String pkgName;
    private String appName;
    private String appcast;
    private String cachedCaskName;
    private String cachedDisplayName;
    private String cachedAppName;
    private String cachedPkgName;

    void setAll(Cask cask) {
        this.enabled = cask.enabled;
        this.name = cask.name;
        this.displayName = cask.displayName;
        this.pkgName = cask.pkgName;
        this.appName = cask.appName;
        this.appcast = cask.appcast;
        this.setUninstallItems(cask.uninstall);
        this.setZapItems(cask.zap);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getResolvedAppcast(Map<String, Object> props) {
        if (StringUtils.isNotBlank((String)this.appcast)) {
            return MustacheUtils.applyTemplate((Reader)new StringReader(this.appcast), props);
        }
        return this.appcast;
    }

    public String getResolvedCaskName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedCaskName)) {
            this.cachedCaskName = this.name.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.name), context.getModel().props()) : this.name;
            this.cachedCaskName = this.cachedCaskName.toLowerCase();
        }
        return this.cachedCaskName;
    }

    public String getResolvedCaskName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedCaskName)) {
            this.cachedCaskName = this.name.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.name), props) : this.name;
            this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
        } else if (this.cachedCaskName.contains("{{")) {
            this.cachedCaskName = MustacheUtils.applyTemplate((Reader)new StringReader(this.cachedCaskName), props);
            this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
        }
        return this.cachedCaskName;
    }

    public String getResolvedDisplayName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedDisplayName)) {
            this.cachedDisplayName = this.displayName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.displayName), context.getModel().props()) : this.displayName;
            this.cachedDisplayName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName);
        }
        return this.cachedDisplayName;
    }

    public String getResolvedDisplayName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedDisplayName)) {
            this.cachedDisplayName = this.displayName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.displayName), props) : this.displayName;
            this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
        } else if (this.cachedDisplayName.contains("{{")) {
            this.cachedDisplayName = MustacheUtils.applyTemplate((Reader)new StringReader(this.cachedDisplayName), props);
            this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
        }
        return this.cachedDisplayName;
    }

    public String getResolvedAppName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedAppName)) {
            this.cachedAppName = this.appName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.appName), context.getModel().props()) : this.appName;
        }
        return this.cachedAppName;
    }

    public String getResolvedAppName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedAppName)) {
            this.cachedAppName = this.appName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.appName), props) : this.appName;
        } else if (this.cachedAppName.contains("{{")) {
            this.cachedAppName = MustacheUtils.applyTemplate((Reader)new StringReader(this.cachedAppName), props);
        }
        return this.cachedAppName;
    }

    public String getResolvedPkgName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedPkgName)) {
            this.cachedPkgName = this.pkgName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.pkgName), context.getModel().props()) : this.pkgName;
        }
        return this.cachedPkgName;
    }

    public String getResolvedPkgName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedPkgName)) {
            this.cachedPkgName = this.pkgName.contains("{{") ? MustacheUtils.applyTemplate((Reader)new StringReader(this.pkgName), props) : this.pkgName;
        } else if (this.cachedPkgName.contains("{{")) {
            this.cachedPkgName = MustacheUtils.applyTemplate((Reader)new StringReader(this.cachedPkgName), props);
        }
        return this.cachedPkgName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppcast() {
        return this.appcast;
    }

    public void setAppcast(String appcast) {
        this.appcast = appcast;
    }

    public List<CaskItem> getUninstallItems() {
        return this.uninstall;
    }

    void setUninstallItems(List<CaskItem> uninstall) {
        this.uninstall.clear();
        this.uninstall.addAll(uninstall);
    }

    public void setUninstall(Map<String, List<String>> uninstall) {
        this.uninstall.clear();
        uninstall.forEach((name, items) -> this.uninstall.add(new CaskItem((String)name, (List<String>)items)));
    }

    public void addUninstall(CaskItem item) {
        if (null != item) {
            this.uninstall.add(item);
        }
    }

    public boolean getHasUninstall() {
        return !this.uninstall.isEmpty();
    }

    public List<CaskItem> getZapItems() {
        return this.zap;
    }

    void setZapItems(List<CaskItem> zap) {
        this.zap.clear();
        this.zap.addAll(zap);
    }

    public void setZap(Map<String, List<String>> zap) {
        this.zap.clear();
        zap.forEach((name, items) -> this.zap.add(new CaskItem((String)name, (List<String>)items)));
    }

    public void addZap(CaskItem item) {
        if (null != item) {
            this.zap.add(item);
        }
    }

    public boolean getHasZap() {
        return !this.zap.isEmpty();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("name", this.name);
        map.put("displayName", this.displayName);
        map.put("appName", this.appName);
        map.put("pkgName", this.pkgName);
        map.put("appcast", this.appcast);
        if (!this.uninstall.isEmpty()) {
            map.put("uninstall", this.uninstall.stream().map(CaskItem::asMap).collect(Collectors.toList()));
        }
        if (!this.zap.isEmpty()) {
            map.put("zap", this.zap.stream().map(CaskItem::asMap).collect(Collectors.toList()));
        }
        return map;
    }
}

