/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.FtpDownloader;
import org.jreleaser.model.internal.validation.common.FtpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class FtpDownloaderValidator {
    private FtpDownloaderValidator() {
    }

    public static void validateFtpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, FtpDownloader> ftp = context.getModel().getDownload().getFtp();
        if (!ftp.isEmpty()) {
            context.getLogger().debug("download.ftp");
        }
        for (Map.Entry<String, FtpDownloader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            FtpDownloaderValidator.validateFtp(context, e.getValue(), errors);
        }
    }

    private static void validateFtp(JReleaserContext context, FtpDownloader downloader, Errors errors) {
        context.getLogger().debug("download.ftp.{}", new Object[]{downloader.getName()});
        Validator.resolveActivatable(context, (Activatable)downloader, CollectionUtils.listOf((Object[])new String[]{"download.ftp." + downloader.getName(), "download.ftp"}), "ALWAYS");
        if (!downloader.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        FtpValidator.validateFtp(context, downloader, "upload", downloader.getName(), errors, true);
        Validator.validateTimeout(downloader);
        if (downloader.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"download.ftp." + downloader.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : downloader.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"download.ftp." + downloader.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

