/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.catalog;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.Catalog;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.catalog.SlsaCatalogerValidator;
import org.jreleaser.model.internal.validation.catalog.sbom.SbomCatalogersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public final class CatalogValidator {
    private CatalogValidator() {
    }

    public static void validateCatalog(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("catalog");
        Catalog catalog = context.getModel().getCatalog();
        SbomCatalogersValidator.validateSbomCatalogers(context, mode, errors);
        SlsaCatalogerValidator.validateSlsaCataloger(context, mode, errors);
        if (mode.validateConfig()) {
            boolean activeSet = catalog.isActiveSet();
            Validator.resolveActivatable(context, (Activatable)catalog, "catalog", "ALWAYS");
            catalog.resolveEnabled(context.getModel().getProject());
            if (catalog.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = catalog.getSbom().isEnabled() || catalog.getSlsa().isEnabled();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    catalog.disable();
                }
            }
        }
    }
}

