/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.catalog.SlsaCataloger;
import org.jreleaser.model.internal.catalog.sbom.Sbom;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;

public final class Catalog
extends AbstractActivatable<Catalog>
implements Domain {
    private static final long serialVersionUID = -1338155149564894995L;
    private final Sbom sbom = new Sbom();
    private final SlsaCataloger slsa = new SlsaCataloger();
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.Catalog immutable = new org.jreleaser.model.api.catalog.Catalog(){
        private static final long serialVersionUID = 6865438805449170431L;

        public org.jreleaser.model.api.catalog.sbom.Sbom getSbom() {
            return Catalog.this.sbom.asImmutable();
        }

        public org.jreleaser.model.api.catalog.SlsaCataloger getSlsa() {
            return Catalog.this.slsa.asImmutable();
        }

        public Active getActive() {
            return Catalog.this.getActive();
        }

        public boolean isEnabled() {
            return Catalog.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Catalog.this.asMap(full));
        }
    };

    public Catalog() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.catalog.Catalog asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Catalog source) {
        super.merge(source);
        this.setSbom(source.sbom);
        this.setSlsa(source.slsa);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.sbom.isSet() || this.slsa.isSet();
    }

    public Sbom getSbom() {
        return this.sbom;
    }

    public void setSbom(Sbom sbom) {
        this.sbom.merge(sbom);
    }

    public SlsaCataloger getSlsa() {
        return this.slsa;
    }

    public void setSlsa(SlsaCataloger slsa) {
        this.slsa.merge(slsa);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("sbom", this.sbom.asMap(full));
        map.putAll(this.slsa.asMap(full));
        return map;
    }
}

