/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.HttpDownloader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpDownloaderValidator
extends Validator {
    public static void validateHttpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, HttpDownloader> http = context.getModel().getDownload().getHttp();
        if (!http.isEmpty()) {
            context.getLogger().debug("download.http");
        }
        for (Map.Entry<String, HttpDownloader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            HttpDownloaderValidator.validateHttp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, HttpDownloader http, Errors errors) {
        context.getLogger().debug("download.http.{}", new Object[]{http.getName()});
        if (!http.isActiveSet()) {
            http.setActive(Active.ALWAYS);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        String baseKey = "download.http." + http.getName() + ".";
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", baseKey + "password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_USERNAME", baseKey + "username", http.getUsername(), errors, context.isDryrun()));
                http.setPassword(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", baseKey + ".password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        HttpDownloaderValidator.validateTimeout(http);
        if (http.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"http." + http.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : http.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"http." + http.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

