/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.GoogleChatAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GoogleChatAnnouncerValidator
extends Validator {
    private static final String DEFAULT_GOOGLE_CHAT_TPL = "src/jreleaser/templates/googleChat.tpl";

    public static void validateGoogleChat(JReleaserContext context, GoogleChatAnnouncer googleChat, Errors errors) {
        context.getLogger().debug("announce.googleChat");
        if (!googleChat.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        googleChat.setWebhook(GoogleChatAnnouncerValidator.checkProperty(context, "GOOGLE_CHAT_WEBHOOK", "announce.googleChat.webhook", googleChat.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)googleChat.getMessage()) && StringUtils.isBlank((String)googleChat.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_GOOGLE_CHAT_TPL), new LinkOption[0])) {
                googleChat.setMessageTemplate(DEFAULT_GOOGLE_CHAT_TPL);
            } else {
                googleChat.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)googleChat.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(googleChat.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"googleChat.messageTemplate", googleChat.getMessageTemplate()}));
        }
        GoogleChatAnnouncerValidator.validateTimeout(googleChat);
    }
}

