/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.version.CalVer;
import org.jreleaser.version.ChronVer;
import org.jreleaser.version.CustomVersion;
import org.jreleaser.version.JavaModuleVersion;
import org.jreleaser.version.JavaRuntimeVersion;
import org.jreleaser.version.SemanticVersion;
import org.jreleaser.version.Version;

public class VersionUtils {
    private static final UnparseableTags UNPARSEABLE_TAGS = new UnparseableTags();

    public static Pattern resolveVersionPattern(JReleaserContext context) {
        BaseReleaser<?, ?> gitService = context.getModel().getRelease().getReleaser();
        String tagName = gitService.getConfiguredTagName();
        Pattern vp = Pattern.compile(tagName.replaceAll("\\{\\{.*}}", "\\(\\.\\*\\)"));
        if (!tagName.contains("{{")) {
            vp = Pattern.compile("(.*)");
        }
        return vp;
    }

    public static void clearUnparseableTags() {
        UNPARSEABLE_TAGS.clear();
    }

    public static Version version(JReleaserContext context, String tagName, Pattern versionPattern) {
        return VersionUtils.version(context, tagName, versionPattern, false);
    }

    public static Version version(JReleaserContext context, String tagName, Pattern versionPattern, boolean strict) {
        switch (context.getModel().getProject().versionPattern().getType()) {
            case SEMVER: {
                return VersionUtils.semverOf(context.getLogger(), tagName, versionPattern, strict);
            }
            case JAVA_RUNTIME: {
                return VersionUtils.javaRuntimeVersionOf(context.getLogger(), tagName, versionPattern, strict);
            }
            case JAVA_MODULE: {
                return VersionUtils.javaModuleVersionOf(context.getLogger(), tagName, versionPattern, strict);
            }
            case CALVER: {
                return VersionUtils.calverOf(context, tagName, versionPattern, strict);
            }
            case CHRONVER: {
                return VersionUtils.chronVer(context.getLogger(), tagName, versionPattern, strict);
            }
        }
        return VersionUtils.versionOf(tagName, versionPattern, strict);
    }

    public static Version defaultVersion(JReleaserContext context) {
        switch (context.getModel().getProject().versionPattern().getType()) {
            case SEMVER: {
                return SemanticVersion.defaultOf();
            }
            case JAVA_RUNTIME: {
                return JavaRuntimeVersion.defaultOf();
            }
            case JAVA_MODULE: {
                return JavaModuleVersion.defaultOf();
            }
            case CALVER: {
                String format = context.getModel().getProject().versionPattern().getFormat();
                return CalVer.defaultOf((String)format);
            }
            case CHRONVER: {
                return ChronVer.defaultOf();
            }
        }
        return CustomVersion.defaultOf();
    }

    private static SemanticVersion semverOf(JReleaserLogger logger, String tagName, Pattern versionPattern, boolean strict) {
        String tag;
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            tag = matcher.group(1);
            try {
                return SemanticVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        if (!strict && tagName.startsWith("v")) {
            tag = tagName.substring(1);
            try {
                return SemanticVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        return SemanticVersion.defaultOf();
    }

    private static JavaRuntimeVersion javaRuntimeVersionOf(JReleaserLogger logger, String tagName, Pattern versionPattern, boolean strict) {
        String tag;
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            tag = matcher.group(1);
            try {
                return JavaRuntimeVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        if (!strict && tagName.startsWith("v")) {
            tag = tagName.substring(1);
            try {
                return JavaRuntimeVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        return JavaRuntimeVersion.defaultOf();
    }

    private static JavaModuleVersion javaModuleVersionOf(JReleaserLogger logger, String tagName, Pattern versionPattern, boolean strict) {
        String tag;
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            tag = matcher.group(1);
            try {
                return JavaModuleVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        if (!strict && tagName.startsWith("v")) {
            tag = tagName.substring(1);
            try {
                return JavaModuleVersion.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        return JavaModuleVersion.defaultOf();
    }

    private static CalVer calverOf(JReleaserContext context, String tagName, Pattern versionPattern, boolean strict) {
        String tag;
        String format = context.getModel().getProject().versionPattern().getFormat();
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            tag = matcher.group(1);
            try {
                return CalVer.of((String)format, (String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(context.getLogger(), tag, e);
            }
        }
        if (!strict && tagName.startsWith("v")) {
            tag = tagName.substring(1);
            try {
                return CalVer.of((String)format, (String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(context.getLogger(), tag, e);
            }
        }
        return CalVer.defaultOf((String)format);
    }

    private static ChronVer chronVer(JReleaserLogger logger, String tagName, Pattern versionPattern, boolean strict) {
        String tag;
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            tag = matcher.group(1);
            try {
                return ChronVer.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        if (!strict && tagName.startsWith("v")) {
            tag = tagName.substring(1);
            try {
                return ChronVer.of((String)tag);
            }
            catch (IllegalArgumentException e) {
                UNPARSEABLE_TAGS.unparseable(logger, tag, e);
            }
        }
        return ChronVer.defaultOf();
    }

    private static CustomVersion versionOf(String tagName, Pattern versionPattern, boolean strict) {
        Matcher matcher = versionPattern.matcher(tagName);
        if (matcher.matches()) {
            return CustomVersion.of((String)matcher.group(1));
        }
        return CustomVersion.defaultOf();
    }

    private static class UnparseableTags
    extends ThreadLocal<Set<String>> {
        private UnparseableTags() {
        }

        @Override
        protected Set<String> initialValue() {
            return new LinkedHashSet<String>();
        }

        public void clear() {
            ((Set)this.get()).clear();
        }

        public void unparseable(JReleaserLogger logger, String tag, Exception exception) {
            if (!((Set)this.get()).contains(tag)) {
                ((Set)this.get()).add(tag);
                logger.warn(exception.getMessage());
            }
        }
    }
}

