/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.model.internal.upload.SshUploader;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public abstract class AbstractSshUploader<A extends org.jreleaser.model.api.upload.SshUploader, S extends AbstractSshUploader<A, S>>
extends AbstractUploader<A, S>
implements SshUploader<A> {
    protected String username;
    protected String password;
    protected String host;
    protected Integer port;
    protected String knownHostsFile;
    protected String publicKey;
    protected String privateKey;
    protected String passphrase;
    protected String fingerprint;
    protected String path;
    protected String downloadUrl;

    public AbstractSshUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.username = this.merge(this.username, ((AbstractSshUploader)source).username);
        this.password = this.merge(this.password, ((AbstractSshUploader)source).password);
        this.host = this.merge(this.host, ((AbstractSshUploader)source).host);
        this.port = this.merge(this.port, ((AbstractSshUploader)source).port);
        this.knownHostsFile = this.merge(this.knownHostsFile, ((AbstractSshUploader)source).knownHostsFile);
        this.publicKey = this.merge(this.publicKey, ((AbstractSshUploader)source).publicKey);
        this.privateKey = this.merge(this.privateKey, ((AbstractSshUploader)source).privateKey);
        this.passphrase = this.merge(this.passphrase, ((AbstractSshUploader)source).passphrase);
        this.fingerprint = this.merge(this.fingerprint, ((AbstractSshUploader)source).fingerprint);
        this.path = this.merge(this.path, ((AbstractSshUploader)source).path);
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractSshUploader)source).downloadUrl);
    }

    @Override
    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        Map<String, Object> p = this.artifactProps(context.fullProps(), artifact);
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.path, p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    @Override
    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", StringUtils.isNotBlank((String)this.host) ? "************" : "**unset**");
        props.put("port", this.getPort());
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        props.put("knownHostsFile", this.knownHostsFile);
        props.put("publicKey", StringUtils.isNotBlank((String)this.publicKey) ? "************" : "**unset**");
        props.put("privateKey", StringUtils.isNotBlank((String)this.privateKey) ? "************" : "**unset**");
        props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
        props.put("fingerprint", StringUtils.isNotBlank((String)this.fingerprint) ? "************" : "**unset**");
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }
}

