/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class Assemble
extends AbstractModelObject<Assemble>
implements Domain,
Activatable {
    private final Map<String, ArchiveAssembler> archive = new LinkedHashMap<String, ArchiveAssembler>();
    private final Map<String, JavaArchiveAssembler> javaArchive = new LinkedHashMap<String, JavaArchiveAssembler>();
    private final Map<String, JlinkAssembler> jlink = new LinkedHashMap<String, JlinkAssembler>();
    private final Map<String, JpackageAssembler> jpackage = new LinkedHashMap<String, JpackageAssembler>();
    private final Map<String, NativeImageAssembler> nativeImage = new LinkedHashMap<String, NativeImageAssembler>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.assemble.Assemble immutable = new org.jreleaser.model.api.assemble.Assemble(){
        private Map<String, ? extends org.jreleaser.model.api.assemble.ArchiveAssembler> archive;
        private Map<String, ? extends org.jreleaser.model.api.assemble.JavaArchiveAssembler> javaArchive;
        private Map<String, ? extends org.jreleaser.model.api.assemble.JlinkAssembler> jlink;
        private Map<String, ? extends org.jreleaser.model.api.assemble.JpackageAssembler> jpackage;
        private Map<String, ? extends org.jreleaser.model.api.assemble.NativeImageAssembler> nativeImage;

        public Map<String, ? extends org.jreleaser.model.api.assemble.ArchiveAssembler> getArchive() {
            if (null == this.archive) {
                this.archive = Assemble.this.archive.values().stream().map(ArchiveAssembler::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.assemble.Assembler::getName, Function.identity()));
            }
            return this.archive;
        }

        public Map<String, ? extends org.jreleaser.model.api.assemble.JavaArchiveAssembler> getJavaArchive() {
            if (null == this.javaArchive) {
                this.javaArchive = Assemble.this.javaArchive.values().stream().map(JavaArchiveAssembler::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.assemble.Assembler::getName, Function.identity()));
            }
            return this.javaArchive;
        }

        public Map<String, ? extends org.jreleaser.model.api.assemble.JlinkAssembler> getJlink() {
            if (null == this.jlink) {
                this.jlink = Assemble.this.jlink.values().stream().map(JlinkAssembler::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.assemble.Assembler::getName, Function.identity()));
            }
            return this.jlink;
        }

        public Map<String, ? extends org.jreleaser.model.api.assemble.JpackageAssembler> getJpackage() {
            if (null == this.jpackage) {
                this.jpackage = Assemble.this.jpackage.values().stream().map(JpackageAssembler::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.assemble.Assembler::getName, Function.identity()));
            }
            return this.jpackage;
        }

        public Map<String, ? extends org.jreleaser.model.api.assemble.NativeImageAssembler> getNativeImage() {
            if (null == this.nativeImage) {
                this.nativeImage = Assemble.this.nativeImage.values().stream().map(NativeImageAssembler::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.assemble.Assembler::getName, Function.identity()));
            }
            return this.nativeImage;
        }

        public Active getActive() {
            return Assemble.this.active;
        }

        public boolean isEnabled() {
            return Assemble.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Assemble.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.assemble.Assemble asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Assemble source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setArchive(this.mergeModel(this.archive, source.archive));
        this.setJavaArchive(this.mergeModel(this.javaArchive, source.javaArchive));
        this.setJlink(this.mergeModel(this.jlink, source.jlink));
        this.setJpackage(this.mergeModel(this.jpackage, source.jpackage));
        this.setNativeImage(this.mergeModel(this.nativeImage, source.nativeImage));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"assemble.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        if (null != enabled) {
            this.active = enabled != false ? Active.ALWAYS : Active.NEVER;
        }
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"assemble.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public List<ArchiveAssembler> getActiveArchives() {
        return this.archive.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ArchiveAssembler> getArchive() {
        return this.archive;
    }

    public void setArchive(Map<String, ArchiveAssembler> archive) {
        this.archive.clear();
        this.archive.putAll(archive);
    }

    public void addArchive(ArchiveAssembler archive) {
        this.archive.put(archive.getName(), archive);
    }

    public List<JavaArchiveAssembler> getActiveJavaArchives() {
        return this.javaArchive.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, JavaArchiveAssembler> getJavaArchive() {
        return this.javaArchive;
    }

    public void setJavaArchive(Map<String, JavaArchiveAssembler> javaArchive) {
        this.javaArchive.clear();
        this.javaArchive.putAll(javaArchive);
    }

    public void addJavaArchive(JavaArchiveAssembler javaArchive) {
        this.javaArchive.put(javaArchive.getName(), javaArchive);
    }

    public List<JlinkAssembler> getActiveJlinks() {
        return this.jlink.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, JlinkAssembler> getJlink() {
        return this.jlink;
    }

    public void setJlink(Map<String, JlinkAssembler> jlink) {
        this.jlink.clear();
        this.jlink.putAll(jlink);
    }

    public void addJlink(JlinkAssembler jlink) {
        this.jlink.put(jlink.getName(), jlink);
    }

    public JlinkAssembler findJlink(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Jlink name must not be blank");
        }
        if (this.jlink.containsKey(name)) {
            return this.jlink.get(name);
        }
        throw new JReleaserException("Jlink '" + name + "' not found");
    }

    public List<JpackageAssembler> getActiveJpackages() {
        return this.jpackage.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, JpackageAssembler> getJpackage() {
        return this.jpackage;
    }

    public void setJpackage(Map<String, JpackageAssembler> jpackage) {
        this.jpackage.clear();
        this.jpackage.putAll(jpackage);
    }

    public void addJpackage(JpackageAssembler jpackage) {
        this.jpackage.put(jpackage.getName(), jpackage);
    }

    public List<NativeImageAssembler> getActiveNativeImages() {
        return this.nativeImage.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, NativeImageAssembler> getNativeImage() {
        return this.nativeImage;
    }

    public void setNativeImage(Map<String, NativeImageAssembler> nativeImage) {
        this.nativeImage.clear();
        this.nativeImage.putAll(nativeImage);
    }

    public void addNativeImage(NativeImageAssembler nativeImage) {
        this.nativeImage.put(nativeImage.getName(), nativeImage);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List nativeImage;
        List jpackage;
        List jlink;
        List javaArchive;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        List archive = this.archive.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!archive.isEmpty()) {
            map.put("archive", archive);
        }
        if (!(javaArchive = this.javaArchive.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("javaArchive", javaArchive);
        }
        if (!(jlink = this.jlink.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("jlink", jlink);
        }
        if (!(jpackage = this.jpackage.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("jpackage", jpackage);
        }
        if (!(nativeImage = this.nativeImage.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("nativeImage", nativeImage);
        }
        return map;
    }

    public <A extends Assembler> Map<String, A> findAssemblersByType(String assemblerName) {
        switch (assemblerName) {
            case "archive": {
                return this.archive;
            }
            case "java-archive": {
                return this.javaArchive;
            }
            case "jlink": {
                return this.jlink;
            }
            case "jpackage": {
                return this.jpackage;
            }
            case "native-image": {
                return this.nativeImage;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Assembler> Collection<A> findAllAssemblers() {
        ArrayList<AbstractAssembler> assemblers = new ArrayList<AbstractAssembler>();
        assemblers.addAll(this.getActiveArchives());
        assemblers.addAll(this.getActiveJavaArchives());
        assemblers.addAll(this.getActiveJlinks());
        assemblers.addAll(this.getActiveJpackages());
        assemblers.addAll(this.getActiveNativeImages());
        return assemblers;
    }
}

