/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class ZulipAnnouncer
extends AbstractAnnouncer<ZulipAnnouncer, org.jreleaser.model.api.announce.ZulipAnnouncer> {
    private String account;
    private String apiKey;
    private String apiHost;
    private String channel;
    private String subject;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.ZulipAnnouncer immutable = new org.jreleaser.model.api.announce.ZulipAnnouncer(){

        public String getType() {
            return "zulip";
        }

        public String getAccount() {
            return ZulipAnnouncer.this.account;
        }

        public String getApiKey() {
            return ZulipAnnouncer.this.apiKey;
        }

        public String getApiHost() {
            return ZulipAnnouncer.this.apiHost;
        }

        public String getChannel() {
            return ZulipAnnouncer.this.channel;
        }

        public String getSubject() {
            return ZulipAnnouncer.this.subject;
        }

        public String getMessage() {
            return ZulipAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return ZulipAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return ZulipAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return ZulipAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return ZulipAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return ZulipAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ZulipAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return ZulipAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ZulipAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return ZulipAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return ZulipAnnouncer.this.readTimeout;
        }
    };

    public ZulipAnnouncer() {
        super("zulip");
    }

    @Override
    public org.jreleaser.model.api.announce.ZulipAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ZulipAnnouncer source) {
        super.merge(source);
        this.account = this.merge(this.account, source.account);
        this.apiKey = this.merge(this.apiKey, source.apiKey);
        this.apiHost = this.merge(this.apiHost, source.apiHost);
        this.channel = this.merge(this.channel, source.channel);
        this.subject = this.merge(this.subject, source.subject);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedSubject(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.subject, props);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("account", this.account);
        props.put("apiKey", StringUtils.isNotBlank((String)this.apiKey) ? "************" : "**unset**");
        props.put("apiHost", this.apiHost);
        props.put("channel", this.channel);
        props.put("subject", this.subject);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

