/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.GiteaReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.release.BaseReleaserValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GiteaReleaserValidator {
    private GiteaReleaserValidator() {
    }

    public static boolean validateGitea(JReleaserContext context, JReleaserContext.Mode mode, GiteaReleaser service, Errors errors) {
        if (null == service) {
            return false;
        }
        context.getLogger().debug("release.gitea");
        BaseReleaserValidator.validateGitService(context, mode, service, errors);
        if (StringUtils.isBlank((String)service.getApiEndpoint())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"gitea.apiEndpoint"}));
        }
        if (context.getModel().getProject().isSnapshot()) {
            service.getPrerelease().setEnabled(true);
        }
        service.getPrerelease().setPattern(Validator.checkProperty(context, "PRERELEASE_PATTERN", "release.gitea.prerelease.pattern", service.getPrerelease().getPattern(), ""));
        service.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        if (!service.isDraftSet()) {
            service.setDraft(Validator.checkProperty(context, "DRAFT", "release.gitea.draft", null, false));
        }
        if (!service.getUpdate().isEnabled()) {
            if (!service.getPrerelease().isEnabledSet()) {
                service.getPrerelease().setEnabled(false);
            }
            if (!service.isDraftSet()) {
                service.setDraft(false);
            }
        }
        if (service.isDraft()) {
            service.getMilestone().setClose(false);
        }
        return service.isEnabled();
    }
}

