/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssemblerResolver {
    private NativeImageAssemblerResolver() {
    }

    public static void resolveNativeImageOutputs(JReleaserContext context, Errors errors) {
        List<NativeImageAssembler> activeNativeImages = context.getModel().getAssemble().getActiveNativeImages();
        if (!activeNativeImages.isEmpty()) {
            context.getLogger().debug("assemble.nativeImage");
        }
        for (NativeImageAssembler nativeImage : activeNativeImages) {
            if (!nativeImage.isExported()) continue;
            NativeImageAssemblerResolver.resolveNativeImageOutputs(context, nativeImage, errors);
        }
    }

    public static void resolveNativeImageOutputs(JReleaserContext context, NativeImageAssembler assembler, Errors errors) {
        if (!assembler.isEnabled() || !context.isDistributionSelected(assembler.getName())) {
            return;
        }
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String imageName = assembler.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)assembler.getImageNameTransform())) {
            imageName = assembler.getResolvedImageNameTransform(context);
        }
        for (Artifact graalJdk : assembler.getGraalJdks()) {
            Path image;
            if (!graalJdk.isActiveAndSelected()) continue;
            String platform = graalJdk.getPlatform();
            String platformReplaced = assembler.getPlatform().applyReplacements(platform);
            if (assembler.getArchiving().isEnabled()) {
                String str = graalJdk.getExtraProperties().getOrDefault("archiveFormat", assembler.getArchiving().getFormat()).toString();
                Archive.Format archiveFormat = Archive.Format.of((String)str);
                Path image2 = baseOutputDirectory.resolve(imageName + "-" + platformReplaced + "." + archiveFormat.extension()).toAbsolutePath();
                if (!Files.exists(image2, new LinkOption[0])) {
                    errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                    continue;
                }
                Artifact artifact = Artifact.of(image2, platform);
                artifact.resolveActiveAndSelected(context);
                artifact.setExtraProperties(assembler.getExtraProperties());
                assembler.addOutput(artifact);
                continue;
            }
            String finalImageName = imageName + "-" + platformReplaced;
            if (PlatformUtils.isWindows((String)platform)) {
                finalImageName = finalImageName + FileType.EXE.extension();
            }
            if (!Files.exists(image = baseOutputDirectory.resolve(finalImageName).toAbsolutePath(), new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                errors.assembly(context.relativizeToBasedir(image.toAbsolutePath()).toString());
                continue;
            }
            Artifact artifact = Artifact.of(image, platform);
            artifact.resolveActiveAndSelected(context);
            artifact.setExtraProperties(assembler.getExtraProperties());
            assembler.addOutput(artifact);
        }
    }
}

