/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.api.packagers.JibConfiguration;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.packagers.JibConfiguration;
import org.jreleaser.util.StringUtils;

public abstract class AbstractJibConfiguration<S extends AbstractJibConfiguration<S>>
extends AbstractActivatable<S>
implements JibConfiguration,
ExtraProperties {
    private static final long serialVersionUID = 1610025836172412213L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Map<String, String> labels = new LinkedHashMap<String, String>();
    private final Set<String> imageNames = new LinkedHashSet<String>();
    private final Set<String> volumes = new LinkedHashSet<String>();
    private final Set<String> exposedPorts = new LinkedHashSet<String>();
    private final Set<JibConfiguration.Registry> registries = new LinkedHashSet<JibConfiguration.Registry>();
    private final List<String> skipTemplates = new ArrayList<String>();
    private String templateDirectory;
    private String baseImage;
    private String creationTime;
    private String workingDirectory;
    private String user;
    private JibConfiguration.Format format;

    @Override
    public void merge(S source) {
        super.merge(source);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractJibConfiguration)source).getTemplateDirectory());
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractJibConfiguration)source).getSkipTemplates()));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractJibConfiguration)source).getExtraProperties()));
        this.baseImage = this.merge(this.baseImage, ((AbstractJibConfiguration)source).getBaseImage());
        this.creationTime = this.merge(this.creationTime, ((AbstractJibConfiguration)source).getCreationTime());
        this.workingDirectory = this.merge(this.workingDirectory, ((AbstractJibConfiguration)source).getWorkingDirectory());
        this.user = this.merge(this.user, ((AbstractJibConfiguration)source).getUser());
        this.format = this.merge(this.format, ((AbstractJibConfiguration)source).getFormat());
        this.setImageNames(this.merge(this.imageNames, ((AbstractJibConfiguration)source).getImageNames()));
        this.setVolumes(this.merge(this.volumes, ((AbstractJibConfiguration)source).getVolumes()));
        this.setExposedPorts(this.merge(this.exposedPorts, ((AbstractJibConfiguration)source).getExposedPorts()));
        this.setEnvironment(this.merge(this.environment, ((AbstractJibConfiguration)source).getEnvironment()));
        this.setLabels(this.merge(this.labels, ((AbstractJibConfiguration)source).getLabels()));
        this.setRegistries(this.merge(this.registries, ((AbstractJibConfiguration)source).getRegistries()));
    }

    @Override
    public String prefix() {
        return "jib";
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.skipTemplates;
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public JibConfiguration.Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(JibConfiguration.Format format) {
        this.format = format;
    }

    @Override
    public void setFormat(String format) {
        this.format = JibConfiguration.Format.of((String)format);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public void addEnvironment(Map<String, String> environment) {
        this.environment.putAll(environment);
    }

    @Override
    public void addEnvironment(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.environment.put(key, value);
        }
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        this.labels.clear();
        this.labels.putAll(labels);
    }

    @Override
    public void addLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
    }

    @Override
    public void addLabel(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.labels.put(key, value);
        }
    }

    @Override
    public Set<String> getImageNames() {
        return this.imageNames;
    }

    @Override
    public void setImageNames(Set<String> imageNames) {
        if (null != imageNames) {
            this.imageNames.clear();
            this.imageNames.addAll(imageNames);
        }
    }

    @Override
    public void addImageName(String imageName) {
        if (StringUtils.isNotBlank((String)imageName)) {
            this.imageNames.add(imageName);
        }
    }

    @Override
    public Set<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public void setVolumes(Set<String> volumes) {
        if (null != volumes) {
            this.volumes.clear();
            this.volumes.addAll(volumes);
        }
    }

    @Override
    public void addVolumes(Set<String> volumes) {
        if (null != volumes) {
            this.volumes.addAll(volumes);
        }
    }

    @Override
    public void addVolume(String volume) {
        if (null != volume) {
            this.volumes.add(volume);
        }
    }

    @Override
    public Set<String> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void setExposedPorts(Set<String> exposedPorts) {
        if (null != exposedPorts) {
            this.exposedPorts.clear();
            this.exposedPorts.addAll(exposedPorts);
        }
    }

    @Override
    public void addExposedPorts(Set<String> exposedPorts) {
        if (null != exposedPorts) {
            this.exposedPorts.addAll(exposedPorts);
        }
    }

    @Override
    public void addExposedPort(String exposedPort) {
        if (null != exposedPort) {
            this.exposedPorts.add(exposedPort);
        }
    }

    public Set<JibConfiguration.Registry> getRegistries() {
        return this.registries;
    }

    @Override
    public void setRegistries(Set<? extends JibConfiguration.Registry> registries) {
        if (null != registries) {
            this.registries.clear();
            this.registries.addAll(registries);
        }
    }

    @Override
    public void addRegistry(JibConfiguration.Registry registry) {
        if (null != registry) {
            this.registries.add(registry);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
        props.put("baseImage", this.baseImage);
        props.put("imageNames", this.imageNames);
        props.put("creationTime", this.creationTime);
        props.put("format", this.format);
        props.put("workingDirectory", this.workingDirectory);
        props.put("user", this.user);
        props.put("environment", this.environment);
        props.put("labels", this.labels);
        props.put("volumes", this.volumes);
        props.put("exposedPorts", this.exposedPorts);
        this.asMap(full, props);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (JibConfiguration.Registry registry : this.registries) {
            m.put("registry " + i++, registry.asMap(full));
        }
        props.put("registries", m);
        props.put("extraProperties", this.getExtraProperties());
        return props;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

