/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.deploy.maven;

import java.util.Locale;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.deploy.maven.MavenDeployer;
import org.jreleaser.util.StringUtils;

public interface Nexus2MavenDeployer
extends MavenDeployer {
    public static final String TYPE = "nexus2";
    public static final String START_STAGE = "start.stage";
    public static final String END_STAGE = "end.stage";
    public static final String STAGING_PROFILE_ID = "staging.profile.id";
    public static final String STAGING_REPOSITORY_ID = "staging.repository.id";

    public String getSnapshotUrl();

    public boolean isCloseRepository();

    public boolean isReleaseRepository();

    public Integer getTransitionDelay();

    public Integer getTransitionMaxRetries();

    public static enum StageOperation {
        FULL_DEPLOYMENT,
        UPLOAD,
        UPLOAD_AND_CLOSE,
        CLOSE,
        CLOSE_AND_RELEASE,
        RELEASE;


        public static StageOperation of(Stage start, Stage end) {
            if (null == start) {
                if (end == Stage.UPLOAD) {
                    return UPLOAD;
                }
                if (end == Stage.CLOSE) {
                    return UPLOAD_AND_CLOSE;
                }
                return FULL_DEPLOYMENT;
            }
            if (Stage.UPLOAD == start) {
                if (null == end) {
                    return FULL_DEPLOYMENT;
                }
                switch (end) {
                    case UPLOAD: {
                        return UPLOAD;
                    }
                    case CLOSE: {
                        return UPLOAD_AND_CLOSE;
                    }
                    case RELEASE: {
                        return FULL_DEPLOYMENT;
                    }
                }
            }
            if (Stage.CLOSE == start) {
                if (null == end) {
                    return CLOSE_AND_RELEASE;
                }
                switch (end) {
                    case UPLOAD: {
                        throw new IllegalArgumentException(RB.$((String)"ERROR_nexus_stage", (Object[])new Object[]{start, end}));
                    }
                    case CLOSE: {
                        return CLOSE;
                    }
                    case RELEASE: {
                        return CLOSE_AND_RELEASE;
                    }
                }
            }
            if (Stage.RELEASE == start) {
                if (null == end) {
                    return RELEASE;
                }
                switch (end) {
                    case UPLOAD: 
                    case CLOSE: {
                        throw new IllegalArgumentException(RB.$((String)"ERROR_nexus_stage", (Object[])new Object[]{start, end}));
                    }
                    case RELEASE: {
                        return RELEASE;
                    }
                }
            }
            return FULL_DEPLOYMENT;
        }
    }

    public static enum Stage {
        UPLOAD,
        CLOSE,
        RELEASE;


        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Stage of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Stage.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

