/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin.internal;

import java.io.PrintWriter;
import org.apache.maven.plugin.logging.Log;
import org.jreleaser.logging.AbstractJReleaserLogger;
import org.slf4j.helpers.MessageFormatter;

public class JReleaserLoggerAdapter
extends AbstractJReleaserLogger {
    private final Log delegate;

    public JReleaserLoggerAdapter(PrintWriter tracer, Log delegate) {
        super(tracer);
        this.delegate = delegate;
    }

    public void plain(String message) {
        String msg = this.formatMessage(message);
        this.delegate.info((CharSequence)msg);
        this.trace(msg);
    }

    public void debug(String message) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(message);
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.debug((CharSequence)msg1);
        this.trace((Object)((Object)Level.DEBUG) + msg2);
    }

    public void info(String message) {
        String msg = this.formatMessage(message);
        this.delegate.info((CharSequence)msg);
        this.trace((Object)((Object)Level.INFO) + msg);
    }

    public void warn(String message) {
        String msg = this.formatMessage(message);
        this.delegate.warn((CharSequence)msg);
        this.trace((Object)((Object)Level.WARN) + msg);
    }

    public void error(String message) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(message);
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.error((CharSequence)msg1);
        this.trace((Object)((Object)Level.ERROR) + msg2);
    }

    public void plain(String message, Object ... args) {
        this.plain(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
    }

    public void debug(String message, Object ... args) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.debug((CharSequence)msg1);
        this.trace((Object)((Object)Level.DEBUG) + msg2);
    }

    public void info(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        this.delegate.info((CharSequence)msg);
        this.trace((Object)((Object)Level.INFO) + msg);
    }

    public void warn(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        this.delegate.warn((CharSequence)msg);
        this.trace((Object)((Object)Level.WARN) + msg);
    }

    public void error(String message, Object ... args) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.error((CharSequence)msg1);
        this.trace((Object)((Object)Level.ERROR) + msg2);
    }

    public void plain(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        this.delegate.info((CharSequence)msg, throwable);
        this.trace(msg, throwable);
    }

    public void debug(String message, Throwable throwable) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(message);
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.debug((CharSequence)msg1, throwable);
        this.trace((Object)((Object)Level.DEBUG) + msg2, throwable);
    }

    public void info(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        this.delegate.info((CharSequence)msg, throwable);
        this.trace((Object)((Object)Level.INFO) + msg, throwable);
    }

    public void warn(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        this.delegate.warn((CharSequence)msg, throwable);
        this.trace((Object)((Object)Level.WARN) + msg, throwable);
    }

    public void error(String message, Throwable throwable) {
        String msg1;
        String msg2 = msg1 = this.formatMessage(message);
        if (this.isIndented()) {
            msg1 = msg1.substring(1);
        }
        this.delegate.error((CharSequence)msg1, throwable);
        this.trace((Object)((Object)Level.ERROR) + msg2, throwable);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public String toString() {
            return "[" + this.name() + "] " + (this.name().length() == 4 ? " " : "");
        }
    }
}

