/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.engine.context.ModelAutoConfigurer;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.IoUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.workflow.Workflows;

@Mojo(name="auto-config-release")
public class JReleaserAutoConfigReleaseMojo
extends AbstractMojo {
    @Parameter(property="jreleaser.project.snapshot.full.changelog")
    boolean projectSnapshotFullChangelog;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="jreleaser.output.directory", defaultValue="${project.build.directory}/jreleaser")
    private File outputDirectory;
    @Parameter(property="jreleaser.dry.run")
    private Boolean dryrun;
    @Parameter(property="jreleaser.git.root.search")
    private Boolean gitRootSearch;
    @Parameter(property="jreleaser.strict")
    private Boolean strict;
    @Parameter(property="jreleaser.project.name", defaultValue="${project.artifactId}")
    private String projectName;
    @Parameter(property="jreleaser.project.version", defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(property="jreleaser.project.version.pattern")
    private String projectVersionPattern;
    @Parameter(property="jreleaser.project.snapshot.pattern")
    private String projectSnapshotPattern;
    @Parameter(property="jreleaser.project.snapshot.label")
    private String projectSnapshotLabel;
    @Parameter(property="jreleaser.project.copyright")
    private String projectCopyright;
    @Parameter(property="jreleaser.project.description")
    private String projectDescription;
    @Parameter(property="jreleaser.project.inception.year")
    private String projectInceptionYear;
    @Parameter(property="jreleaser.project.stereotype")
    private String projectStereotype;
    @Parameter(property="jreleaser.tag.name")
    private String tagName;
    @Parameter(property="jreleaser.previous.tag.name")
    private String previousTagName;
    @Parameter(property="jreleaser.release.name")
    private String releaseName;
    @Parameter(property="jreleaser.release.branch")
    private String branch;
    @Parameter(property="jreleaser.milestone.name")
    private String milestoneName;
    @Parameter(property="jreleaser.prerelease")
    private Boolean prerelease;
    @Parameter(property="jreleaser.prerelease.pattern")
    private String prereleasePattern;
    @Parameter(property="jreleaser.draft")
    private Boolean draft;
    @Parameter(property="jreleaser.overwrite")
    private boolean overwrite;
    @Parameter(property="jreleaser.update")
    private boolean update;
    @Parameter(property="jreleaser.update.sections")
    private UpdateSection[] updateSections;
    @Parameter(property="jreleaser.skip.tag")
    private boolean skipTag;
    @Parameter(property="jreleaser.skip.release")
    private boolean skipRelease;
    @Parameter(property="jreleaser.skip.checksums")
    private boolean skipChecksums;
    @Parameter(property="jreleaser.changelog")
    private String changelog;
    @Parameter(property="jreleaser.changelog.formatted")
    private boolean changelogFormatted;
    @Parameter(property="jreleaser.username")
    private String username;
    @Parameter(property="jreleaser.commit.author.name")
    private String commitAuthorName;
    @Parameter(property="jreleaser.commit.author.email")
    private String commitAuthorEmail;
    @Parameter(property="jreleaser.signing")
    private boolean signing;
    @Parameter(property="jreleaser.armored")
    private boolean armored;
    @Parameter(property="jreleaser.authors")
    private String[] authors;
    @Parameter(property="jreleaser.files")
    private String[] files;
    @Parameter(property="jreleaser.globs")
    private String[] globs;
    @Parameter(property="jreleaser.select.current.platform")
    private boolean selectCurrentPlatform;
    @Parameter(property="jreleaser.select.platforms")
    private String[] selectPlatforms;
    @Parameter(property="jreleaser.reject.platforms")
    private String[] rejectedPlatforms;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        JReleaserContext context = ModelAutoConfigurer.builder().logger(this.getLogger()).basedir(this.project.getBasedir().toPath()).outputDirectory(this.outputDirectory.toPath()).dryrun(this.dryrun).gitRootSearch(this.gitRootSearch).strict(this.strict).projectName(this.projectName).projectVersion(this.projectVersion).projectVersionPattern(this.projectVersionPattern).projectSnapshotPattern(this.projectSnapshotPattern).projectSnapshotLabel(this.projectSnapshotLabel).projectSnapshotFullChangelog(this.projectSnapshotFullChangelog).projectCopyright(this.projectCopyright).projectDescription(this.projectDescription).projectInceptionYear(this.projectInceptionYear).projectStereotype(this.projectStereotype).tagName(this.tagName).previousTagName(this.previousTagName).releaseName(this.releaseName).branch(this.branch).milestoneName(this.milestoneName).prerelease(this.prerelease).prereleasePattern(this.prereleasePattern).draft(this.draft).overwrite(this.overwrite).update(this.update).updateSections(this.collectUpdateSections()).skipTag(this.skipTag).skipRelease(this.skipRelease).skipChecksums(this.skipChecksums).changelog(this.changelog).changelogFormatted(this.changelogFormatted).username(this.username).commitAuthorName(this.commitAuthorName).commitAuthorEmail(this.commitAuthorEmail).signing(this.signing).armored(this.armored).authors(this.collectAuthors()).files(this.collectFiles()).globs(this.collectGlobs()).selectedPlatforms(this.collectSelectedPlatforms()).rejectedPlatforms(this.collectRejectedPlatforms()).autoConfigure();
        Workflows.release((JReleaserContext)context).execute();
    }

    private JReleaserLogger getLogger() throws MojoExecutionException {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    private PrintWriter createTracer() throws MojoExecutionException {
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            return IoUtils.newPrintWriter((OutputStream)new FileOutputStream(this.outputDirectory.toPath().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize trace file", (Exception)e);
        }
    }

    private List<String> collectAuthors() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.authors && this.authors.length > 0) {
            Collections.addAll(list, this.authors);
        }
        return list;
    }

    private List<String> collectFiles() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.files && this.files.length > 0) {
            Collections.addAll(list, this.files);
        }
        return list;
    }

    private List<String> collectGlobs() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.globs && this.globs.length > 0) {
            Collections.addAll(list, this.globs);
        }
        return list;
    }

    private Set<UpdateSection> collectUpdateSections() {
        LinkedHashSet<UpdateSection> set = new LinkedHashSet<UpdateSection>();
        if (null != this.updateSections && this.updateSections.length > 0) {
            for (UpdateSection updateSection : this.updateSections) {
                set.add(UpdateSection.of((String)updateSection.name()));
            }
        }
        return set;
    }

    protected List<String> collectSelectedPlatforms() {
        boolean resolvedSelectCurrentPlatform = this.resolveBoolean("SELECT_CURRENT_PLATFORM", this.selectCurrentPlatform);
        if (resolvedSelectCurrentPlatform) {
            return Collections.singletonList(PlatformUtils.getCurrentFull());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.selectPlatforms && this.selectPlatforms.length > 0) {
            Collections.addAll(list, this.selectPlatforms);
        }
        return this.resolveCollection("SELECT_PLATFORMS", list);
    }

    protected List<String> collectRejectedPlatforms() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.rejectedPlatforms && this.rejectedPlatforms.length > 0) {
            Collections.addAll(list, this.rejectedPlatforms);
        }
        return this.resolveCollection("REJECT_PLATFORMS", list);
    }

    protected boolean resolveBoolean(String key, Boolean value) {
        if (null != value) {
            return value;
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        return StringUtils.isNotBlank((String)resolvedValue) && Boolean.parseBoolean(resolvedValue);
    }

    protected List<String> resolveCollection(String key, List<String> values) {
        if (!values.isEmpty()) {
            return values;
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        if (StringUtils.isBlank((String)resolvedValue)) {
            return Collections.emptyList();
        }
        return Arrays.stream(resolvedValue.trim().split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }
}

