/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.maven.plugin.AbstractPlatformAwareJReleaserMojo;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;

@Mojo(name="package")
public class JReleaserPackageMojo
extends AbstractPlatformAwareJReleaserMojo {
    @Parameter(property="jreleaser.packagers")
    private String[] includedPackagers;
    @Parameter(property="jreleaser.excluded.packagers")
    private String[] excludedPackagers;
    @Parameter(property="jreleaser.distributions")
    private String[] includedDistributions;
    @Parameter(property="jreleaser.excluded.distributions")
    private String[] excludedDistributions;
    @Parameter(property="jreleaser.package.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        JReleaserContext context = this.createContext();
        context.setIncludedPackagers(this.collectEntries(this.includedPackagers, true));
        context.setIncludedDistributions(this.collectEntries(this.includedDistributions));
        context.setExcludedPackagers(this.collectEntries(this.excludedPackagers, true));
        context.setExcludedDistributions(this.collectEntries(this.excludedDistributions));
        Workflows.packageRelease((JReleaserContext)context).execute();
    }
}

