/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.maven.plugin.AbstractPlatformAwareJReleaserMojo;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;

@Mojo(name="deploy")
public class JReleaserDeployMojo
extends AbstractPlatformAwareJReleaserMojo {
    @Parameter(property="jreleaser.deployers")
    private String[] includedDeployers;
    @Parameter(property="jreleaser.excluded.deployers")
    private String[] excludedDeployers;
    @Parameter(property="jreleaser.deployer.names")
    private String[] includedDeployerNames;
    @Parameter(property="jreleaser.excluded.deployer.names")
    private String[] excludedDeployerNames;
    @Parameter(property="jreleaser.deploy.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        JReleaserContext context = this.createContext();
        context.setIncludedDeployerTypes(this.collectEntries(this.includedDeployers, true));
        context.setIncludedDeployerNames(this.collectEntries(this.includedDeployerNames));
        context.setExcludedDeployerTypes(this.collectEntries(this.excludedDeployers, true));
        context.setExcludedDeployerNames(this.collectEntries(this.excludedDeployerNames));
        Workflows.deploy((JReleaserContext)context).execute();
    }
}

