/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.StringUtils;

public final class JReleaserModelConfigurer {
    private JReleaserModelConfigurer() {
    }

    public static JReleaserModel configure(JReleaserModel model, MavenProject mavenProject, MavenSession session) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        properties.putAll((Map<?, ?>)session.getUserProperties());
        Environment.PropertiesPropertiesSource propertiesSource = new Environment.PropertiesPropertiesSource(properties);
        model.getEnvironment().setPropertiesSource((Environment.PropertiesSource)propertiesSource);
        JReleaserModelConfigurer.configureProject(model.getProject(), mavenProject, session);
        return model;
    }

    private static void configureProject(Project project, MavenProject mavenProject, MavenSession session) {
        License license;
        if (StringUtils.isBlank((String)project.getName())) {
            project.setName(mavenProject.getArtifactId());
        }
        if (StringUtils.isBlank((String)project.getVersion())) {
            project.setVersion(mavenProject.getVersion());
        }
        if (StringUtils.isBlank((String)project.getDescription())) {
            project.setDescription(mavenProject.getDescription());
        }
        if (StringUtils.isBlank((String)project.getLinks().getHomepage())) {
            project.getLinks().setHomepage(mavenProject.getUrl());
        }
        if (StringUtils.isBlank((String)project.getLinks().getHomepage()) && null != mavenProject.getOrganization()) {
            project.getLinks().setHomepage(mavenProject.getOrganization().getUrl());
        }
        if (project.getAuthors().isEmpty()) {
            project.setAuthors(JReleaserModelConfigurer.resolveAuthors(mavenProject.getDevelopers()));
        }
        if (StringUtils.isBlank((String)project.getLicense()) && null != (license = JReleaserModelConfigurer.resolveLicense(mavenProject.getLicenses()))) {
            project.setLicense(license.getName());
            project.getLinks().setLicense(license.getUrl());
        }
        if (StringUtils.isBlank((String)project.getInceptionYear()) && StringUtils.isNotBlank((String)mavenProject.getInceptionYear())) {
            project.setInceptionYear(mavenProject.getInceptionYear());
        }
        Java java = project.getLanguages().getJava();
        java.setGroupId(mavenProject.getGroupId());
        java.setArtifactId(mavenProject.getArtifactId());
        if (StringUtils.isBlank((String)java.getVersion())) {
            java.setVersion(JReleaserModelConfigurer.resolveJavaVersion(mavenProject));
        }
        if (!java.isMultiProjectSet()) {
            java.setMultiProject(Boolean.valueOf(session.getAllProjects().size() > 1));
        }
    }

    private static List<String> resolveAuthors(List<Developer> developers) {
        if (null == developers || developers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> authors = new ArrayList<String>();
        for (Developer developer : developers) {
            List roles = developer.getRoles();
            if (null == roles || !roles.stream().anyMatch("author"::equalsIgnoreCase)) continue;
            String name = developer.getName();
            if (StringUtils.isBlank((String)name)) {
                name = developer.getId();
            }
            if (!StringUtils.isNotBlank((String)name)) continue;
            authors.add(name);
        }
        if (authors.isEmpty()) {
            for (Developer developer : developers) {
                String name = developer.getName();
                if (StringUtils.isBlank((String)name)) {
                    name = developer.getId();
                }
                if (!StringUtils.isNotBlank((String)name)) continue;
                authors.add(name);
            }
        }
        return authors;
    }

    private static License resolveLicense(List<License> licenses) {
        if (null == licenses || licenses.isEmpty()) {
            return null;
        }
        for (License license : licenses) {
            if (!StringUtils.isNotBlank((String)license.getName())) continue;
            return license;
        }
        return null;
    }

    private static String resolveJavaVersion(MavenProject mavenProject) {
        String javaVersion = System.getProperty("java.version");
        Properties properties = mavenProject.getProperties();
        if (null != properties && !properties.isEmpty()) {
            if (properties.containsKey("maven.compiler.release")) {
                javaVersion = properties.getProperty("maven.compiler.release");
            } else if (properties.containsKey("maven.compiler.target")) {
                javaVersion = properties.getProperty("maven.compiler.target");
            } else if (properties.containsKey("maven.compiler.source")) {
                javaVersion = properties.getProperty("maven.compiler.source");
            }
        }
        return JReleaserModelConfigurer.resolveJavaVersion(javaVersion);
    }

    private static String resolveJavaVersion(String str) {
        if (str.startsWith("1.")) {
            return "8";
        }
        return str.split("\\.")[0];
    }
}

