/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.download;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.download.ArtifactDownloaders;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.downloader.spi.ArtifactDownloader;
import org.jreleaser.model.downloader.spi.DownloadException;

public class ProjectDownloader {
    private final JReleaserContext context;
    private final Downloader downloader;

    private ProjectDownloader(JReleaserContext context, Downloader downloader) {
        this.context = context;
        this.downloader = downloader;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public void download() throws DownloadException {
        if (!this.downloader.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"downloaders.skip.download", (Object[])new Object[0]), new Object[]{this.downloader.getName()});
            return;
        }
        ArtifactDownloader<Downloader> artifactDownloader = ArtifactDownloaders.findDownloader(this.context, this.downloader);
        this.context.getLogger().info(RB.$((String)"downloaders.download", (Object[])new Object[0]), new Object[]{this.downloader.getName()});
        artifactDownloader.download(this.downloader.getName());
    }

    public static ProjectDownloaderBuilder builder() {
        return new ProjectDownloaderBuilder();
    }

    public static class ProjectDownloaderBuilder {
        private JReleaserContext context;
        private Downloader downloader;

        public ProjectDownloaderBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public ProjectDownloaderBuilder downloader(Downloader downloader) {
            this.downloader = Objects.requireNonNull(downloader, "'downloader' must not be null");
            return this;
        }

        public ProjectDownloader build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.downloader, "'downloader' must not be null");
            return new ProjectDownloader(this.context, this.downloader);
        }
    }
}

