/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.download;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.download.ProjectDownloader;
import org.jreleaser.model.Download;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.downloader.spi.DownloadException;
import org.jreleaser.util.JReleaserException;

public class Downloaders {
    public static void download(JReleaserContext context) {
        Download download = context.getModel().getDownload();
        if (!download.isEnabled()) {
            context.getLogger().info(RB.$((String)"downloaders.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getIncludedDownloaderTypes().isEmpty()) {
            for (String downloaderType : context.getIncludedDownloaderTypes()) {
                if (!Download.supportedDownloaders().contains(downloaderType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_downloader", (Object[])new Object[]{downloaderType}));
                    continue;
                }
                Map downloaders = download.findDownloadersByType(downloaderType);
                if (downloaders.isEmpty()) {
                    context.getLogger().debug(RB.$((String)"downloaders.no.match", (Object[])new Object[0]), new Object[]{downloaderType});
                    return;
                }
                if (!context.getIncludedDownloaderNames().isEmpty()) {
                    for (String downloaderName : context.getIncludedDownloaderNames()) {
                        if (!downloaders.containsKey(downloaderName)) {
                            context.getLogger().warn(RB.$((String)"downloaders.downloader.not.configured", (Object[])new Object[0]), new Object[]{downloaderType, downloaderName});
                            continue;
                        }
                        Downloader downloader2 = (Downloader)downloaders.get(downloaderName);
                        if (!downloader2.isEnabled()) {
                            context.getLogger().info(RB.$((String)"downloaders.downloader.disabled", (Object[])new Object[0]), new Object[]{downloaderType, downloaderName});
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"downloaders.download.with", (Object[])new Object[0]), new Object[]{downloaderType, downloaderName});
                        Downloaders.download(context, downloader2);
                    }
                    continue;
                }
                context.getLogger().info(RB.$((String)"downloaders.download.all.artifacts.with", (Object[])new Object[0]), new Object[]{downloaderType});
                downloaders.values().forEach(downloader -> Downloaders.download(context, downloader));
            }
        } else if (!context.getIncludedDownloaderNames().isEmpty()) {
            for (String downloaderName : context.getIncludedDownloaderNames()) {
                List<Downloader> filteredDownloaders = download.findAllActiveDownloaders().stream().filter(a -> downloaderName.equals(a.getName())).collect(Collectors.toList());
                if (!filteredDownloaders.isEmpty()) {
                    context.getLogger().info(RB.$((String)"downloaders.download.all.artifacts.from", (Object[])new Object[0]), new Object[]{downloaderName});
                    filteredDownloaders.forEach(downloader -> Downloaders.download(context, downloader));
                    continue;
                }
                context.getLogger().warn(RB.$((String)"downloaders.downloader.not.configured2", (Object[])new Object[0]), new Object[]{downloaderName});
            }
        } else {
            context.getLogger().info(RB.$((String)"downloaders.download.all.artifacts", (Object[])new Object[0]));
            for (Downloader downloader3 : download.findAllActiveDownloaders()) {
                String downloaderType = downloader3.getType();
                String downloaderName = downloader3.getName();
                if (context.getExcludedDownloaderTypes().contains(downloaderType) || context.getExcludedDownloaderNames().contains(downloaderName)) {
                    context.getLogger().info(RB.$((String)"downloaders.downloader.excluded", (Object[])new Object[0]), new Object[]{downloaderType, downloaderName});
                    continue;
                }
                Downloaders.download(context, downloader3);
            }
        }
    }

    private static void download(JReleaserContext context, Downloader downloader) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(downloader.getType());
            ProjectDownloader projectDownloader = Downloaders.createProjectDownloader(context, downloader);
            projectDownloader.download();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (DownloadException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static ProjectDownloader createProjectDownloader(JReleaserContext context, Downloader downloader) {
        return ProjectDownloader.builder().context(context).downloader(downloader).build();
    }
}

