/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.Map;
import org.jreleaser.engine.upload.ProjectUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Upload;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.UploadException;

public class Uploaders {
    public static void upload(JReleaserContext context) {
        Upload upload = context.getModel().getUpload();
        if (!upload.isEnabled()) {
            context.getLogger().info("Uploading is not enabled. Skipping.");
            return;
        }
        if (context.hasUploaderType()) {
            Map uploaders = upload.findUploadersByType(context.getUploaderType());
            if (uploaders.isEmpty()) {
                context.getLogger().debug("No uploaders match {}", new Object[]{context.getUploaderType()});
                return;
            }
            if (context.hasUploaderName()) {
                if (!uploaders.containsKey(context.getUploaderName())) {
                    context.getLogger().error("Uploader {}/{} is not configured", new Object[]{context.getUploaderType(), context.getUploaderName()});
                    return;
                }
                context.getLogger().info("Uploading with {}/{}", new Object[]{context.getUploaderType(), context.getUploaderName()});
                Uploaders.upload(context, (Uploader)uploaders.get(context.getUploaderName()));
            } else {
                context.getLogger().info("Uploading all artifacts with {}", new Object[]{context.getUploaderType()});
                uploaders.values().forEach(uploader -> Uploaders.upload(context, uploader));
            }
        } else if (context.hasUploaderName()) {
            context.getLogger().info("Uploading all artifacts to {}", new Object[]{context.getUploaderName()});
            upload.findAllUploaders().stream().filter(a -> context.getUploaderName().equals(a.getName())).forEach(uploader -> Uploaders.upload(context, uploader));
        } else {
            context.getLogger().info("Uploading all artifacts");
            upload.findAllUploaders().forEach(uploader -> Uploaders.upload(context, uploader));
        }
    }

    private static void upload(JReleaserContext context, Uploader uploader) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(uploader.getType());
            ProjectUploader projectUploader = Uploaders.createProjectUploader(context, uploader);
            projectUploader.upload();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (UploadException e) {
            throw new JReleaserException("Unexpected error", (Throwable)e);
        }
    }

    private static ProjectUploader createProjectUploader(JReleaserContext context, Uploader uploader) {
        return ProjectUploader.builder().context(context).uploader(uploader).build();
    }
}

