/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.ArtifactUploader;
import org.jreleaser.model.uploader.spi.ArtifactUploaderFactory;

public class ArtifactUploaders {
    public static <U extends Uploader> ArtifactUploader<U> findUploader(JReleaserContext context, U uploader) {
        Map<String, ArtifactUploader> uploaders = StreamSupport.stream(ServiceLoader.load(ArtifactUploaderFactory.class, ArtifactUploaders.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ArtifactUploaderFactory::getName, factory -> factory.getArtifactUploader(context)));
        if (uploaders.containsKey(uploader.getType())) {
            ArtifactUploader artifactUploader = uploaders.get(uploader.getType());
            artifactUploader.setUploader(uploader);
            return artifactUploader;
        }
        throw new JReleaserException("Unsupported uploader " + uploader.getType());
    }
}

