/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.release;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.ReleaserBuilder;
import org.jreleaser.model.releaser.spi.ReleaserBuilderFactory;

public class Releasers {
    public static void release(JReleaserContext context) throws ReleaseException {
        Releasers.releaserFor(context).release();
    }

    public static Releaser releaserFor(JReleaserContext context) {
        return Releasers.findReleaser(context).configureWith(context).build();
    }

    private static <RB extends ReleaserBuilder> RB findReleaser(JReleaserContext context) {
        Map<String, ReleaserBuilder> builders = StreamSupport.stream(ServiceLoader.load(ReleaserBuilderFactory.class, Releasers.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ReleaserBuilderFactory::getName, ReleaserBuilderFactory::getBuilder));
        if (null != context.getModel().getRelease().getGithub()) {
            return (RB)builders.get("github");
        }
        if (null != context.getModel().getRelease().getGitlab()) {
            return (RB)builders.get("gitlab");
        }
        if (null != context.getModel().getRelease().getGitea()) {
            return (RB)builders.get("gitea");
        }
        if (null != context.getModel().getRelease().getCodeberg()) {
            return (RB)builders.get("codeberg");
        }
        if (null != context.getModel().getRelease().getGeneric()) {
            return (RB)builders.get("generic");
        }
        throw new JReleaserException("No suitable git releaser has been configured");
    }
}

