/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.checksum;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.StringUtils;

public class Checksum {
    public static void collectAndWriteChecksums(JReleaserContext context) throws JReleaserException {
        context.getLogger().info("Calculating checksums");
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("checksum");
        LinkedHashMap<Algorithm, List> checksums = new LinkedHashMap<Algorithm, List>();
        if (context.getModel().getChecksum().isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm2 : context.getModel().getChecksum().getAlgorithms()) {
                    Checksum.readHash(context, algorithm2, artifact);
                    List list2 = checksums.computeIfAbsent(algorithm2, k -> new ArrayList());
                    list2.add(artifact.getHash(algorithm2) + "  " + artifact.getEffectivePath(context).getFileName());
                }
            }
        }
        for (Distribution distribution : context.getModel().getActiveDistributions()) {
            for (Artifact artifact : distribution.getArtifacts()) {
                if (!artifact.isActive()) continue;
                for (Algorithm algorithm3 : context.getModel().getChecksum().getAlgorithms()) {
                    Checksum.readHash(context, distribution, algorithm3, artifact);
                    List list3 = checksums.computeIfAbsent(algorithm3, k -> new ArrayList());
                    list3.add(artifact.getHash(algorithm3) + "  " + artifact.getEffectivePath(context).getFileName());
                }
            }
        }
        if (checksums.isEmpty()) {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            context.getLogger().info("No files configured for checksum. Skipping");
            return;
        }
        checksums.forEach((algorithm, list) -> {
            Path checksumsFilePath = context.getChecksumsDirectory().resolve(context.getModel().getChecksum().getResolvedName(context, algorithm));
            String newContent = String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
            try {
                String oldContent;
                if (Files.exists(checksumsFilePath, new LinkOption[0]) && newContent.equals(oldContent = new String(Files.readAllBytes(checksumsFilePath)))) {
                    context.getLogger().restorePrefix();
                    context.getLogger().decreaseIndent();
                    return;
                }
            }
            catch (IOException oldContent) {
                // empty catch block
            }
            try {
                if (StringUtils.isNotBlank((String)newContent)) {
                    Files.createDirectories(context.getChecksumsDirectory(), new FileAttribute[0]);
                    Files.write(checksumsFilePath, newContent.getBytes(), new OpenOption[0]);
                } else {
                    Files.deleteIfExists(checksumsFilePath);
                }
            }
            catch (IOException e) {
                throw new JReleaserException("Unexpected error writing checksums to " + checksumsFilePath.toAbsolutePath(), (Throwable)e);
            }
        });
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    public static void readHash(JReleaserContext context, Distribution distribution, Algorithm algorithm, Artifact artifact) throws JReleaserException {
        Path artifactPath = artifact.getEffectivePath(context, distribution);
        Path checksumPath = context.getChecksumsDirectory().resolve(distribution.getName()).resolve(artifactPath.getFileName() + "." + algorithm.formatted());
        Checksum.readHash(context, algorithm, artifact, artifactPath, checksumPath);
    }

    public static void readHash(JReleaserContext context, Algorithm algorithm, Artifact artifact) throws JReleaserException {
        Path artifactPath = artifact.getEffectivePath(context);
        Path checksumPath = context.getChecksumsDirectory().resolve(artifactPath.getFileName() + "." + algorithm.formatted());
        Checksum.readHash(context, algorithm, artifact, artifactPath, checksumPath);
    }

    private static void readHash(JReleaserContext context, Algorithm algorithm, Artifact artifact, Path artifactPath, Path checksumPath) throws JReleaserException {
        if (!Files.exists(artifactPath, new LinkOption[0])) {
            throw new JReleaserException("Artifact does not exist. " + context.relativizeToBasedir(artifactPath));
        }
        if (!Files.exists(checksumPath, new LinkOption[0])) {
            context.getLogger().debug("checksum does not exist: {}", new Object[]{context.relativizeToBasedir(checksumPath)});
            Checksum.calculateHash(context, artifactPath, checksumPath, algorithm);
        } else if (artifactPath.toFile().lastModified() > checksumPath.toFile().lastModified()) {
            context.getLogger().debug("{} is newer than {}", new Object[]{context.relativizeToBasedir(artifactPath), context.relativizeToBasedir(checksumPath)});
            Checksum.calculateHash(context, artifactPath, checksumPath, algorithm);
        }
        try {
            context.getLogger().debug("reading {}", new Object[]{context.relativizeToBasedir(checksumPath)});
            artifact.setHash(algorithm, new String(Files.readAllBytes(checksumPath)));
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error when reading hash from " + context.relativizeToBasedir(checksumPath), (Throwable)e);
        }
    }

    public static String calculateHash(JReleaserContext context, Path input, Path output) throws JReleaserException {
        return Checksum.calculateHash(context, input, output, Algorithm.SHA_256);
    }

    public static String calculateHash(JReleaserContext context, Path input, Path output, Algorithm algorithm) throws JReleaserException {
        try {
            context.getLogger().info("{}.{}", new Object[]{context.relativizeToBasedir(input), algorithm.formatted()});
            String hashcode = ChecksumUtils.checksum((Algorithm)algorithm, (byte[])Files.readAllBytes(input));
            output.toFile().getParentFile().mkdirs();
            Files.write(output, hashcode.getBytes(), new OpenOption[0]);
            return hashcode;
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error calculating checksum for " + input, (Throwable)e);
        }
    }
}

