/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.changelog;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.sdk.git.ChangelogProvider;

public class Changelog {
    public static String createChangelog(JReleaserContext context) {
        try {
            return ChangelogProvider.getChangelog((JReleaserContext)context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error when creating changelog.", (Throwable)e);
        }
    }

    public static String readChangelog(JReleaserContext context) {
        Path changelogFile = context.getOutputDirectory().resolve("release").resolve("CHANGELOG.md");
        if (Files.exists(changelogFile, new LinkOption[0])) {
            try {
                return new String(Files.readAllBytes(changelogFile)).trim();
            }
            catch (IOException e) {
                context.getLogger().warn("Could not read changelog from {}", new Object[]{context.relativizeToBasedir(changelogFile)});
            }
        }
        return "";
    }
}

