/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class JlinkAssemblerProcessor
extends AbstractAssemblerProcessor<Jlink> {
    private static final String KEY_JAVA_VERSION = "JAVA_VERSION";

    public JlinkAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path jdkPath = ((Jlink)this.assembler).getJdk().getEffectivePath(this.context, this.assembler);
        Version jdkVersion = Version.of((String)this.readJavaVersion(jdkPath));
        this.context.getLogger().debug("jdk version is {}", new Object[]{jdkVersion});
        for (Artifact targetJdk : ((Jlink)this.assembler).getTargetJdks()) {
            Path targetJdkPath = targetJdk.getEffectivePath(this.context, this.assembler);
            Version targetJdkVersion = Version.of((String)this.readJavaVersion(targetJdkPath));
            this.context.getLogger().debug("target jdk version is {}", new Object[]{jdkVersion});
            if (jdkVersion.getMajor() == targetJdkVersion.getMajor()) continue;
            throw new AssemblerProcessingException("Target JDK " + targetJdkVersion + " is not compatible with " + jdkVersion);
        }
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path jarsDirectory = inputsDirectory.resolve("jars");
        this.context.getLogger().debug("copying JARs to {}", new Object[]{this.context.relativizeToBasedir(jarsDirectory)});
        Set<Path> jars = this.copyJars(this.context, jarsDirectory);
        Set<String> moduleNames = this.resolveModuleNames(this.context, jdkPath, jars);
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName())) {
            moduleNames.add(((Jlink)this.assembler).getModuleName());
        }
        this.context.getLogger().debug("resolved moduleNames: {}", new Object[]{moduleNames});
        String imageName = ((Jlink)this.assembler).getResolvedImageName(this.context);
        for (Artifact targetJdk : ((Jlink)this.assembler).getTargetJdks()) {
            Artifact image = this.jlink(assembleDirectory, jdkPath, targetJdk, moduleNames, imageName);
            if (!StringUtils.isNotBlank((String)((Jlink)this.assembler).getImageNameTransform())) continue;
            image.setTransform(((Jlink)this.assembler).getResolvedImageNameTransform(this.context) + "-" + targetJdk.getPlatform() + ".zip");
            image.getEffectivePath(this.context);
        }
    }

    private Artifact jlink(Path assembleDirectory, Path jdkPath, Artifact targetJdk, Set<String> moduleNames, String imageName) throws AssemblerProcessingException {
        String finalImageName = imageName + "-" + targetJdk.getPlatform();
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path workDirectory = assembleDirectory.resolve("work-" + targetJdk.getPlatform());
        Path imageDirectory = workDirectory.resolve(finalImageName).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)imageDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Could not delete previous image " + finalImageName, (Throwable)e);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(jdkPath.resolve("bin").resolve("jlink").toAbsolutePath().toString());
        cmd.addAll(((Jlink)this.assembler).getArgs());
        cmd.add("--module-path");
        cmd.add(targetJdk.getEffectivePath(this.context).resolve("jmods").toAbsolutePath().toString() + ":" + assembleDirectory.resolve("jars").toAbsolutePath());
        cmd.add("--add-modules");
        cmd.add(String.join((CharSequence)",", moduleNames));
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName())) {
            cmd.add("--launcher");
            cmd.add(((Jlink)this.assembler).getExecutable() + "=" + ((Jlink)this.assembler).getModuleName() + "/" + ((Jlink)this.assembler).getJava().getMainClass());
        }
        cmd.add("--output");
        cmd.add(imageDirectory.toString());
        this.executeCommand(cmd);
        if (StringUtils.isBlank((String)((Jlink)this.assembler).getModuleName())) {
            Path jarsDirectory = imageDirectory.resolve("jars");
            try {
                Files.createDirectory(jarsDirectory, new FileAttribute[0]);
                FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)inputsDirectory.resolve("jars"), (Path)jarsDirectory);
            }
            catch (IOException e) {
                throw new AssemblerProcessingException("Could not copy JARs to " + this.context.relativizeToBasedir(jarsDirectory), (Throwable)e);
            }
            try {
                if (PlatformUtils.isWindows((String)targetJdk.getPlatform())) {
                    Files.copy(inputsDirectory.resolve(((Jlink)this.assembler).getExecutable().concat(".bat")), imageDirectory.resolve("bin").resolve(((Jlink)this.assembler).getExecutable().concat(".bat")), new CopyOption[0]);
                } else {
                    Path launcher = imageDirectory.resolve("bin").resolve(((Jlink)this.assembler).getExecutable());
                    Files.copy(inputsDirectory.resolve(((Jlink)this.assembler).getExecutable()), launcher, new CopyOption[0]);
                    FileUtils.grantExecutableAccess((Path)launcher);
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException("Could not copy launcher to " + this.context.relativizeToBasedir(jarsDirectory), (Throwable)e);
            }
        }
        try {
            Path imageZip = assembleDirectory.resolve(finalImageName + ".zip");
            this.copyFiles(this.context, imageDirectory);
            FileUtils.zip((Path)workDirectory, (Path)imageZip);
            this.context.getLogger().debug("- {}", new Object[]{imageZip.getFileName()});
            return Artifact.of((Path)imageZip, (String)targetJdk.getPlatform());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error", (Throwable)e);
        }
    }

    private String readJavaVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException("Invalid JDK [" + path.toAbsolutePath() + "] release file not found");
        }
        try {
            Properties props = new Properties();
            props.load(Files.newInputStream(release, new OpenOption[0]));
            if (props.containsKey(KEY_JAVA_VERSION)) {
                String version = props.getProperty(KEY_JAVA_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    return version.substring(1, version.length() - 1);
                }
                return version;
            }
            throw new AssemblerProcessingException("Invalid JDK release file [" + release.toAbsolutePath() + "]");
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Invalid JDK release file [" + release.toAbsolutePath() + "]", (Throwable)e);
        }
    }

    private Set<Path> copyJars(JReleaserContext context, Path jarsDirectory) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        paths.add(((Jlink)this.assembler).getMainJar().getEffectivePath(context, this.assembler));
        for (Glob glob : ((Jlink)this.assembler).getJars()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(jarsDirectory, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug("copying {}", new Object[]{path.getFileName()});
                Files.copy(path, jarsDirectory.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error when copying JAR files", (Throwable)e);
        }
        return paths;
    }

    private Set<Path> copyFiles(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (Glob glob : ((Jlink)this.assembler).getFiles()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug("copying {}", new Object[]{path.getFileName()});
                Files.copy(path, destination.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error when copying files", (Throwable)e);
        }
        return paths;
    }

    private Set<String> resolveModuleNames(JReleaserContext context, Path jdkPath, Set<Path> jars) throws AssemblerProcessingException {
        if (!((Jlink)this.assembler).getModuleNames().isEmpty()) {
            return ((Jlink)this.assembler).getModuleNames();
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(jdkPath.resolve("bin").resolve("jdeps").toAbsolutePath().toString());
        cmd.add("--multi-release");
        cmd.add("base");
        cmd.add("--print-module-deps");
        for (Path jar : jars) {
            cmd.add(jar.toAbsolutePath().toString());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(cmd, out);
        return Arrays.stream(out.toString().split(System.lineSeparator())).map(String::trim).collect(Collectors.toSet());
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = outputDirectory.resolve("inputs");
        try {
            Files.createDirectories(inputsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Could not create directories", (Throwable)e);
        }
        Path outputFile = "launcher.bat".equals(fileName) ? inputsDirectory.resolve(((Jlink)this.assembler).getExecutable().concat(".bat")) : ("launcher".equals(fileName) ? inputsDirectory.resolve(((Jlink)this.assembler).getExecutable()) : inputsDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }
}

