/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.IOException;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.sdk.git.GitSdk;

public final class ReleaseUtils {
    private ReleaseUtils() {
    }

    public static void createTag(JReleaserContext context) throws ReleaseException {
        GitService service = context.getModel().getRelease().getGitService();
        try {
            GitSdk git = GitSdk.of(context);
            Repository repository = git.getRemote();
            context.getLogger().info(RB.$((String)"git.tag", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            String tagName = service.getEffectiveTagName(context.getModel());
            context.getLogger().debug(RB.$((String)"git.tag.lookup", (Object[])new Object[0]), new Object[]{tagName});
            boolean tagged = git.findTag(tagName);
            boolean snapshot = context.getModel().getProject().isSnapshot();
            if (tagged) {
                context.getLogger().debug(RB.$((String)"git.tag.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (service.isOverwrite() || snapshot) {
                    context.getLogger().debug(RB.$((String)"git.tag.release", (Object[])new Object[0]), new Object[]{tagName});
                    ReleaseUtils.tagRelease(context, repository, tagName);
                } else if (!context.isDryrun()) {
                    throw new IllegalStateException(RB.$((String)"ERROR_git_release_existing_tag", (Object[])new Object[]{tagName}));
                }
            } else {
                context.getLogger().debug(RB.$((String)"git.tag.not.exist", (Object[])new Object[0]), new Object[]{tagName});
                context.getLogger().debug(RB.$((String)"git.tag.release", (Object[])new Object[0]), new Object[]{tagName});
                ReleaseUtils.tagRelease(context, repository, tagName);
            }
        }
        catch (IOException | IllegalStateException e) {
            context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    private static void tagRelease(JReleaserContext context, Repository repository, String tagName) throws ReleaseException {
        try {
            GitSdk gitSdk = GitSdk.of(context);
            gitSdk.tag(tagName, true, context);
            context.getLogger().info(RB.$((String)"git.push.release", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            context.getLogger().debug(RB.$((String)"git.push.tag", (Object[])new Object[0]), new Object[]{context.isDryrun()});
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(context.getModel().getRelease().getGitService().getResolvedUsername(), context.getModel().getRelease().getGitService().getResolvedToken());
            ((PushCommand)gitSdk.open().push().setDryRun(context.isDryrun()).setPushTags().setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (Exception e) {
            context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }
}

