/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.message.JMXNotification;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.notification.ServerListenerInfo;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MBeanServerNotificationDispatcher
implements NotificationListener {
    private static Logger log = LoggerFactory.getLogger(MBeanServerNotificationDispatcher.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final MBeanServer mbeanServer;
    private final CollectionMap<ObjectName, ServerListenerInfo> listenerMap = new ArrayListHashMap();
    private final JMXNioServer server;

    MBeanServerNotificationDispatcher(MBeanServer mbeanServer, JMXNioServer server) {
        if (mbeanServer == null) {
            throw new IllegalArgumentException("MBeanServer cannot be null");
        }
        this.mbeanServer = mbeanServer;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationListener(ObjectName mbeanName, NotificationFilter filter, int listenerID, String connectionID) throws Exception {
        ServerListenerInfo info = new ServerListenerInfo(listenerID, filter, connectionID);
        if (debugEnabled) {
            log.debug("adding listenerID = {}, {} to {}", new Object[]{listenerID, info, this.mbeanServer});
        }
        CollectionMap<ObjectName, ServerListenerInfo> collectionMap = this.listenerMap;
        synchronized (collectionMap) {
            if (!this.listenerMap.containsKey((Object)mbeanName)) {
                this.mbeanServer.addNotificationListener(mbeanName, this, null, (Object)mbeanName);
            }
            this.listenerMap.putValue((Object)mbeanName, (Object)info);
            if (debugEnabled) {
                log.debug("added listenerID = {}, nbListeners = {}", (Object)listenerID, (Object)this.listenerMap.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotificationListeners(ObjectName mbeanName, int[] listenerIDs) throws Exception {
        if (debugEnabled) {
            log.debug("removing listenerIDs = {} from {}", (Object)Arrays.toString(listenerIDs), (Object)mbeanName);
        }
        HashSet<Integer> idSet = new HashSet<Integer>();
        Object object = listenerIDs;
        int n = listenerIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = object[n2];
            idSet.add(n3);
            ++n2;
        }
        ArrayList<ServerListenerInfo> toRemove = new ArrayList<ServerListenerInfo>();
        CollectionMap<ObjectName, ServerListenerInfo> collectionMap = this.listenerMap;
        synchronized (collectionMap) {
            if (this.listenerMap.containsKey((Object)mbeanName)) {
                object = this.listenerMap.getValues((Object)mbeanName).iterator();
                while (object.hasNext()) {
                    ServerListenerInfo info = (ServerListenerInfo)object.next();
                    if (!idSet.contains(info.getListenerID())) continue;
                    toRemove.add(info);
                }
            }
            if (toRemove.isEmpty()) {
                throw new ListenerNotFoundException("found no listener for " + mbeanName);
            }
            object = toRemove.iterator();
            while (object.hasNext()) {
                ServerListenerInfo info = (ServerListenerInfo)object.next();
                this.listenerMap.removeValue((Object)mbeanName, (Object)info);
            }
            if (!this.listenerMap.containsKey((Object)mbeanName)) {
                this.mbeanServer.removeNotificationListener(mbeanName, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (debugEnabled) {
            log.debug("received notification for mbean={} : {}", handback, (Object)notification);
        }
        ObjectName mbeanName = (ObjectName)handback;
        ArrayList infos = null;
        CollectionMap<ObjectName, ServerListenerInfo> collectionMap = this.listenerMap;
        synchronized (collectionMap) {
            Collection coll = this.listenerMap.getValues((Object)mbeanName);
            if (coll != null) {
                infos = new ArrayList(coll);
            }
        }
        if (infos != null) {
            Map<String, JMXMessageHandler> handlersMap;
            ArrayListHashMap listenersPerConnection = new ArrayListHashMap();
            for (ServerListenerInfo info : infos) {
                if (!info.getFilter().isNotificationEnabled(notification)) continue;
                listenersPerConnection.putValue((Object)info.getConnectionID(), (Object)info.getListenerID());
            }
            if (!listenersPerConnection.isEmpty() && !(handlersMap = this.server.getMessageHandlers(listenersPerConnection.keySet())).isEmpty()) {
                for (Map.Entry<String, JMXMessageHandler> entry : handlersMap.entrySet()) {
                    Collection listenerIDs = listenersPerConnection.getValues((Object)entry.getKey());
                    if (listenerIDs == null || listenerIDs.isEmpty()) continue;
                    if (debugEnabled) {
                        log.debug("sending notification to listeners {} : via connection {}", (Object)listenerIDs, (Object)entry.getValue().getChannels().getConnectionID());
                    }
                    try {
                        entry.getValue().sendMessage(new JMXNotification(-1L, notification, listenerIDs.toArray(new Integer[listenerIDs.size()])));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

