/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.io.EOFException;
import java.lang.management.ManagementFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.remote.JMXAuthenticator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jppf.jmx.JPPFJMXProperties;
import org.jppf.jmxremote.JMXConnectionStatusEvent;
import org.jppf.jmxremote.JMXConnectionStatusListener;
import org.jppf.jmxremote.JPPFJMXConnectorServer;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.jppf.jmxremote.nio.ConnectionEventType;
import org.jppf.jmxremote.nio.JMXContext;
import org.jppf.jmxremote.nio.JMXMessageReader;
import org.jppf.jmxremote.nio.JMXMessageWriter;
import org.jppf.jmxremote.nio.JMXNioServerMBean;
import org.jppf.jmxremote.notification.ServerNotificationHandler;
import org.jppf.management.ObjectNameCache;
import org.jppf.nio.NioConstants;
import org.jppf.nio.NioHelper;
import org.jppf.nio.NioServer;
import org.jppf.nio.SSLHandler;
import org.jppf.nio.SSLHandlerImpl;
import org.jppf.nio.StatelessNioServer;
import org.jppf.nio.acceptor.AcceptorNioServer;
import org.jppf.ssl.SSLHelper;
import org.jppf.ssl.SSLHelper2;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFIdentifiers;
import org.jppf.utils.Operator;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.concurrent.SynchronizedInteger;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JMXNioServer
extends StatelessNioServer<JMXContext>
implements JMXNioServerMBean {
    private static final Logger log = LoggerFactory.getLogger(JMXNioServer.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private static final AtomicLong connectionIdSequence = new AtomicLong(0L);
    private final Map<String, ChannelsPair> channelsByConnectionID = new HashMap<String, ChannelsPair>();
    private final CollectionMap<Integer, String> connectionsByServerPort = new ArrayListHashMap();
    private final Object mapsLock = new Object();
    private final List<JMXConnectionStatusListener> connectionStatusListeners = new CopyOnWriteArrayList<JMXConnectionStatusListener>();
    private final ServerNotificationHandler serverNotificationHandler;
    private int peakConnections;
    private final JPPFStatistics stats;
    private final SynchronizedInteger peakPeakPendingMessages = new SynchronizedInteger(0);

    JMXNioServer() throws Exception {
        super(String.valueOf(JPPFIdentifiers.serverName((int)65528)) + "-" + instanceCount.incrementAndGet(), 65528, false, null);
        this.serverNotificationHandler = new ServerNotificationHandler(this);
        this.selectTimeout = NioConstants.DEFAULT_SELECT_TIMEOUT;
        this.registerMBean();
        AcceptorNioServer acceptor = (AcceptorNioServer)NioHelper.getServer((int)65529);
        JPPFStatistics jPPFStatistics = this.stats = acceptor != null ? acceptor.getStats() : null;
        if (debugEnabled) {
            log.debug("initialized {}, stats = {}", (Object)this, (Object)(this.stats == null ? "null" : String.valueOf(this.stats.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this.stats))));
        }
    }

    protected void handleRead(SelectionKey key) throws Exception {
        ChannelsPair pair = (ChannelsPair)((Object)key.attachment());
        if (pair.isClosing()) {
            return;
        }
        JMXMessageReader.read(pair.readingContext());
    }

    protected void handleWrite(SelectionKey key) throws Exception {
        JMXNioServer.updateInterestOpsNoWakeup((SelectionKey)key, (int)4, (boolean)false);
        ChannelsPair pair = (ChannelsPair)((Object)key.attachment());
        if (JMXMessageWriter.write(pair.writingContext())) {
            JMXNioServer.updateInterestOpsNoWakeup((SelectionKey)key, (int)4, (boolean)true);
        }
    }

    protected void handleSelectionException(SelectionKey key, Exception e) {
        ChannelsPair pair = (ChannelsPair)((Object)key.attachment());
        if (pair != null) {
            if (e instanceof CancelledKeyException) {
                if (!pair.isClosing() && !pair.isClosed()) {
                    log.error("error on {} :\n{}", (Object)pair, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    this.closeConnection(pair, e, false);
                }
            } else if (e instanceof EOFException) {
                if (debugEnabled) {
                    log.debug("error on {} :\n{}", (Object)pair, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
                this.closeConnection(pair, e, false);
            } else {
                log.error("error on {} :\n{}", (Object)pair, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                this.closeConnection(pair, e, false);
            }
        } else {
            log.error("error on {} :\n{}", (Object)JMXNioServer.toString((SelectionKey)key), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ServerSocketChannel serverSocketChannel, SocketChannel channel, SSLHandler sslHandler, boolean ssl, boolean peer, Object ... params) {
        try {
            if (debugEnabled) {
                log.debug("accepting socketChannel = {}", (Object)channel);
            }
            NioServer acceptor = NioHelper.getServer((int)65529);
            Map env = (Map)serverSocketChannel.keyFor(acceptor.getSelector()).attachment();
            InetSocketAddress saddr = (InetSocketAddress)serverSocketChannel.getLocalAddress();
            int port = saddr.getPort();
            InetAddress addr = saddr.getAddress();
            String ip = addr.getHostAddress();
            if (addr instanceof Inet6Address) {
                ip = "[" + ip + "]";
            }
            String connectionID = String.format("%s://%s:%d %d", "jppf", ip, port, connectionIdSequence.incrementAndGet());
            ChannelsPair pair = this.createChannelsPair(env, connectionID, port, channel, ssl, false);
            pair.setServerSide(true);
            Object object = this.mapsLock;
            synchronized (object) {
                this.channelsByConnectionID.put(connectionID, pair);
                int n = this.channelsByConnectionID.size();
                if (n > this.peakConnections) {
                    this.peakConnections = n;
                }
                this.connectionsByServerPort.putValue((Object)port, (Object)connectionID);
            }
            ConnectionEventType.OPENED.fireNotification(this.connectionStatusListeners, new JMXConnectionStatusEvent(connectionID));
            this.registerChannel(pair, channel);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ChannelsPair createChannelsPair(Map<String, ?> env, String connectionID, int port, SocketChannel channel, boolean ssl, boolean client) throws Exception {
        if (debugEnabled) {
            log.debug("connectionID={}, port={}, ssl={}, client={}, channel={}, env={}", new Object[]{connectionID, port, ssl, client, channel, env});
        }
        if (channel.isBlocking()) {
            channel.configureBlocking(false);
        }
        JMXContext readingChannel = this.createContext(env, channel, ssl, true, null, client);
        JMXContext writingChannel = this.createContext(env, channel, ssl, false, readingChannel.getSSLHandler(), client);
        JMXAuthenticator authenticator = client ? null : (JMXAuthenticator)env.get("jmx.remote.authenticator");
        ChannelsPair pair = new ChannelsPair(readingChannel, writingChannel, this, authenticator);
        if (!client) {
            pair.setAuhtorizationChecker(env.get("jmx.remote.x.authorization.checker"));
        }
        JMXMessageHandler handler = new JMXMessageHandler(pair, env);
        JPPFJMXConnectorServer connectorServer = (JPPFJMXConnectorServer)env.get("jppf.jmxremote.internal.connectorserver");
        pair.setConnectionID(connectionID);
        pair.setJxmConnectorServer(connectorServer);
        pair.setServerPort(port);
        readingChannel.setMessageHandler(handler);
        writingChannel.setMessageHandler(handler);
        if (debugEnabled) {
            log.debug("created {}, env = {}", (Object)pair, env);
        }
        return pair;
    }

    private JMXContext createContext(Map<String, ?> env, SocketChannel channel, boolean ssl, boolean reading, SSLHandler sslHandler, boolean client) throws Exception {
        JMXContext context = this.createNioContext(reading, channel, env);
        if (debugEnabled) {
            log.debug("creating channel wrapper for ssl={}, reading={}, sslHandler={}, context={}, env={}", new Object[]{ssl, reading, sslHandler, context, env});
        }
        context.setSsl(ssl);
        if (ssl) {
            if (sslHandler == null) {
                if (debugEnabled) {
                    log.debug("creating SSLEngine for {}", (Object)context);
                }
                JMXNioServer.configureSSL(env, context, client);
            } else {
                context.setSSLHandler(sslHandler);
            }
        }
        return context;
    }

    private static void configureSSL(Map<String, ?> env, JMXContext context, boolean client) throws Exception {
        if (debugEnabled) {
            log.debug("configuring {}-side SSL for {}, env = {}", new Object[]{client ? "client" : "server", context, env});
        }
        env.put(JPPFJMXProperties.TLS_ENABLED.getName(), "true");
        env.put("jppf.ssl", true);
        SSLHelper2 helper = SSLHelper.getJPPFJMXremoteSSLHelper(env);
        SocketChannel channel = context.getSocketChannel();
        SSLContext sslContext = helper.getSSLContext(65528);
        InetSocketAddress addr = (InetSocketAddress)channel.getRemoteAddress();
        SSLEngine engine = sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
        SSLParameters params = helper.getSSLParameters();
        engine.setUseClientMode(client);
        engine.setSSLParameters(params);
        if (debugEnabled) {
            log.debug("created SSLEngine: useClientMode = {}, parameters = {}", (Object)engine.getUseClientMode(), (Object)engine.getSSLParameters());
        }
        SSLHandlerImpl sslHandler = new SSLHandlerImpl(channel, engine);
        context.setSSLHandler((SSLHandler)sslHandler);
    }

    public JMXContext createNioContext(Object ... params) {
        return new JMXContext(this, (Boolean)params[0], (SocketChannel)params[1], (Map)params[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(ChannelsPair pair, Exception exception, boolean clientRequestedClose) {
        Exception ex;
        String connectionID;
        block29: {
            block26: {
                block27: {
                    connectionID = pair.getConnectionID();
                    if (debugEnabled) {
                        log.debug("closing JMX channels for {}-side connectionID = {}", (Object)(pair.isServerSide() ? "server" : "client"), (Object)connectionID);
                    }
                    ex = exception;
                    if (!pair.isClosed() && (!pair.isClosing() || clientRequestedClose)) break block26;
                    if (!pair.isServerSide()) break block27;
                    Object object = this.mapsLock;
                    synchronized (object) {
                        this.channelsByConnectionID.remove(connectionID);
                        this.connectionsByServerPort.removeValue((Object)pair.getServerPort(), (Object)connectionID);
                    }
                }
                return;
            }
            try {
                try {
                    pair.requestClose();
                    pair.close(exception);
                    pair.getMessageHandler().close();
                }
                catch (Exception e) {
                    if (ex == null) {
                        ex = e;
                    }
                    if (!pair.isServerSide()) break block29;
                    Object object = this.mapsLock;
                    synchronized (object) {
                        this.channelsByConnectionID.remove(connectionID);
                        this.connectionsByServerPort.removeValue((Object)pair.getServerPort(), (Object)connectionID);
                        break block29;
                    }
                }
            }
            catch (Throwable throwable) {
                if (pair.isServerSide()) {
                    Object object = this.mapsLock;
                    synchronized (object) {
                        this.channelsByConnectionID.remove(connectionID);
                        this.connectionsByServerPort.removeValue((Object)pair.getServerPort(), (Object)connectionID);
                    }
                }
                throw throwable;
            }
            if (pair.isServerSide()) {
                Object object = this.mapsLock;
                synchronized (object) {
                    this.channelsByConnectionID.remove(connectionID);
                    this.connectionsByServerPort.removeValue((Object)pair.getServerPort(), (Object)connectionID);
                }
            }
        }
        if (pair.isServerSide()) {
            ConnectionEventType type = ex != null ? ConnectionEventType.FAILED : ConnectionEventType.CLOSED;
            try {
                if (ex != null) {
                    this.fireNotification(type, new JMXConnectionStatusEvent(connectionID, ex));
                } else {
                    this.fireNotification(type, new JMXConnectionStatusEvent(connectionID));
                }
            }
            catch (Exception e) {
                log.error("error firing {} notification for connectionID={}, exception={}:\n{}", new Object[]{type, connectionID, ex, ExceptionUtils.getStackTrace((Throwable)e)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        HashMap<String, ChannelsPair> connectionMap = null;
        Object object = this.mapsLock;
        synchronized (object) {
            connectionMap = new HashMap<String, ChannelsPair>(this.channelsByConnectionID);
            for (Map.Entry entry : connectionMap.entrySet()) {
                try {
                    this.closeConnection((ChannelsPair)((Object)entry.getValue()), null, false);
                }
                catch (Exception e) {
                    log.error("error closing connectionID {} : {}", entry.getKey(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.channelsByConnectionID.clear();
            this.connectionsByServerPort.clear();
        }
        super.removeAllConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnections(int port) {
        Object object = this.mapsLock;
        synchronized (object) {
            Collection coll = this.connectionsByServerPort.getValues((Object)port);
            if (coll != null) {
                ArrayList connectionIDs = new ArrayList(coll);
                for (String connectionID : connectionIDs) {
                    try {
                        ChannelsPair pair = this.channelsByConnectionID.get(connectionID);
                        if (pair == null) continue;
                        this.closeConnection(pair, null, false);
                    }
                    catch (Exception e) {
                        log.error("error closing connectionID " + connectionID, (Throwable)e);
                    }
                }
            }
        }
    }

    private void registerMBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, ObjectNameCache.getObjectName((String)("org.jppf:name=JMXNioServer,type=debug,instance=-" + this.getName())));
        }
        catch (Exception e) {
            log.error("error creating JPPF JMX remote server", (Throwable)e);
        }
    }

    public void addConnectionStatusListener(JMXConnectionStatusListener listener) {
        if (listener != null) {
            this.connectionStatusListeners.add(listener);
        }
    }

    public void removeConnectionStatusListener(JMXConnectionStatusListener listener) {
        if (listener != null) {
            this.connectionStatusListeners.remove(listener);
        }
    }

    private void fireNotification(ConnectionEventType type, JMXConnectionStatusEvent event) {
        type.fireNotification(this.connectionStatusListeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JMXMessageHandler> getMessageHandlers(Collection<String> connectionIDs) {
        HashMap<String, JMXMessageHandler> result = new HashMap<String, JMXMessageHandler>(connectionIDs.size());
        Object object = this.mapsLock;
        synchronized (object) {
            for (String connectionID : connectionIDs) {
                ChannelsPair channels = this.channelsByConnectionID.get(connectionID);
                if (channels == null) continue;
                result.put(connectionID, channels.getMessageHandler());
            }
        }
        return result;
    }

    ServerNotificationHandler getServerNotificationHandler() {
        return this.serverNotificationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stats() {
        StringBuilder sb = new StringBuilder();
        Object object = this.mapsLock;
        synchronized (object) {
            sb.append("nbConnections = ").append(this.channelsByConnectionID.size()).append('\n');
            sb.append("peakConnections = ").append(this.peakConnections).append('\n');
            sb.append("connectionsByServerPort:");
            for (Map.Entry entry : this.connectionsByServerPort.entrySet()) {
                sb.append("\n  ").append(entry.getKey()).append(" --> ").append(((Collection)entry.getValue()).size());
            }
        }
        return sb.toString();
    }

    public JPPFStatistics getStats() {
        return this.stats;
    }

    protected void initReaderAndWriter() {
    }

    protected void initNioHandlers() {
        super.initNioHandlers();
        this.acceptHandler = null;
    }

    @Override
    public int getPeakPendingMessages() {
        return this.peakPeakPendingMessages.get();
    }

    void updatePeakPendingMessages(int value) {
        this.peakPeakPendingMessages.compareAndSet((ComparisonOperator)Operator.LESS_THAN, value);
    }
}

