/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.management.ObjectName;
import org.jppf.jmx.JMXHelper;
import org.jppf.jmxremote.message.AbstractJMXMessage;
import org.jppf.jmxremote.message.JMXResponse;
import org.jppf.jmxremote.message.JPPFObjectName;

public class JMXRequest
extends AbstractJMXMessage {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_PARAMS = new Object[0];
    private Object[] params;
    private transient JMXResponse response;

    public JMXRequest(long messageID, byte requestType, Object ... params) {
        super(messageID, requestType);
        this.params = params == null || params.length == 0 ? NO_PARAMS : params;
    }

    public Object[] getParams() {
        return this.params;
    }

    public JMXResponse getResponse() {
        return this.response;
    }

    public void setResponse(JMXResponse response) {
        this.response = response;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "messageID=" + this.getMessageID() + ", messageType=" + JMXHelper.name((byte)this.getMessageType()) + ", params=" + Arrays.deepToString(this.params) + ']';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int n = this.params.length;
        out.writeByte(n);
        if (n > 0) {
            Object[] objectArray = this.params;
            int n2 = this.params.length;
            int n3 = 0;
            while (n3 < n2) {
                Object o = objectArray[n3];
                out.writeObject(o instanceof ObjectName ? new JPPFObjectName((ObjectName)o) : o);
                ++n3;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readByte();
        if (n <= 0) {
            this.params = NO_PARAMS;
        } else {
            this.params = new Object[n];
            int i = 0;
            while (i < n) {
                this.params[i] = in.readObject();
                if (this.params[i] instanceof JPPFObjectName) {
                    this.params[i] = ((JPPFObjectName)this.params[i]).getObjectName();
                }
                ++i;
            }
        }
    }
}

