/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.client.JPPFJob;
import org.jppf.client.event.JobEvent;
import org.jppf.client.event.JobListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFJobStream
extends JobListenerAdapter
implements Iterable<JPPFJob>,
Iterator<JPPFJob>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractJPPFJobStream.class);
    private final int concurrencyLimit;
    private int currentNbJobs;
    private int submittedJobCount;
    private int executedJobCount;
    private int taskCount;
    private final Lock lock = new ReentrantLock();
    private final Condition concurrencyLimitCondition = this.lock.newCondition();
    private final Condition endOfStreamCondition = this.lock.newCondition();

    public AbstractJPPFJobStream(int concurrencyLimit) {
        this.concurrencyLimit = concurrencyLimit;
        this.currentNbJobs = 0;
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public JPPFJob next() throws NoSuchElementException {
        this.lock.lock();
        try {
            if (!this.hasNext()) {
                this.endOfStreamCondition.signalAll();
                throw new NoSuchElementException();
            }
            while (this.currentNbJobs >= this.concurrencyLimit) {
                try {
                    this.concurrencyLimitCondition.await();
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            JPPFJob jPPFJob = this.buildJob();
            return jPPFJob;
        }
        finally {
            this.lock.unlock();
        }
    }

    private JPPFJob buildJob() {
        JPPFJob job = this.createNextJob();
        if (job == null || job.getJobTasks().isEmpty()) {
            return null;
        }
        ++this.submittedJobCount;
        this.taskCount += job.getJobTasks().size();
        job.addJobListener(this);
        ++this.currentNbJobs;
        return job;
    }

    protected abstract JPPFJob createNextJob();

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    @Override
    public void jobEnded(JobEvent event) {
        this.lock.lock();
        try {
            --this.currentNbJobs;
            ++this.executedJobCount;
            this.concurrencyLimitCondition.signalAll();
            this.endOfStreamCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.processResults(event.getJob());
    }

    protected abstract void processResults(JPPFJob var1);

    @Override
    public Iterator<JPPFJob> iterator() {
        return this;
    }

    @Override
    public abstract void close() throws Exception;

    public boolean hasPendingJob() {
        this.lock.lock();
        try {
            boolean bl = this.currentNbJobs > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getJobCount() {
        this.lock.lock();
        try {
            int n = this.submittedJobCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getExecutedJobCount() {
        this.lock.lock();
        try {
            int n = this.executedJobCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getTaskCount() {
        this.lock.lock();
        try {
            int n = this.taskCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitEndOfStream() {
        this.lock.lock();
        try {
            while (this.hasNext() || this.hasPendingJob()) {
                this.endOfStreamCondition.await();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            log.warn("thread interrupted while awaiting end-of-stream", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

