/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jppf.client.JPPFJob;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.client.persistence.JobPersistenceException;
import org.jppf.node.protocol.Task;
import org.jppf.serialization.SerializationUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ObjectSerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilePersistenceManager
implements JobPersistence<String> {
    private static Logger log = LoggerFactory.getLogger(DefaultFilePersistenceManager.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    public static final String DEFAULT_PREFIX = "job";
    public static final String DEFAULT_EXT = ".ser";
    private final File root;
    private final ObjectSerializerImpl serializer = new ObjectSerializerImpl();
    private final String prefix;
    private final String ext;

    public DefaultFilePersistenceManager(File root) {
        this(root, DEFAULT_PREFIX, DEFAULT_EXT);
    }

    public DefaultFilePersistenceManager(File root, String prefix, String ext) {
        if (root == null) {
            throw new NullPointerException("the root path cannot be null");
        }
        this.root = DefaultFilePersistenceManager.initialize(root);
        this.prefix = prefix == null || "".equals(prefix) ? DEFAULT_PREFIX : prefix;
        this.ext = ext == null || "".equals(ext) ? null : ext;
    }

    public DefaultFilePersistenceManager(String root) {
        this(root, DEFAULT_PREFIX, DEFAULT_EXT);
    }

    public DefaultFilePersistenceManager(String root, String prefix, String ext) {
        if (root == null) {
            throw new IllegalArgumentException("the root path cannot be null");
        }
        this.root = DefaultFilePersistenceManager.initialize(new File(root));
        this.prefix = prefix == null || "".equals(prefix) ? DEFAULT_PREFIX : prefix;
        this.ext = ext == null || "".equals(ext) ? null : ext;
    }

    private static File initialize(File root) {
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new IllegalArgumentException("root path " + root + " could not be created");
            }
        } else if (!root.isDirectory()) {
            throw new IllegalArgumentException("root path '" + root.getPath() + "' is not a directory");
        }
        return root;
    }

    @Override
    public String computeKey(JPPFJob job) {
        return job.getUuid();
    }

    @Override
    public synchronized Collection<String> allKeys() throws JobPersistenceException {
        File[] files = this.root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                if (path.isDirectory()) {
                    return false;
                }
                String name = path.getName();
                if (DefaultFilePersistenceManager.this.ext == null) {
                    return name.startsWith(DefaultFilePersistenceManager.this.prefix);
                }
                return name.endsWith(DefaultFilePersistenceManager.this.ext) && name.startsWith(DefaultFilePersistenceManager.this.prefix);
            }
        });
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(files.length);
        for (File f : files) {
            String s = f.getName().substring(this.prefix.length());
            if (this.ext != null) {
                int idx = s.lastIndexOf(this.ext);
                s = s.substring(0, idx);
            }
            result.add(s);
        }
        return result;
    }

    @Override
    public synchronized JPPFJob loadJob(String key) throws JobPersistenceException {
        InputStream is = null;
        try {
            File file = this.fileFromKey(key);
            if (debugEnabled) {
                log.debug("loading job key=" + key + ", file=" + file);
            }
            is = new BufferedInputStream(new FileInputStream(file));
            JPPFJob job = (JPPFJob)this.serializer.deserialize(is, false);
            boolean end = false;
            while (!end) {
                int size = 0;
                try {
                    size = SerializationUtils.readInt((InputStream)is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (size > 0) {
                    ArrayList tasks = new ArrayList(size);
                    for (int i = 0; i < size; ++i) {
                        tasks.add((Task)this.serializer.deserialize(is, false));
                    }
                    job.getResults().addResults(tasks);
                    continue;
                }
                end = true;
            }
            if (debugEnabled) {
                log.debug("loaded job " + job);
            }
            JPPFJob jPPFJob = job;
            return jPPFJob;
        }
        catch (Exception e) {
            throw new JobPersistenceException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new JobPersistenceException(e);
                }
            }
        }
    }

    @Override
    public synchronized void storeJob(String key, JPPFJob job, List<Task<?>> tasks) throws JobPersistenceException {
        if (debugEnabled) {
            log.debug("storing job " + job + ", key=" + key + ", nbTasks=" + tasks.size());
        }
        OutputStream os = null;
        try {
            boolean isNewFile;
            File file = this.fileFromKey(key);
            if (debugEnabled) {
                log.debug("storing to file " + file);
            }
            boolean bl = isNewFile = !file.exists();
            if (isNewFile) {
                os = new BufferedOutputStream(new FileOutputStream(file));
                this.serializer.serialize((Object)job, os);
            }
            if (!tasks.isEmpty()) {
                os = new BufferedOutputStream(new FileOutputStream(file, true));
                SerializationUtils.writeInt((int)tasks.size(), (OutputStream)os);
                for (Task<?> task : tasks) {
                    this.serializer.serialize(task, os);
                }
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new JobPersistenceException(e);
                }
            }
        }
    }

    @Override
    public synchronized void deleteJob(String key) throws JobPersistenceException {
        File file = this.fileFromKey(key);
        if (debugEnabled) {
            log.debug("deleting job key=" + key + ", file=" + file);
        }
        if (!file.delete()) {
            throw new JobPersistenceException("could not delete job with key '" + key + '\'');
        }
    }

    private File fileFromKey(String key) {
        return new File(this.root, this.prefix + key + (this.ext == null ? "" : this.ext));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("root=").append(this.root.getPath());
        sb.append(", file prefix=").append(this.prefix);
        sb.append(", file extension=").append(this.ext == null ? "none" : this.ext);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void close() {
    }
}

